/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx;

import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.scene.image.Image;
import javafx.scene.shape.Shape;
import org.eclipse.gef4.fx.nodes.IConnectionInterpolator;
import org.eclipse.gef4.fx.nodes.IConnectionRouter;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.layout.ILayoutAlgorithm;

public class ZestProperties {
    public static final String ELEMENT_LAYOUT_IRRELEVANT = "element-layout-irrelevant";
    public static final Boolean ELEMENT_LAYOUT_IRRELEVANT_DEFAULT = false;
    public static final String ELEMENT_CSS_CLASS = "css-class";
    public static final String ELEMENT_CSS_ID = "css-id";
    public static final String ELEMENT_LABEL = "label";
    public static final String EDGE_CURVE_CSS_STYLE = "edge-curve-css-style";
    public static final String EDGE_CONTROL_POINTS = "edge-control-points";
    public static final String NODE_RECT_CSS_STYLE = "node-rect-css-style";
    public static final String ELEMENT_LABEL_CSS_STYLE = "element-label-css-style";
    public static final String ELEMENT_EXTERNAL_LABEL_CSS_STYLE = "element-external-label-css-style";
    public static final String ELEMENT_EXTERNAL_LABEL = "element-external-label";
    public static final String ELEMENT_EXTERNAL_LABEL_POSITION = "element-external-label-position";
    public static final String EDGE_LABEL_POSITION = "edge-label-position";
    public static final String EDGE_SOURCE_LABEL_POSITION = "edge-source-label-position";
    public static final String EDGE_TARGET_LABEL_POSITION = "edge-target-label-position";
    public static final String NODE_ICON = "icon";
    public static final String NODE_SIZE = "size";
    public static final String NODE_POSITION = "position";
    public static final String NODE_TOOLTIP = "tooltip";
    public static final String NODE_FISHEYE = "fisheye";
    public static final String EDGE_TARGET_DECORATION = "target-decoration";
    public static final String EDGE_SOURCE_DECORATION = "source-decoration";
    public static final String EDGE_TARGET_LABEL = "target-label";
    public static final String EDGE_SOURCE_LABEL = "source-label";
    public static final String EDGE_ROUTER = "edge-router";
    public static final String EDGE_INTERPOLATOR = "edge-interpolator";
    public static final String GRAPH_LAYOUT_ALGORITHM = "layout";
    public static Boolean NODE_FISHEYE_DEFAULT = false;

    public static List<Point> getControlPoints(Edge edge) {
        Object controlPoints = edge.getAttributes().get((Object)EDGE_CONTROL_POINTS);
        if (controlPoints instanceof List) {
            return (List)controlPoints;
        }
        return Collections.emptyList();
    }

    public static String getCssClass(Edge edge) {
        return (String)edge.attributesProperty().get((Object)ELEMENT_CSS_CLASS);
    }

    public static String getCssClass(Node node) {
        return (String)node.attributesProperty().get((Object)ELEMENT_CSS_CLASS);
    }

    public static String getCssId(Edge edge) {
        return (String)edge.attributesProperty().get((Object)ELEMENT_CSS_ID);
    }

    public static String getCssId(Node node) {
        return (String)node.attributesProperty().get((Object)ELEMENT_CSS_ID);
    }

    public static String getEdgeCurveCssStyle(Edge edge) {
        return (String)edge.attributesProperty().get((Object)EDGE_CURVE_CSS_STYLE);
    }

    public static String getExternalLabel(Edge edge) {
        Object value = edge.attributesProperty().get((Object)ELEMENT_EXTERNAL_LABEL);
        if (value instanceof Provider) {
            return (String)((Provider)value).get();
        }
        return (String)value;
    }

    public static String getExternalLabel(Node node) {
        Object value = node.attributesProperty().get((Object)ELEMENT_EXTERNAL_LABEL);
        if (value instanceof Provider) {
            return (String)((Provider)value).get();
        }
        return (String)value;
    }

    public static String getExternalLabelCssStyle(Edge edge) {
        return (String)edge.attributesProperty().get((Object)ELEMENT_EXTERNAL_LABEL_CSS_STYLE);
    }

    public static String getExternalLabelCssStyle(Node node) {
        return (String)node.attributesProperty().get((Object)ELEMENT_EXTERNAL_LABEL_CSS_STYLE);
    }

    public static Point getExternalLabelPosition(Edge edge) {
        Object object = edge.getAttributes().get((Object)ELEMENT_EXTERNAL_LABEL_POSITION);
        if (object instanceof Point) {
            return (Point)object;
        }
        return null;
    }

    public static Point getExternalLabelPosition(Node node) {
        Object object = node.getAttributes().get((Object)ELEMENT_EXTERNAL_LABEL_POSITION);
        if (object instanceof Point) {
            return (Point)object;
        }
        return null;
    }

    public static Boolean getFisheye(Node node, boolean returnDefaultIfMissing) {
        Object fisheye = node.attributesProperty().get((Object)NODE_FISHEYE);
        if (fisheye instanceof Boolean) {
            return (Boolean)fisheye;
        }
        return returnDefaultIfMissing ? NODE_FISHEYE_DEFAULT : null;
    }

    public static Image getIcon(Node node) {
        return (Image)node.attributesProperty().get((Object)NODE_ICON);
    }

    public static IConnectionInterpolator getInterpolator(Edge edge) {
        return (IConnectionInterpolator)edge.attributesProperty().get((Object)EDGE_INTERPOLATOR);
    }

    public static String getLabel(Edge edge) {
        Object value = edge.attributesProperty().get((Object)ELEMENT_LABEL);
        if (value instanceof Provider) {
            return (String)((Provider)value).get();
        }
        return (String)value;
    }

    public static String getLabel(Node node) {
        Object value = node.attributesProperty().get((Object)ELEMENT_LABEL);
        if (value instanceof Provider) {
            return (String)((Provider)value).get();
        }
        return (String)value;
    }

    public static String getLabelCssStyle(Edge edge) {
        return (String)edge.attributesProperty().get((Object)ELEMENT_LABEL_CSS_STYLE);
    }

    public static String getLabelCssStyle(Node node) {
        return (String)node.attributesProperty().get((Object)ELEMENT_LABEL_CSS_STYLE);
    }

    public static Point getLabelPosition(Edge edge) {
        Object object = edge.getAttributes().get((Object)EDGE_LABEL_POSITION);
        if (object instanceof Point) {
            return (Point)object;
        }
        return null;
    }

    public static ILayoutAlgorithm getLayoutAlgorithm(Graph graph) {
        Object layout = graph.attributesProperty().get((Object)GRAPH_LAYOUT_ALGORITHM);
        if (layout instanceof ILayoutAlgorithm) {
            return (ILayoutAlgorithm)layout;
        }
        return null;
    }

    public static Boolean getLayoutIrrelevant(Edge edge, boolean returnDefaultIfMissing) {
        ReadOnlyMapProperty attrs = edge.attributesProperty();
        if (attrs.containsKey(ELEMENT_LAYOUT_IRRELEVANT)) {
            return (Boolean)attrs.get(ELEMENT_LAYOUT_IRRELEVANT);
        }
        return returnDefaultIfMissing ? ELEMENT_LAYOUT_IRRELEVANT_DEFAULT : null;
    }

    public static Boolean getLayoutIrrelevant(Node node, boolean returnDefaultIfMissing) {
        ReadOnlyMapProperty attrs = node.attributesProperty();
        if (attrs.containsKey(ELEMENT_LAYOUT_IRRELEVANT)) {
            return (Boolean)attrs.get(ELEMENT_LAYOUT_IRRELEVANT);
        }
        return returnDefaultIfMissing ? ELEMENT_LAYOUT_IRRELEVANT_DEFAULT : null;
    }

    public static String getNodeLabelCssStyle(Node node) {
        return (String)node.attributesProperty().get((Object)ELEMENT_LABEL_CSS_STYLE);
    }

    public static String getNodeRectCssStyle(Node node) {
        return (String)node.attributesProperty().get((Object)NODE_RECT_CSS_STYLE);
    }

    public static Point getPosition(Node node) {
        Object object = node.getAttributes().get((Object)NODE_POSITION);
        if (object instanceof Point) {
            return (Point)object;
        }
        return null;
    }

    public static IConnectionRouter getRouter(Edge edge) {
        return (IConnectionRouter)edge.attributesProperty().get((Object)EDGE_ROUTER);
    }

    public static Dimension getSize(Node node) {
        Object bounds = node.getAttributes().get((Object)NODE_SIZE);
        if (bounds instanceof Dimension) {
            return (Dimension)bounds;
        }
        return null;
    }

    public static Shape getSourceDecoration(Edge edge) {
        return (Shape)edge.attributesProperty().get((Object)EDGE_SOURCE_DECORATION);
    }

    public static String getSourceLabel(Edge edge) {
        Object value = edge.attributesProperty().get((Object)EDGE_SOURCE_LABEL);
        if (value instanceof Provider) {
            return (String)((Provider)value).get();
        }
        return (String)value;
    }

    public static Point getSourceLabelPosition(Edge edge) {
        Object object = edge.getAttributes().get((Object)EDGE_SOURCE_LABEL_POSITION);
        if (object instanceof Point) {
            return (Point)object;
        }
        return null;
    }

    public static Shape getTargetDecoration(Edge edge) {
        return (Shape)edge.attributesProperty().get((Object)EDGE_TARGET_DECORATION);
    }

    public static String getTargetLabel(Edge edge) {
        Object value = edge.attributesProperty().get((Object)EDGE_TARGET_LABEL);
        if (value instanceof Provider) {
            return (String)((Provider)value).get();
        }
        return (String)value;
    }

    public static Point getTargetLabelPosition(Edge edge) {
        Object object = edge.getAttributes().get((Object)EDGE_TARGET_LABEL_POSITION);
        if (object instanceof Point) {
            return (Point)object;
        }
        return null;
    }

    public static String getTooltip(Node node) {
        Object value = node.attributesProperty().get((Object)NODE_TOOLTIP);
        if (value instanceof Provider) {
            return (String)((Provider)value).get();
        }
        return (String)value;
    }

    public static void setControlPoints(Edge edge, List<Point> controlPoints) {
        edge.getAttributes().put((Object)EDGE_CONTROL_POINTS, controlPoints);
    }

    public static void setCssClass(Edge edge, String cssClass) {
        edge.attributesProperty().put((Object)ELEMENT_CSS_CLASS, (Object)cssClass);
    }

    public static void setCssClass(Node node, String cssClass) {
        node.attributesProperty().put((Object)ELEMENT_CSS_CLASS, (Object)cssClass);
    }

    public static void setCssId(Edge edge, String cssId) {
        edge.attributesProperty().put((Object)ELEMENT_CSS_ID, (Object)cssId);
    }

    public static void setCssId(Node node, String cssId) {
        node.attributesProperty().put((Object)ELEMENT_CSS_ID, (Object)cssId);
    }

    public static void setEdgeCurveCssStyle(Edge edge, String connCssStyle) {
        edge.attributesProperty().put((Object)EDGE_CURVE_CSS_STYLE, (Object)connCssStyle);
    }

    public static void setExternalLabel(Edge edge, Provider<String> labelProvider) {
        edge.attributesProperty().put((Object)ELEMENT_EXTERNAL_LABEL, labelProvider);
    }

    public static void setExternalLabel(Edge edge, String label) {
        edge.attributesProperty().put((Object)ELEMENT_EXTERNAL_LABEL, (Object)label);
    }

    public static void setExternalLabel(Node node, Provider<String> labelProvider) {
        node.attributesProperty().put((Object)ELEMENT_EXTERNAL_LABEL, labelProvider);
    }

    public static void setExternalLabel(Node node, String label) {
        node.attributesProperty().put((Object)ELEMENT_EXTERNAL_LABEL, (Object)label);
    }

    public static void setExternalLabelCssStyle(Edge edge, String textCssStyle) {
        edge.attributesProperty().put((Object)ELEMENT_EXTERNAL_LABEL_CSS_STYLE, (Object)textCssStyle);
    }

    public static void setExternalLabelCssStyle(Node node, String textCssStyle) {
        node.attributesProperty().put((Object)ELEMENT_EXTERNAL_LABEL_CSS_STYLE, (Object)textCssStyle);
    }

    public static void setExternalLabelPosition(Edge edge, Point externalLabelPosition) {
        edge.getAttributes().put((Object)ELEMENT_EXTERNAL_LABEL_POSITION, (Object)externalLabelPosition);
    }

    public static void setExternalLabelPosition(Node node, Point externalLabelPosition) {
        node.getAttributes().put((Object)ELEMENT_EXTERNAL_LABEL_POSITION, (Object)externalLabelPosition);
    }

    public static void setFisheye(Node node, Boolean fisheye) {
        node.attributesProperty().put((Object)NODE_FISHEYE, (Object)fisheye);
    }

    public static void setIcon(Node node, Image icon) {
        node.attributesProperty().put((Object)NODE_ICON, (Object)icon);
    }

    public static void setInterpolator(Edge edge, IConnectionInterpolator interpolator) {
        edge.attributesProperty().put((Object)EDGE_INTERPOLATOR, (Object)interpolator);
    }

    public static void setLabel(Edge edge, Provider<String> labelProvider) {
        edge.attributesProperty().put((Object)ELEMENT_LABEL, labelProvider);
    }

    public static void setLabel(Edge edge, String label) {
        edge.attributesProperty().put((Object)ELEMENT_LABEL, (Object)label);
    }

    public static void setLabel(Node node, Provider<String> labelProvider) {
        node.attributesProperty().put((Object)ELEMENT_LABEL, labelProvider);
    }

    public static void setLabel(Node node, String label) {
        node.attributesProperty().put((Object)ELEMENT_LABEL, (Object)label);
    }

    public static void setLabelCssStyle(Edge edge, String textCssStyle) {
        edge.attributesProperty().put((Object)ELEMENT_LABEL_CSS_STYLE, (Object)textCssStyle);
    }

    public static void setLabelCssStyle(Node node, String textCssStyle) {
        node.attributesProperty().put((Object)ELEMENT_LABEL_CSS_STYLE, (Object)textCssStyle);
    }

    public static void setLabelPosition(Edge edge, Point labelPosition) {
        edge.attributesProperty().put((Object)EDGE_LABEL_POSITION, (Object)labelPosition);
    }

    public static void setLayoutAlgorithm(Graph graph, ILayoutAlgorithm algorithm) {
        graph.attributesProperty().put((Object)GRAPH_LAYOUT_ALGORITHM, (Object)algorithm);
    }

    public static void setLayoutIrrelevant(Edge edge, Boolean layoutIrrelevant) {
        edge.attributesProperty().put((Object)ELEMENT_LAYOUT_IRRELEVANT, (Object)layoutIrrelevant);
    }

    public static void setLayoutIrrelevant(Node node, Boolean layoutIrrelevant) {
        node.attributesProperty().put((Object)ELEMENT_LAYOUT_IRRELEVANT, (Object)layoutIrrelevant);
    }

    public static void setNodeRectCssStyle(Node node, String rectCssStyle) {
        node.attributesProperty().put((Object)NODE_RECT_CSS_STYLE, (Object)rectCssStyle);
    }

    public static void setPosition(Node node, Point position) {
        node.getAttributes().put((Object)NODE_POSITION, (Object)position);
    }

    public static void setRouter(Edge edge, IConnectionRouter router) {
        edge.attributesProperty().put((Object)EDGE_ROUTER, (Object)router);
    }

    public static void setSize(Node node, Dimension size) {
        node.getAttributes().put((Object)NODE_SIZE, (Object)size);
    }

    public static void setSourceDecoration(Edge edge, Shape sourceDecoration) {
        edge.attributesProperty().put((Object)EDGE_SOURCE_DECORATION, (Object)sourceDecoration);
    }

    public static void setSourceLabel(Edge edge, Provider<String> sourceLabelProvider) {
        edge.attributesProperty().put((Object)EDGE_SOURCE_LABEL, sourceLabelProvider);
    }

    public static void setSourceLabel(Edge edge, String sourceLabel) {
        edge.attributesProperty().put((Object)EDGE_SOURCE_LABEL, (Object)sourceLabel);
    }

    public static void setSourceLabelPosition(Edge edge, Point labelPosition) {
        edge.attributesProperty().put((Object)EDGE_SOURCE_LABEL_POSITION, (Object)labelPosition);
    }

    public static void setTargetDecoration(Edge edge, Shape targetDecoration) {
        edge.attributesProperty().put((Object)EDGE_TARGET_DECORATION, (Object)targetDecoration);
    }

    public static void setTargetLabel(Edge edge, Provider<String> targetLabelProvider) {
        edge.attributesProperty().put((Object)EDGE_TARGET_LABEL, targetLabelProvider);
    }

    public static void setTargetLabel(Edge edge, String targetLabel) {
        edge.attributesProperty().put((Object)EDGE_TARGET_LABEL, (Object)targetLabel);
    }

    public static void setTargetLabelPosition(Edge edge, Point labelPosition) {
        edge.attributesProperty().put((Object)EDGE_TARGET_LABEL_POSITION, (Object)labelPosition);
    }

    public static void setTooltip(Node node, Provider<String> tooltipProvider) {
        node.attributesProperty().put((Object)NODE_TOOLTIP, tooltipProvider);
    }

    public static void setTooltip(Node node, String tooltip) {
        node.attributesProperty().put((Object)NODE_TOOLTIP, (Object)tooltip);
    }
}

