/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.layout;

import java.util.ArrayList;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import org.eclipse.gef4.common.beans.property.ReadOnlyMapWrapperEx;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.layout.IEdgeLayout;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.zest.fx.layout.GraphLayoutContext;

public class GraphNodeLayout
implements INodeLayout {
    private final ReadOnlyMapWrapper<String, Object> attributesProperty = new ReadOnlyMapWrapperEx((Object)this, "attributes", FXCollections.observableHashMap());
    private GraphLayoutContext context;
    private Node node;

    public GraphNodeLayout(GraphLayoutContext context, Node node) {
        this.context = context;
        this.node = node;
        this.attributesProperty.bindContentBidirectional((ObservableMap)node.attributesProperty());
    }

    public ReadOnlyMapProperty<String, Object> attributesProperty() {
        return this.attributesProperty.getReadOnlyProperty();
    }

    public ObservableMap<String, Object> getAttributes() {
        return this.attributesProperty.get();
    }

    public IEdgeLayout[] getIncomingConnections() {
        IEdgeLayout[] connections;
        ArrayList<IEdgeLayout> incoming = new ArrayList<IEdgeLayout>();
        IEdgeLayout[] iEdgeLayoutArray = connections = this.context.getEdges();
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IEdgeLayout c = iEdgeLayoutArray[n2];
            if (c.getTarget() == this) {
                incoming.add(c);
            }
            ++n2;
        }
        return incoming.toArray(new IEdgeLayout[0]);
    }

    public Node getNode() {
        return this.node;
    }

    public IEdgeLayout[] getOutgoingConnections() {
        IEdgeLayout[] connections;
        ArrayList<IEdgeLayout> outgoing = new ArrayList<IEdgeLayout>();
        IEdgeLayout[] iEdgeLayoutArray = connections = this.context.getEdges();
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IEdgeLayout c = iEdgeLayoutArray[n2];
            if (c.getSource() == this) {
                outgoing.add(c);
            }
            ++n2;
        }
        return outgoing.toArray(new IEdgeLayout[0]);
    }

    public INodeLayout[] getPredecessingNodes() {
        IEdgeLayout[] incomingConnections = this.getIncomingConnections();
        INodeLayout[] predecessors = new INodeLayout[incomingConnections.length];
        int i = 0;
        IEdgeLayout[] iEdgeLayoutArray = incomingConnections;
        int n = incomingConnections.length;
        int n2 = 0;
        while (n2 < n) {
            IEdgeLayout incomingConnection = iEdgeLayoutArray[n2];
            predecessors[i++] = incomingConnection.getSource();
            ++n2;
        }
        return predecessors;
    }

    public INodeLayout[] getSuccessingNodes() {
        IEdgeLayout[] outgoingConnections = this.getOutgoingConnections();
        INodeLayout[] successors = new INodeLayout[outgoingConnections.length];
        int i = 0;
        IEdgeLayout[] iEdgeLayoutArray = outgoingConnections;
        int n = outgoingConnections.length;
        int n2 = 0;
        while (n2 < n) {
            IEdgeLayout outgoingConnection = iEdgeLayoutArray[n2];
            successors[i++] = outgoingConnection.getTarget();
            ++n2;
        }
        return successors;
    }
}

