/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.collections.MapChangeListener;
import javafx.scene.Node;
import javafx.scene.shape.Shape;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.GeometryNode;
import org.eclipse.gef4.fx.nodes.IConnectionInterpolator;
import org.eclipse.gef4.fx.nodes.IConnectionRouter;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXContentPart;
import org.eclipse.gef4.mvc.parts.IBendableContentPart;
import org.eclipse.gef4.mvc.parts.ITransformableContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.ZestProperties;

public class EdgePart
extends AbstractFXContentPart<Connection>
implements ITransformableContentPart<Node, Connection>,
IBendableContentPart<Node, Connection> {
    private static final String SOURCE_ROLE = "SOURCE";
    private static final String TARGET_ROLE = "TARGET";
    public static final String CSS_CLASS = "edge";
    public static final String CSS_CLASS_CURVE = "curve";
    private MapChangeListener<String, Object> edgeAttributesObserver = new MapChangeListener<String, Object>(){

        public void onChanged(MapChangeListener.Change<? extends String, ? extends Object> change) {
            EdgePart.this.refreshVisual();
        }
    };

    protected void addChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        if (!((Connection)this.getVisual()).getChildren().contains(child.getVisual())) {
            ((Connection)this.getVisual()).getChildren().add((Object)((Node)child.getVisual()));
        }
    }

    protected void attachToAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        IAnchor anchor;
        Provider anchorProvider = (Provider)anchorage.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IAnchor>>(){}));
        IAnchor iAnchor = anchor = anchorProvider == null ? null : (IAnchor)anchorProvider.get();
        if (role.equals(SOURCE_ROLE)) {
            ((Connection)this.getVisual()).setStartAnchor(anchor);
        } else if (role.equals(TARGET_ROLE)) {
            ((Connection)this.getVisual()).setEndAnchor(anchor);
        } else {
            throw new IllegalArgumentException("Cannot attach to anchor with role <" + role + ">.");
        }
    }

    public void bendContent(List<IBendableContentPart.BendPoint> bendPoints) {
        ArrayList<Point> waypoints = new ArrayList<Point>();
        int i = 0;
        while (i < bendPoints.size()) {
            IBendableContentPart.BendPoint bp = bendPoints.get(i);
            if (bp.isAttached()) {
                if (i == 0) {
                    org.eclipse.gef4.graph.Node newSource = (org.eclipse.gef4.graph.Node)bp.getContentAnchorage();
                    org.eclipse.gef4.graph.Node oldSource = this.getContent().getSource();
                    if (oldSource != newSource) {
                        if (oldSource != null) {
                            this.detachFromContentAnchorage(oldSource, SOURCE_ROLE);
                        }
                        if (newSource != null) {
                            this.attachToContentAnchorage(newSource, SOURCE_ROLE);
                        }
                    }
                }
                if (i == bendPoints.size() - 1) {
                    org.eclipse.gef4.graph.Node newTarget = (org.eclipse.gef4.graph.Node)bp.getContentAnchorage();
                    org.eclipse.gef4.graph.Node oldTarget = this.getContent().getTarget();
                    if (oldTarget != newTarget) {
                        if (oldTarget != null) {
                            this.detachFromContentAnchorage(oldTarget, TARGET_ROLE);
                        }
                        if (newTarget != null) {
                            this.attachToContentAnchorage(newTarget, TARGET_ROLE);
                        }
                    }
                }
            } else {
                waypoints.add(bp.getPosition());
            }
            ++i;
        }
        ZestProperties.setControlPoints(this.getContent(), waypoints);
    }

    protected Connection createVisual() {
        Connection visual = new Connection();
        visual.getStyleClass().add((Object)CSS_CLASS);
        visual.getCurveNode().getStyleClass().add((Object)CSS_CLASS_CURVE);
        return visual;
    }

    protected void detachFromAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        Connection connection = (Connection)this.getVisual();
        if (role.equals(SOURCE_ROLE)) {
            Point startPoint = connection.getStartPoint();
            connection.setStartPoint(startPoint == null ? new Point() : startPoint);
        } else if (role.equals(TARGET_ROLE)) {
            Point endPoint = connection.getEndPoint();
            connection.setEndPoint(endPoint == null ? new Point() : endPoint);
        } else {
            throw new IllegalArgumentException("Cannot detach from anchor with role <" + role + ">.");
        }
    }

    protected void doActivate() {
        super.doActivate();
        this.getContent().attributesProperty().addListener(this.edgeAttributesObserver);
    }

    protected void doAttachToContentAnchorage(Object contentAnchorage, String role) {
        if (SOURCE_ROLE.equals(role)) {
            this.getContent().setSource((org.eclipse.gef4.graph.Node)contentAnchorage);
        } else if (TARGET_ROLE.equals(role)) {
            this.getContent().setTarget((org.eclipse.gef4.graph.Node)contentAnchorage);
        } else {
            throw new IllegalArgumentException("Cannot attach to content anchorage with role <" + role + ">.");
        }
    }

    protected void doDeactivate() {
        this.getContent().attributesProperty().removeListener(this.edgeAttributesObserver);
        super.doDeactivate();
    }

    protected void doDetachFromContentAnchorage(Object contentAnchorage, String role) {
        if (SOURCE_ROLE.equals(role)) {
            this.getContent().setSource(null);
        } else if (TARGET_ROLE.equals(role)) {
            this.getContent().setTarget(null);
        } else {
            throw new IllegalArgumentException("Cannot detach from content anchorage with role <" + role + ">.");
        }
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        org.eclipse.gef4.graph.Node target;
        HashMultimap anchorages = HashMultimap.create();
        org.eclipse.gef4.graph.Node source = this.getContent().getSource();
        if (source != null) {
            anchorages.put((Object)source, (Object)SOURCE_ROLE);
        }
        if ((target = this.getContent().getTarget()) != null) {
            anchorages.put((Object)target, (Object)TARGET_ROLE);
        }
        return anchorages;
    }

    protected List<? extends Object> doGetContentChildren() {
        return Collections.emptyList();
    }

    protected void doRefreshVisual(Connection visual) {
        List<Point> controlPoints;
        IConnectionInterpolator interpolator;
        IConnectionRouter router;
        Shape targetDecoration;
        Shape sourceDecoration;
        Edge edge = this.getContent();
        ReadOnlyMapProperty attrs = edge.attributesProperty();
        GeometryNode curveNode = visual.getCurveNode();
        if (attrs.containsKey("css-class")) {
            String cssClass = ZestProperties.getCssClass(edge);
            if (!visual.getStyleClass().contains((Object)cssClass)) {
                visual.getStyleClass().add((Object)cssClass);
            }
        }
        if (attrs.containsKey("css-id")) {
            String cssId = ZestProperties.getCssId(edge);
            visual.setId(cssId);
        }
        if (attrs.containsKey("edge-curve-css-style")) {
            String connCssStyle = ZestProperties.getEdgeCurveCssStyle(edge);
            curveNode.setStyle(connCssStyle);
        }
        if ((sourceDecoration = ZestProperties.getSourceDecoration(edge)) != null) {
            visual.setStartDecoration(sourceDecoration);
        }
        if ((targetDecoration = ZestProperties.getTargetDecoration(edge)) != null) {
            visual.setEndDecoration(targetDecoration);
        }
        if ((router = ZestProperties.getRouter(edge)) != null) {
            visual.setRouter(router);
        }
        if ((interpolator = ZestProperties.getInterpolator(edge)) != null) {
            visual.setInterpolator(interpolator);
        }
        if ((controlPoints = ZestProperties.getControlPoints(edge)) != null && !controlPoints.isEmpty()) {
            visual.setControlPoints(controlPoints);
        }
    }

    public Edge getContent() {
        return (Edge)super.getContent();
    }

    protected void removeChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        ((Connection)this.getVisual()).getChildren().remove(child.getVisual());
    }

    public void transformContent(AffineTransform transform) {
        ZestProperties.setControlPoints(this.getContent(), Arrays.asList(transform.getTransformed(ZestProperties.getControlPoints(this.getContent()).toArray(new Point[0]))));
    }
}

