/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.MapChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.mvc.fx.operations.FXResizeOperation;
import org.eclipse.gef4.mvc.fx.operations.FXTransformOperation;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXContentPart;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.parts.IResizableContentPart;
import org.eclipse.gef4.mvc.parts.ITransformableContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.ZestProperties;

public class NodePart
extends AbstractFXContentPart<Group>
implements ITransformableContentPart<Node, Group>,
IResizableContentPart<Node, Group> {
    protected static final double DEFAULT_PADDING = 5.0;
    protected static final double ZOOMLEVEL_SHOW_NESTED_GRAPH = 2.0;
    protected static final double DEFAULT_CHILDREN_PANE_WIDTH = 300.0;
    protected static final double DEFAULT_CHILDREN_PANE_HEIGHT = 300.0;
    protected static final double CHILDREN_PANE_WIDTH_THRESHOLD = 100.0;
    protected static final double CHILDREN_PANE_HEIGHT_THRESHOLD = 100.0;
    public static final double DEFAULT_NESTED_CHILDREN_ZOOM_FACTOR = 0.25;
    public static final double DEFAULT_OUTER_LAYOUT_CONTAINER_WIDTH_NESTING = 75.0;
    public static final double DEFAULT_OUTER_LAYOUT_CONTAINER_HEIGHT_NESTING = 75.0;
    public static final double DEFAULT_OUTER_LAYOUT_CONTAINER_WIDTH_LEAF = 0.0;
    public static final double DEFAULT_OUTER_LAYOUT_CONTAINER_HEIGHT_LEAF = 0.0;
    public static final String CSS_CLASS = "node";
    public static final String CSS_CLASS_SHAPE = "shape";
    public static final String CSS_CLASS_LABEL = "label";
    public static final String CSS_CLASS_ICON = "icon";
    private static final String NODE_LABEL_EMPTY = "-";
    private MapChangeListener<String, Object> nodeAttributesObserver = new MapChangeListener<String, Object>(){

        public void onChanged(MapChangeListener.Change<? extends String, ? extends Object> change) {
            NodePart.this.refreshVisual();
        }
    };
    private Text labelText;
    private ImageView iconImageView;
    private Node nestedGraphIcon;
    private StackPane nestedContentStackPane;
    private Pane nestedChildrenPane;
    private Pane nestedChildrenPaneScaled;
    private Tooltip tooltipNode;
    private VBox outerLayoutContainer;
    private Rectangle rect;

    protected void addChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        this.nestedChildrenPaneScaled.getChildren().add(index, (Object)((Node)child.getVisual()));
    }

    private Pane createNestedContentPane() {
        AnchorPane pane = new AnchorPane();
        pane.setStyle("-fx-background-color: white;");
        this.nestedChildrenPaneScaled = new Pane();
        Scale scale = new Scale();
        this.nestedChildrenPaneScaled.getTransforms().add((Object)scale);
        scale.setX(0.25);
        scale.setY(0.25);
        pane.getChildren().add((Object)this.nestedChildrenPaneScaled);
        AnchorPane.setLeftAnchor((Node)this.nestedChildrenPaneScaled, (Double)-0.5);
        AnchorPane.setTopAnchor((Node)this.nestedChildrenPaneScaled, (Double)-0.5);
        AnchorPane.setRightAnchor((Node)this.nestedChildrenPaneScaled, (Double)0.5);
        AnchorPane.setBottomAnchor((Node)this.nestedChildrenPaneScaled, (Double)0.5);
        return pane;
    }

    private StackPane createNestedContentStackPane(Pane nestedContentPane) {
        StackPane stackPane = new StackPane();
        stackPane.getChildren().add((Object)nestedContentPane);
        return stackPane;
    }

    protected Group createVisual() {
        Group group = new Group(){

            public boolean isResizable() {
                return true;
            }

            public void resize(double w, double h) {
                Bounds layoutBounds = this.getLayoutBounds();
                Bounds vboxBounds = NodePart.this.outerLayoutContainer.getLayoutBounds();
                double vw = vboxBounds.getWidth() + w - layoutBounds.getWidth();
                double vh = vboxBounds.getHeight() + h - layoutBounds.getHeight();
                NodePart.this.outerLayoutContainer.setPrefSize(vw, vh);
                NodePart.this.outerLayoutContainer.resize(vw, vh);
            }
        };
        this.rect = new Rectangle();
        this.rect.setFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 1.0, true, CycleMethod.REFLECT, Arrays.asList(new Stop(0.0, new Color(1.0, 1.0, 1.0, 1.0)))));
        this.rect.setStroke((Paint)new Color(0.0, 0.0, 0.0, 1.0));
        this.rect.getStyleClass().add((Object)CSS_CLASS_SHAPE);
        this.nestedChildrenPane = this.createNestedContentPane();
        this.nestedContentStackPane = this.createNestedContentStackPane(this.nestedChildrenPane);
        this.nestedChildrenPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.nestedContentStackPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.iconImageView = new ImageView();
        this.iconImageView.setImage(null);
        this.iconImageView.getStyleClass().add((Object)CSS_CLASS_ICON);
        this.labelText = new Text();
        this.labelText.setTextOrigin(VPos.TOP);
        this.labelText.setText(NODE_LABEL_EMPTY);
        this.labelText.getStyleClass().add((Object)CSS_CLASS_LABEL);
        HBox hbox = new HBox();
        hbox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        hbox.getChildren().addAll((Object[])new Node[]{this.iconImageView, this.labelText});
        this.outerLayoutContainer = new VBox();
        this.outerLayoutContainer.setMouseTransparent(true);
        this.outerLayoutContainer.getChildren().addAll((Object[])new Node[]{hbox, this.nestedContentStackPane});
        VBox.setVgrow((Node)this.nestedContentStackPane, (Priority)Priority.ALWAYS);
        this.outerLayoutContainer.layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                NodePart.this.outerLayoutContainer.setTranslateX(NodePart.this.getPadding());
                NodePart.this.outerLayoutContainer.setTranslateY(NodePart.this.getPadding());
                NodePart.this.getNodeRect().setWidth(NodePart.this.outerLayoutContainer.getWidth() + 2.0 * NodePart.this.getPadding());
                NodePart.this.getNodeRect().setHeight(NodePart.this.outerLayoutContainer.getHeight() + 2.0 * NodePart.this.getPadding());
            }
        });
        group.getChildren().addAll((Object[])new Node[]{this.rect, this.outerLayoutContainer});
        return group;
    }

    protected void doActivate() {
        super.doActivate();
        this.getContent().attributesProperty().addListener(this.nodeAttributesObserver);
    }

    protected void doDeactivate() {
        this.getContent().attributesProperty().removeListener(this.nodeAttributesObserver);
        super.doDeactivate();
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        return HashMultimap.create();
    }

    protected List<? extends Object> doGetContentChildren() {
        Graph nestedGraph = this.getContent().getNestedGraph();
        if (nestedGraph == null) {
            return Collections.emptyList();
        }
        Transform tx = ((Group)this.getVisual()).getLocalToSceneTransform();
        double scale = FX2Geometry.toAffineTransform((Transform)tx).getScaleX();
        if (scale > 2.0) {
            this.hideNestedGraphIcon();
            return Collections.singletonList(nestedGraph);
        }
        this.showNestedGraphIcon();
        return Collections.emptyList();
    }

    protected void doRefreshVisual(Group visual) {
        org.eclipse.gef4.graph.Node node = this.getContent();
        if (node == null) {
            throw new IllegalStateException();
        }
        visual.getStyleClass().clear();
        visual.getStyleClass().add((Object)CSS_CLASS);
        ReadOnlyMapProperty attrs = node.attributesProperty();
        if (attrs.containsKey("css-class")) {
            visual.getStyleClass().add((Object)ZestProperties.getCssClass(node));
        }
        String id = null;
        if (attrs.containsKey("css-id")) {
            id = ZestProperties.getCssId(node);
        }
        visual.setId(id);
        if (attrs.containsKey("node-rect-css-style")) {
            this.refreshRectCssStyle(ZestProperties.getNodeRectCssStyle(node));
        }
        if (attrs.containsKey("element-label-css-style")) {
            this.refreshLabelCssStyle(ZestProperties.getNodeLabelCssStyle(node));
        }
        this.refreshNesting(this.isNesting());
        this.refreshLabel(ZestProperties.getLabel(node));
        this.refreshIcon(ZestProperties.getIcon(node));
        this.refreshTooltip(ZestProperties.getTooltip(node));
        this.refreshPosition(ZestProperties.getPosition(node));
        this.refreshSize(ZestProperties.getSize(node));
    }

    public org.eclipse.gef4.graph.Node getContent() {
        return (org.eclipse.gef4.graph.Node)super.getContent();
    }

    protected ImageView getIconImageView() {
        return this.iconImageView;
    }

    protected Text getLabelText() {
        return this.labelText;
    }

    public Pane getNestedChildrenPane() {
        return this.nestedChildrenPaneScaled;
    }

    private StackPane getNestedContentStackPane() {
        return this.nestedContentStackPane;
    }

    private Node getNestedGraphIcon() {
        return this.nestedGraphIcon;
    }

    protected Rectangle getNodeRect() {
        return this.rect;
    }

    protected Region getOuterLayoutContainer() {
        return this.outerLayoutContainer;
    }

    protected double getPadding() {
        return 5.0;
    }

    private void hideNestedGraphIcon() {
        if (this.getNestedGraphIcon() != null) {
            this.getNestedContentStackPane().getChildren().remove((Object)this.getNestedGraphIcon());
            this.setNestedGraphIcon(null);
        }
    }

    protected boolean isNesting() {
        return this.getContent().getNestedGraph() != null;
    }

    protected void refreshIcon(Image icon) {
        if (this.getIconImageView() != null && this.getIconImageView().getImage() != icon && icon instanceof Image) {
            this.getIconImageView().setImage(icon);
        }
    }

    protected void refreshLabel(String label) {
        if (label == null || label.isEmpty()) {
            label = NODE_LABEL_EMPTY;
        }
        if (this.getLabelText() != null && !this.getLabelText().getText().equals(label)) {
            this.getLabelText().setText(label);
        }
    }

    protected void refreshLabelCssStyle(String labelCssStyle) {
        if (this.getLabelText() != null) {
            this.getLabelText().setStyle(labelCssStyle);
        }
    }

    protected void refreshNesting(boolean isNesting) {
        if (this.getOuterLayoutContainer() != null) {
            if (isNesting) {
                if (this.getOuterLayoutContainer().getPrefWidth() == 0.0 && this.getOuterLayoutContainer().getPrefHeight() == 0.0) {
                    this.getOuterLayoutContainer().setPrefSize(75.0, 75.0);
                    this.getOuterLayoutContainer().resize(75.0, 75.0);
                }
            } else {
                this.getOuterLayoutContainer().setPrefSize(0.0, 0.0);
                this.getOuterLayoutContainer().resize(0.0, 0.0);
            }
        }
    }

    protected void refreshPosition(Point position) {
        if (position != null) {
            FXTransformOperation refreshPositionOp = new FXTransformOperation((Affine)((Provider)this.getAdapter(FXTransformPolicy.TRANSFORM_PROVIDER_KEY)).get());
            refreshPositionOp.setNewTransform(Geometry2FX.toFXAffine((AffineTransform)new AffineTransform(1.0, 0.0, 0.0, 1.0, position.x, position.y)));
            try {
                refreshPositionOp.execute(null, null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    protected void refreshRectCssStyle(String nodeRectCssStyle) {
        if (this.getNodeRect() != null) {
            this.getNodeRect().setStyle(nodeRectCssStyle);
        }
    }

    protected void refreshSize(Dimension size) {
        if (size != null) {
            FXResizeOperation resizeOperation = new FXResizeOperation((Node)this.getVisual());
            if (size.getWidth() != -1.0) {
                resizeOperation.setDw(size.getWidth() - ((Group)this.getVisual()).getLayoutBounds().getWidth());
            }
            if (size.getHeight() != -1.0) {
                resizeOperation.setDh(size.getHeight() - ((Group)this.getVisual()).getLayoutBounds().getHeight());
            }
            try {
                resizeOperation.execute(null, null);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected void refreshTooltip(String tooltip) {
        if (this.tooltipNode == null) {
            this.tooltipNode = new Tooltip(tooltip);
            Tooltip.install((Node)((Node)this.getVisual()), (Tooltip)this.tooltipNode);
        } else {
            this.tooltipNode.setText(tooltip);
        }
    }

    protected void removeChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        this.nestedChildrenPaneScaled.getChildren().remove(index);
    }

    public void resizeContent(Dimension size) {
        ZestProperties.setSize(this.getContent(), size);
    }

    private void setNestedGraphIcon(Node nestedGraphIcon) {
        this.nestedGraphIcon = nestedGraphIcon;
    }

    private void showNestedGraphIcon() {
        if (this.getNestedGraphIcon() == null) {
            this.setNestedGraphIcon((Node)new NestedGraphIcon());
            this.getNestedContentStackPane().getChildren().add((Object)this.getNestedGraphIcon());
        }
    }

    public void transformContent(AffineTransform transform) {
        Point position = ZestProperties.getPosition(this.getContent());
        if (position != null) {
            ZestProperties.setPosition(this.getContent(), transform.getTransformed(position));
        }
    }

    public static class NestedGraphIcon
    extends Group {
        public NestedGraphIcon() {
            Circle n0 = this.node(-20.0, -20.0);
            Circle n1 = this.node(-10.0, 10.0);
            Circle n2 = this.node(5.0, -15.0);
            Circle n3 = this.node(15.0, -25.0);
            Circle n4 = this.node(20.0, 5.0);
            this.getChildren().addAll((Object[])new Node[]{this.edge(n0, n1), this.edge(n1, n2), this.edge(n2, n3), this.edge(n3, n4), this.edge(n1, n4), n0, n1, n2, n3, n4});
        }

        private Node edge(Circle n, Circle m) {
            Line line = new Line(n.getCenterX(), n.getCenterY(), m.getCenterX(), m.getCenterY());
            line.setStroke((Paint)Color.BLACK);
            return line;
        }

        private Circle node(double x, double y) {
            return new Circle(x, y, 5.0, (Paint)Color.BLACK);
        }
    }
}

