/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Map;
import javafx.scene.Node;
import javafx.util.Pair;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXContentPart;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IContentPartFactory;
import org.eclipse.gef4.zest.fx.parts.EdgeLabelPart;
import org.eclipse.gef4.zest.fx.parts.EdgePart;
import org.eclipse.gef4.zest.fx.parts.GraphPart;
import org.eclipse.gef4.zest.fx.parts.NodeLabelPart;
import org.eclipse.gef4.zest.fx.parts.NodePart;

public class ZestFxContentPartFactory
implements IContentPartFactory<Node> {
    @Inject
    private Injector injector;

    public IContentPart<Node, ? extends Node> createContentPart(Object content, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap) {
        AbstractFXContentPart part = null;
        if (content instanceof Graph) {
            part = new GraphPart();
        } else if (content instanceof org.eclipse.gef4.graph.Node) {
            part = new NodePart();
        } else if (content instanceof Edge) {
            part = new EdgePart();
        } else if (content instanceof Pair && ((Pair)content).getKey() instanceof Edge && ("label".equals(((Pair)content).getValue()) || "element-external-label".equals(((Pair)content).getValue()) || "source-label".equals(((Pair)content).getValue()) || "target-label".equals(((Pair)content).getValue()))) {
            part = new EdgeLabelPart();
        } else if (content instanceof Pair && ((Pair)content).getKey() instanceof org.eclipse.gef4.graph.Node && "element-external-label".equals(((Pair)content).getValue())) {
            part = new NodeLabelPart();
        }
        if (part != null) {
            this.injector.injectMembers((Object)part);
        }
        return part;
    }
}

