/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.anchors;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef4.common.beans.property.ReadOnlyMapWrapperEx;
import org.eclipse.gef4.fx.anchors.AbstractAnchor;
import org.eclipse.gef4.fx.anchors.AnchorKey;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;

public class DynamicAnchor
extends AbstractAnchor {
    public static final String DEFAULT_COMPUTATION_STRATEGY_PROPERTY = "defaultComputationStrategy";
    private static final IComputationStrategy DEFAULT_COMPUTATION_STRATEGY = new ProjectionStrategy();
    private ObjectProperty<IComputationStrategy> defaultComputationStrategyProperty;
    private ReadOnlyMapWrapperEx<AnchorKey, IComputationStrategy> computationStrategyProperty = new ReadOnlyMapWrapperEx(FXCollections.observableHashMap());
    private ReadOnlyMapWrapperEx<AnchorKey, Point> referencePointProperty = new ReadOnlyMapWrapperEx(FXCollections.observableHashMap());
    private MapChangeListener<AnchorKey, Point> referencePointChangeListener = new MapChangeListener<AnchorKey, Point>(){

        public void onChanged(MapChangeListener.Change<? extends AnchorKey, ? extends Point> change) {
            if (change.wasAdded()) {
                if (change.getKey() == null) {
                    throw new IllegalStateException("Attempt to put <null> key into reference point map!");
                }
                if (change.getValueAdded() == null) {
                    throw new IllegalStateException("Attempt to put <null> value into reference point map!");
                }
                if (DynamicAnchor.this.getKeys().containsKey(((AnchorKey)change.getKey()).getAnchored()) && DynamicAnchor.this.getKeys().get(((AnchorKey)change.getKey()).getAnchored()).contains(change.getKey())) {
                    DynamicAnchor.this.updatePosition((AnchorKey)change.getKey());
                }
            }
        }
    };

    public DynamicAnchor(Node anchorage) {
        super(anchorage);
        this.referencePointProperty.addListener(this.referencePointChangeListener);
    }

    public DynamicAnchor(Node anchorage, IComputationStrategy computationStrategy) {
        super(anchorage);
        this.setDefaultComputationStrategy(computationStrategy);
        this.referencePointProperty.addListener(this.referencePointChangeListener);
    }

    public ReadOnlyMapProperty<AnchorKey, IComputationStrategy> computationStrategyProperty() {
        return this.computationStrategyProperty.getReadOnlyProperty();
    }

    @Override
    protected Point computePosition(AnchorKey key) {
        return this.computePosition(key.getAnchored(), this.getReferencePoint(key), this.getComputationStrategy(key));
    }

    public Point computePosition(Node anchored, Point anchoredReferencePointInLocal, IComputationStrategy computationStrategy) {
        return FX2Geometry.toPoint((Point2D)anchored.sceneToLocal(Geometry2FX.toFXPoint((Point)computationStrategy.computePositionInScene(this.getAnchorage(), anchored, anchoredReferencePointInLocal))));
    }

    public ObjectProperty<IComputationStrategy> defaultComputationStrategyProperty() {
        if (this.defaultComputationStrategyProperty == null) {
            this.defaultComputationStrategyProperty = new SimpleObjectProperty((Object)this, DEFAULT_COMPUTATION_STRATEGY_PROPERTY, (Object)DEFAULT_COMPUTATION_STRATEGY);
        }
        return this.defaultComputationStrategyProperty;
    }

    public IComputationStrategy getComputationStrategy(AnchorKey key) {
        if (this.computationStrategyProperty.containsKey((Object)key)) {
            return (IComputationStrategy)this.computationStrategyProperty.get((Object)key);
        }
        return this.getDefaultComputationStrategy();
    }

    public IComputationStrategy getDefaultComputationStrategy() {
        return this.defaultComputationStrategyProperty == null ? DEFAULT_COMPUTATION_STRATEGY : (IComputationStrategy)this.defaultComputationStrategyProperty().get();
    }

    public Point getReferencePoint(AnchorKey key) {
        Point referencePoint = (Point)this.referencePointProperty().get((Object)key);
        if (referencePoint == null) {
            referencePoint = new Point(0.0, 0.0);
        }
        return referencePoint;
    }

    public ReadOnlyMapProperty<AnchorKey, Point> referencePointProperty() {
        return this.referencePointProperty.getReadOnlyProperty();
    }

    public void removeComputationStrategy(AnchorKey key) {
        this.computationStrategyProperty.remove((Object)key);
    }

    public void setComputationStrategy(AnchorKey key, IComputationStrategy computationStrategy) {
        this.computationStrategyProperty.put((Object)key, (Object)computationStrategy);
    }

    public void setDefaultComputationStrategy(IComputationStrategy computationStrategy) {
        this.defaultComputationStrategyProperty().set((Object)computationStrategy);
    }

    public static abstract class AbstractComputationStrategy
    implements IComputationStrategy {
        public static IGeometry getOutlineGeometry(Node node) {
            IGeometry geometry = null;
            try {
                geometry = NodeUtils.getGeometricOutline(node);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (geometry instanceof IShape) {
                return NodeUtils.getResizedToShapeBounds(node, geometry);
            }
            if (geometry == null) {
                geometry = FX2Geometry.toRectangle((Bounds)node.getLayoutBounds());
            }
            return geometry;
        }

        public static List<ICurve> getOutlineSegments(IGeometry geometry) {
            if (geometry instanceof IShape) {
                return Collections.singletonList(((IShape)geometry).getOutline());
            }
            if (geometry instanceof ICurve) {
                return Collections.singletonList((ICurve)geometry);
            }
            if (geometry instanceof Path) {
                return ((Path)geometry).getOutlines();
            }
            throw new IllegalStateException("The transformed geometry is neither an ICurve nor an IShape.");
        }

        protected IGeometry getAnchorageReferenceGeometryInLocal(Node anchorage) {
            return AbstractComputationStrategy.getOutlineGeometry(anchorage);
        }

        protected IGeometry getAnchorageReferenceGeometryInScene(Node anchorage) {
            return NodeUtils.localToScene(anchorage, this.getAnchorageReferenceGeometryInLocal(anchorage));
        }
    }

    public static interface IComputationStrategy {
        public Point computePositionInScene(Node var1, Node var2, Point var3);
    }

    public static class OrthogonalProjectionStrategy
    extends AbstractComputationStrategy {
        private static final double TOLERANCE = 0.2;

        private static double adjustParameterToRespectTolerance(double parameter) {
            if (parameter < 0.2) {
                parameter = 0.2;
            } else if (parameter > 0.8) {
                parameter = 0.8;
            }
            return parameter;
        }

        private static BezierCurve getContainingBezierCurve(ICurve curve, Point point) {
            BezierCurve[] bezierCurveArray = curve.toBezier();
            int n = bezierCurveArray.length;
            int n2 = 0;
            while (n2 < n) {
                BezierCurve bc = bezierCurveArray[n2];
                if (bc.contains(point)) {
                    return bc;
                }
                ++n2;
            }
            return null;
        }

        private static Point getHorizontalProjection(ICurve curve, Point reference) {
            Rectangle bounds = curve.getBounds();
            Line line = new Line(bounds.getX(), reference.y, bounds.getX() + bounds.getWidth(), reference.y);
            Point projection = OrthogonalProjectionStrategy.getNearestOrthogonalProjection(curve, reference, line);
            if (projection != null) {
                projection.y = reference.y;
            }
            return projection;
        }

        public static Point getNearestBoundsProjection(IGeometry g, Point p) {
            Line[] outlineSegments = g.getBounds().getOutlineSegments();
            Point nearestProjection = null;
            double nearestDistance = 0.0;
            Line[] lineArray = outlineSegments;
            int n = outlineSegments.length;
            int n2 = 0;
            while (n2 < n) {
                Line l = lineArray[n2];
                Point projection = l.getProjection(p);
                double parameter = l.getParameterAt(projection);
                parameter = OrthogonalProjectionStrategy.adjustParameterToRespectTolerance(parameter);
                projection = l.get(parameter);
                double distance = p.getDistance(projection);
                if (nearestProjection == null || distance < nearestDistance) {
                    nearestDistance = distance;
                    nearestProjection = projection;
                }
                ++n2;
            }
            return nearestProjection;
        }

        private static Point getNearestOrthogonalProjection(ICurve curve, Point reference, Line line) {
            if (curve.overlaps((ICurve)line)) {
                ICurve[] overlaps = curve.getOverlaps((ICurve)line);
                Point nearest = null;
                double distance = 0.0;
                ICurve[] iCurveArray = overlaps;
                int n = overlaps.length;
                int n2 = 0;
                while (n2 < n) {
                    ICurve overlap = iCurveArray[n2];
                    Point currentNearest = Point.nearest((Point)reference, (Point[])new Point[]{overlap.getP1(), overlap.getP2()});
                    double currentDistance = reference.getDistance(currentNearest);
                    if (nearest == null || currentDistance < distance) {
                        nearest = currentNearest;
                        distance = currentDistance;
                    }
                    ++n2;
                }
                if (nearest != null) {
                    BezierCurve bc = OrthogonalProjectionStrategy.getContainingBezierCurve(curve, nearest);
                    double parameter = bc.getParameterAt(nearest);
                    parameter = OrthogonalProjectionStrategy.adjustParameterToRespectTolerance(parameter);
                    return bc.get(parameter);
                }
                return nearest;
            }
            if (curve.intersects((ICurve)line)) {
                Point nearest = Point.nearest((Point)reference, (Point[])curve.getIntersections((ICurve)line));
                BezierCurve bc = OrthogonalProjectionStrategy.getContainingBezierCurve(curve, nearest);
                double parameter = bc.getParameterAt(nearest);
                parameter = OrthogonalProjectionStrategy.adjustParameterToRespectTolerance(parameter);
                return bc.get(parameter);
            }
            return null;
        }

        private static Point getOrthogonalProjection(ICurve curve, Point reference) {
            double verticalDistance;
            Point nearestHorizonalProjection = OrthogonalProjectionStrategy.getHorizontalProjection(curve, reference);
            if (nearestHorizonalProjection == null) {
                return OrthogonalProjectionStrategy.getVerticalProjection(curve, reference);
            }
            Point nearestVerticalProjection = OrthogonalProjectionStrategy.getVerticalProjection(curve, reference);
            if (nearestVerticalProjection == null) {
                return nearestHorizonalProjection;
            }
            double horizontalDistance = nearestHorizonalProjection.getDistance(reference);
            if (horizontalDistance <= (verticalDistance = nearestVerticalProjection.getDistance(reference))) {
                return nearestHorizonalProjection;
            }
            return nearestVerticalProjection;
        }

        private static Point getVerticalProjection(ICurve curve, Point reference) {
            Rectangle bounds = curve.getBounds();
            Line line = new Line(reference.x, bounds.getY(), reference.x, bounds.getY() + bounds.getHeight());
            Point projection = OrthogonalProjectionStrategy.getNearestOrthogonalProjection(curve, reference, line);
            if (projection != null) {
                projection.x = reference.x;
            }
            return projection;
        }

        @Override
        public Point computePositionInScene(Node anchorage, Node anchored, Point anchoredReferencePointInLocal) {
            Point anchoredReferencePointInScene = NodeUtils.localToScene(anchored, anchoredReferencePointInLocal);
            IGeometry anchorageReferenceGeometryInScene = this.getAnchorageReferenceGeometryInScene(anchorage);
            List<ICurve> anchorageReferenceGeometryOutlineSegmentsInScene = OrthogonalProjectionStrategy.getOutlineSegments(anchorageReferenceGeometryInScene);
            Point nearestOrthogonalProjectionInScene = null;
            double nearestOrthogonalProjectionDistance = Double.MAX_VALUE;
            for (ICurve segment : anchorageReferenceGeometryOutlineSegmentsInScene) {
                Point projection = OrthogonalProjectionStrategy.getOrthogonalProjection(segment, anchoredReferencePointInScene);
                if (projection == null) continue;
                double distance = projection.getDistance(anchoredReferencePointInScene);
                if (nearestOrthogonalProjectionInScene != null && !(distance < nearestOrthogonalProjectionDistance)) continue;
                nearestOrthogonalProjectionInScene = projection;
                nearestOrthogonalProjectionDistance = distance;
            }
            if (nearestOrthogonalProjectionInScene != null) {
                return nearestOrthogonalProjectionInScene;
            }
            return OrthogonalProjectionStrategy.getNearestBoundsProjection(anchorageReferenceGeometryInScene, anchoredReferencePointInScene);
        }
    }

    public static class ProjectionStrategy
    extends AbstractComputationStrategy {
        public Point computeAnchorageReferencePointInLocal(Node anchorage, IGeometry geometryInLocal, Point anchoredReferencePointInAnchorageLocal) {
            if (geometryInLocal instanceof IShape) {
                IShape shape = (IShape)geometryInLocal;
                Point boundsCenterInLocal = geometryInLocal.getBounds().getCenter();
                if (shape.contains(boundsCenterInLocal)) {
                    return boundsCenterInLocal;
                }
                Point nearestVertex = this.getNearestVertex(boundsCenterInLocal, shape);
                if (nearestVertex != null) {
                    return nearestVertex;
                }
                throw new IllegalArgumentException("The given IShape does not provide any vertices.");
            }
            if (geometryInLocal instanceof ICurve) {
                return this.getNearestVertex(anchoredReferencePointInAnchorageLocal, (ICurve)geometryInLocal);
            }
            if (geometryInLocal instanceof Path) {
                Point boundsCenterInLocal = geometryInLocal.getBounds().getCenter();
                if (geometryInLocal.contains(boundsCenterInLocal)) {
                    return boundsCenterInLocal;
                }
                Point nearestVertex = this.getNearestVertex(boundsCenterInLocal, (Path)geometryInLocal);
                if (nearestVertex != null) {
                    return nearestVertex;
                }
                throw new IllegalArgumentException("The given Path does not provide any vertices.");
            }
            throw new IllegalArgumentException("Unknwon IGeometry: <" + geometryInLocal.getClass() + ">.");
        }

        protected Point computeAnchorageReferencePointInScene(Node anchorage, IGeometry geometryInLocal, Point anchoredReferencePointInScene) {
            Point2D anchoredReferencePointInAnchorageLocal = anchorage.sceneToLocal(anchoredReferencePointInScene.x, anchoredReferencePointInScene.y);
            return NodeUtils.localToScene(anchorage, this.computeAnchorageReferencePointInLocal(anchorage, geometryInLocal, new Point(anchoredReferencePointInAnchorageLocal.getX(), anchoredReferencePointInAnchorageLocal.getY())));
        }

        @Override
        public Point computePositionInScene(Node anchorage, Node anchored, Point anchoredReferencePointInLocal) {
            IGeometry anchorageReferenceGeometryInLocal = this.getAnchorageReferenceGeometryInLocal(anchorage);
            Point anchoredReferencePointInScene = NodeUtils.localToScene(anchored, anchoredReferencePointInLocal);
            Point anchorageReferencePointInScene = this.computeAnchorageReferencePointInScene(anchorage, anchorageReferenceGeometryInLocal, anchoredReferencePointInScene);
            Line referenceLineInScene = new Line(anchorageReferencePointInScene, anchoredReferencePointInScene);
            IGeometry anchorageGeometryInScene = NodeUtils.localToScene(anchorage, anchorageReferenceGeometryInLocal);
            List<ICurve> anchorageOutlinesInScene = ProjectionStrategy.getOutlineSegments(anchorageGeometryInScene);
            Point nearestProjectionInScene = null;
            double nearestDistance = 0.0;
            for (ICurve anchorageOutlineInScene : anchorageOutlinesInScene) {
                Point[] intersections = anchorageOutlineInScene.getIntersections((ICurve)referenceLineInScene);
                if (intersections.length <= 0) continue;
                Point nearestIntersection = Point.nearest((Point)anchoredReferencePointInScene, (Point[])intersections);
                double distance = anchoredReferencePointInScene.getDistance(nearestIntersection);
                if (nearestProjectionInScene != null && !(distance < nearestDistance)) continue;
                nearestProjectionInScene = nearestIntersection;
                nearestDistance = distance;
            }
            if (nearestProjectionInScene != null) {
                return nearestProjectionInScene;
            }
            return anchorageReferencePointInScene;
        }

        protected Point getNearestVertex(Point boundsCenter, ICurve curve) {
            BezierCurve[] beziers;
            HashSet<Point> vertices = new HashSet<Point>();
            BezierCurve[] bezierCurveArray = beziers = curve.toBezier();
            int n = beziers.length;
            int n2 = 0;
            while (n2 < n) {
                BezierCurve bezier = bezierCurveArray[n2];
                double t = 0.0;
                while (t <= 1.0) {
                    vertices.add(bezier.get(t));
                    t += 0.015625;
                }
                ++n2;
            }
            if (vertices.isEmpty()) {
                return null;
            }
            Point[] vi = vertices.toArray(new Point[0]);
            Point nearest = vi[0];
            double nearestDistance = boundsCenter.getDistance(nearest);
            int i = 1;
            while (i < vi.length) {
                double distance = boundsCenter.getDistance(vi[i]);
                if (distance < nearestDistance) {
                    nearest = vi[i];
                    nearestDistance = distance;
                }
                ++i;
            }
            return nearest;
        }

        protected Point getNearestVertex(Point boundsCenter, IShape shape) {
            ICurve[] outlineSegments = shape.getOutlineSegments();
            if (outlineSegments.length == 0) {
                return null;
            }
            Point nearestVertex = outlineSegments[0].getP1();
            double minDistance = boundsCenter.getDistance(nearestVertex);
            int i = 1;
            while (i < outlineSegments.length) {
                Point v = outlineSegments[i].getP1();
                double d = boundsCenter.getDistance(v);
                if (d < minDistance) {
                    nearestVertex = v;
                    minDistance = d;
                }
                ++i;
            }
            return nearestVertex;
        }

        protected Point getNearestVertex(Point boundsCenter, Path path) {
            Path.Segment[] segments = path.getSegments();
            if (segments.length < 1) {
                return null;
            }
            Point nearestVertex = null;
            double minDistance = 0.0;
            int i = 0;
            while (i < segments.length) {
                Point[] points = segments[i].getPoints();
                if (points.length > 0) {
                    if (nearestVertex == null) {
                        nearestVertex = points[0].getCopy();
                        minDistance = boundsCenter.getDistance(nearestVertex);
                    } else {
                        double distance = boundsCenter.getDistance(points[0]);
                        if (distance < minDistance) {
                            nearestVertex = points[0].getCopy();
                            minDistance = distance;
                        }
                    }
                }
                ++i;
            }
            return null;
        }
    }
}

