/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Translate;
import org.eclipse.gef4.common.beans.property.ReadOnlyMapWrapperEx;
import org.eclipse.gef4.fx.anchors.AnchorKey;
import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.fx.anchors.StaticAnchor;
import org.eclipse.gef4.fx.nodes.GeometryNode;
import org.eclipse.gef4.fx.nodes.IConnectionInterpolator;
import org.eclipse.gef4.fx.nodes.IConnectionRouter;
import org.eclipse.gef4.fx.nodes.PolylineInterpolator;
import org.eclipse.gef4.fx.nodes.StraightRouter;
import org.eclipse.gef4.fx.utils.Geometry2Shape;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Point;

public class Connection
extends Group {
    public static final String CSS_CLASS_DECORATION = "decoration";
    private static final String START_ROLE = "start";
    private static final String END_ROLE = "end";
    private static final String CONTROL_POINT_ROLE_PREFIX = "controlpoint-";
    private GeometryNode<ICurve> curveNode = new GeometryNode();
    private Shape startDecoration = null;
    private Shape endDecoration = null;
    private ObjectProperty<IConnectionRouter> routerProperty = new SimpleObjectProperty((Object)new StraightRouter());
    private ObjectProperty<IConnectionInterpolator> interpolatorProperty = new SimpleObjectProperty((Object)new PolylineInterpolator());
    private ReadOnlyMapWrapper<AnchorKey, IAnchor> anchorsProperty = new ReadOnlyMapWrapperEx(FXCollections.observableHashMap());
    private SortedSet<AnchorKey> controlAnchorKeys = new TreeSet<AnchorKey>(new Comparator<AnchorKey>(){

        @Override
        public int compare(AnchorKey o1, AnchorKey o2) {
            int o1Index = Connection.this.getControlAnchorIndex(o1);
            int o2Index = Connection.this.getControlAnchorIndex(o2);
            return o1Index - o2Index;
        }
    });
    private boolean inRefresh = false;
    private Map<AnchorKey, MapChangeListener<? super AnchorKey, ? super Point>> anchorPCL = new HashMap<AnchorKey, MapChangeListener<? super AnchorKey, ? super Point>>();
    private ChangeListener<Bounds> decorationLayoutBoundsListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
            Connection.this.refresh();
        }
    };

    public Connection() {
        this.setAutoSizeChildren(false);
        this.getChildren().add(this.curveNode);
    }

    protected void addAnchor(IAnchor anchor, AnchorKey anchorKey, int controlIndex) {
        ArrayList<IAnchor> controlAnchorsToMove = new ArrayList<IAnchor>();
        if (!anchorKey.equals(this.getStartAnchorKey()) && !anchorKey.equals(this.getEndAnchorKey())) {
            int controlPointCount = this.controlAnchorKeys.size();
            int i = controlPointCount - 1;
            while (i >= controlIndex) {
                AnchorKey ak = this.getControlAnchorKey(i);
                IAnchor a = this.getControlAnchor(i);
                controlAnchorsToMove.add(0, a);
                this.controlAnchorKeys.remove(ak);
                this.anchorsProperty.remove((Object)ak);
                a.detach(ak, null);
                --i;
            }
            this.controlAnchorKeys.add(anchorKey);
        }
        this.anchorsProperty.put((Object)anchorKey, (Object)anchor);
        anchor.attach(anchorKey, null);
        if (!anchorKey.equals(this.getStartAnchorKey()) && !anchorKey.equals(this.getEndAnchorKey())) {
            int i = 0;
            while (i < controlAnchorsToMove.size()) {
                AnchorKey ak = this.getControlAnchorKey(controlIndex + i + 1);
                IAnchor a = (IAnchor)controlAnchorsToMove.get(i);
                this.controlAnchorKeys.add(ak);
                this.anchorsProperty.put((Object)ak, (Object)a);
                a.attach(ak, null);
                ++i;
            }
        }
        if (!this.anchorPCL.containsKey(anchorKey)) {
            MapChangeListener<? super AnchorKey, ? super Point> pcl = this.createPCL(anchorKey);
            this.anchorPCL.put(anchorKey, pcl);
            anchor.positionProperty().addListener(pcl);
        }
        this.refresh();
    }

    public void addControlAnchor(int index, IAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        this.addAnchor(anchor, this.getControlAnchorKey(index), index);
    }

    public void addControlPoint(int index, Point controlPointInLocal) {
        if (controlPointInLocal == null) {
            controlPointInLocal = new Point();
        }
        StaticAnchor anchor = new StaticAnchor((Node)this, controlPointInLocal);
        this.addControlAnchor(index, anchor);
    }

    protected ReadOnlyMapProperty<AnchorKey, IAnchor> anchorsProperty() {
        return this.anchorsProperty.getReadOnlyProperty();
    }

    protected void arrangeDecoration(Shape decoration, Point start, Vector direction) {
        decoration.getTransforms().clear();
        decoration.getTransforms().add((Object)new Translate(start.x, start.y));
        if (!direction.isNull()) {
            Angle angleCW = new Vector(1.0, 0.0).getAngleCW(direction);
            decoration.getTransforms().add((Object)new Rotate(angleCW.deg(), 0.0, 0.0));
        }
        decoration.getTransforms().add((Object)new Translate(-NodeUtils.getShapeBounds((Node)decoration).getX(), 0.0));
    }

    protected void arrangeEndDecoration() {
        if (this.endDecoration == null) {
            return;
        }
        Point endPoint = this.getEndPoint();
        ICurve curve = this.getCurveNode().getGeometry();
        if (curve == null || endPoint == null) {
            return;
        }
        BezierCurve[] beziers = curve.toBezier();
        if (beziers.length == 0) {
            return;
        }
        BezierCurve endDerivative = beziers[beziers.length - 1].getDerivative();
        Point slope = endDerivative.get(1.0);
        if (slope.equals(0.0, 0.0)) {
            slope = endDerivative.get(0.99);
        }
        Vector endDirection = new Vector(slope.getNegated());
        this.arrangeDecoration(this.endDecoration, endPoint, endDirection);
    }

    protected void arrangeStartDecoration() {
        if (this.startDecoration == null) {
            return;
        }
        Point startPoint = this.getStartPoint();
        ICurve curve = this.getCurveNode().getGeometry();
        if (curve == null || startPoint == null) {
            return;
        }
        BezierCurve[] beziers = curve.toBezier();
        if (beziers.length == 0) {
            return;
        }
        BezierCurve startDerivative = beziers[0].getDerivative();
        Point slope = startDerivative.get(0.0);
        if (slope.equals(0.0, 0.0)) {
            slope = startDerivative.get(0.01);
        }
        Vector curveStartDirection = new Vector(slope);
        this.arrangeDecoration(this.startDecoration, startPoint, curveStartDirection);
    }

    protected Shape clipAtDecoration(Shape curveClip, Shape decoration) {
        Path decorationShapeBounds = new Path(Geometry2Shape.toPathElements(NodeUtils.localToScene((Node)decoration, (IGeometry)NodeUtils.getShapeBounds((Node)decoration)).toPath()));
        decorationShapeBounds.setFill((Paint)Color.RED);
        Shape clip = Shape.intersect((Shape)decorationShapeBounds, (Shape)this.curveNode.getGeometricShape());
        clip = Shape.subtract((Shape)clip, (Shape)decoration);
        clip = Shape.subtract((Shape)curveClip, (Shape)clip);
        return clip;
    }

    protected MapChangeListener<? super AnchorKey, ? super Point> createPCL(final AnchorKey anchorKey) {
        return new MapChangeListener<AnchorKey, Point>(){

            public void onChanged(MapChangeListener.Change<? extends AnchorKey, ? extends Point> change) {
                if (((AnchorKey)change.getKey()).equals(anchorKey)) {
                    Connection.this.refresh();
                }
            }
        };
    }

    public IAnchor getAnchor(int index) {
        if (index == 0) {
            return this.getStartAnchor();
        }
        if (index == this.controlAnchorKeys.size() + 1) {
            return this.getEndAnchor();
        }
        return this.getControlAnchor(index - 1);
    }

    public int getAnchorIndex(AnchorKey anchorKey) {
        if (anchorKey.equals(this.getStartAnchorKey())) {
            return 0;
        }
        if (anchorKey.equals(this.getEndAnchorKey())) {
            return this.getAnchors().size() - 1;
        }
        return this.getControlAnchorIndex(anchorKey) + 1;
    }

    public AnchorKey getAnchorKey(int anchorIndex) {
        if (anchorIndex < 0 || anchorIndex >= this.getAnchors().size()) {
            throw new IllegalArgumentException("The given anchor index is out of bounds.");
        }
        if (anchorIndex == 0) {
            return this.getStartAnchorKey();
        }
        if (anchorIndex == this.getAnchors().size() - 1) {
            return this.getEndAnchorKey();
        }
        return this.getControlAnchorKey(anchorIndex - 1);
    }

    public List<IAnchor> getAnchors() {
        int controlPointCount = this.controlAnchorKeys.size();
        ArrayList<IAnchor> anchors = new ArrayList<IAnchor>(controlPointCount + 2);
        IAnchor startAnchor = this.getStartAnchor();
        if (startAnchor == null) {
            throw new IllegalStateException("Start anchor may never be null.");
        }
        anchors.add(startAnchor);
        anchors.addAll(this.getControlAnchors());
        IAnchor endAnchor = this.getEndAnchor();
        if (endAnchor == null) {
            throw new IllegalStateException("End anchor may never be null.");
        }
        anchors.add(endAnchor);
        return anchors;
    }

    public Point getCenter() {
        BezierCurve[] bezierCurves = this.getCurveNode().getGeometry().toBezier();
        if (bezierCurves.length % 2 == 0) {
            return this.getPoint((int)((double)this.getPoints().size() - 0.5) / 2);
        }
        return bezierCurves[bezierCurves.length / 2].get(0.5);
    }

    public IAnchor getControlAnchor(int index) {
        return (IAnchor)this.anchorsProperty.get((Object)this.getControlAnchorKey(index));
    }

    public int getControlAnchorIndex(AnchorKey key) {
        if (!key.getId().startsWith(CONTROL_POINT_ROLE_PREFIX)) {
            throw new IllegalArgumentException("Given AnchorKey " + key + " is no control anchor key.");
        }
        int index = Integer.parseInt(key.getId().substring(CONTROL_POINT_ROLE_PREFIX.length()));
        return index;
    }

    public AnchorKey getControlAnchorKey(int index) {
        return new AnchorKey((Node)this.getCurveNode(), CONTROL_POINT_ROLE_PREFIX + index);
    }

    public List<IAnchor> getControlAnchors() {
        int controlPointsCount = this.controlAnchorKeys.size();
        ArrayList<IAnchor> controlPointAnchors = new ArrayList<IAnchor>(controlPointsCount);
        int i = 0;
        while (i < controlPointsCount) {
            IAnchor controlAnchor = this.getControlAnchor(i);
            if (controlAnchor == null) {
                throw new IllegalStateException("control anchor may never be null.");
            }
            controlPointAnchors.add(controlAnchor);
            ++i;
        }
        return controlPointAnchors;
    }

    public Point getControlPoint(int index) {
        IAnchor anchor = this.getControlAnchor(index);
        if (anchor == null) {
            throw new IllegalArgumentException("No controlpoint at index " + index);
        }
        if (!anchor.isAttached(this.getControlAnchorKey(index))) {
            return null;
        }
        return FX2Geometry.toPoint((Point2D)this.getCurveNode().localToParent(Geometry2FX.toFXPoint((Point)anchor.getPosition(this.getControlAnchorKey(index)))));
    }

    public List<Point> getControlPoints() {
        List<IAnchor> controlPointAnchors = this.getControlAnchors();
        ArrayList<Point> controlPoints = new ArrayList<Point>(controlPointAnchors.size());
        int i = 0;
        while (i < controlPointAnchors.size()) {
            controlPoints.add(controlPointAnchors.get(i).getPosition(this.getControlAnchorKey(i)));
            ++i;
        }
        return controlPoints;
    }

    public GeometryNode<ICurve> getCurveNode() {
        return this.curveNode;
    }

    public IAnchor getEndAnchor() {
        return (IAnchor)this.anchorsProperty.get((Object)this.getEndAnchorKey());
    }

    public AnchorKey getEndAnchorKey() {
        return new AnchorKey((Node)this.getCurveNode(), END_ROLE);
    }

    public Node getEndDecoration() {
        return this.endDecoration;
    }

    public Point getEndPoint() {
        IAnchor anchor = this.getEndAnchor();
        if (anchor == null) {
            return null;
        }
        if (!anchor.isAttached(this.getEndAnchorKey())) {
            return null;
        }
        return FX2Geometry.toPoint((Point2D)this.getCurveNode().localToParent(Geometry2FX.toFXPoint((Point)anchor.getPosition(this.getEndAnchorKey()))));
    }

    public IConnectionInterpolator getInterpolator() {
        return (IConnectionInterpolator)this.interpolatorProperty.get();
    }

    public Point getPoint(int index) {
        if (index == 0) {
            return this.getStartPoint();
        }
        if (index == this.controlAnchorKeys.size() + 1) {
            return this.getEndPoint();
        }
        return this.getControlPoint(index - 1);
    }

    public List<Point> getPoints() {
        int controlPointCount = this.controlAnchorKeys.size();
        Point[] points = new Point[controlPointCount + 2];
        points[0] = this.getStartPoint();
        if (points[0] == null) {
            return Collections.emptyList();
        }
        int i = 0;
        while (i < controlPointCount) {
            points[i + 1] = this.getControlPoint(i);
            if (points[i + 1] == null) {
                return Collections.emptyList();
            }
            ++i;
        }
        points[points.length - 1] = this.getEndPoint();
        if (points[points.length - 1] == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(points);
    }

    public IConnectionRouter getRouter() {
        return (IConnectionRouter)this.routerProperty.get();
    }

    public IAnchor getStartAnchor() {
        return (IAnchor)this.anchorsProperty.get((Object)this.getStartAnchorKey());
    }

    public AnchorKey getStartAnchorKey() {
        return new AnchorKey((Node)this.getCurveNode(), START_ROLE);
    }

    public Node getStartDecoration() {
        return this.startDecoration;
    }

    public Point getStartPoint() {
        IAnchor anchor = this.getStartAnchor();
        if (anchor == null) {
            return null;
        }
        if (!anchor.isAttached(this.getStartAnchorKey())) {
            return null;
        }
        return FX2Geometry.toPoint((Point2D)this.getCurveNode().localToParent(Geometry2FX.toFXPoint((Point)anchor.getPosition(this.getStartAnchorKey()))));
    }

    public ObjectProperty<IConnectionInterpolator> interpolatorProperty() {
        return this.interpolatorProperty;
    }

    public boolean isConnected(int index) {
        if (index < 0 || index >= this.getAnchors().size()) {
            throw new IllegalArgumentException("The given index is out of bounds.");
        }
        if (index == 0) {
            return this.isStartConnected();
        }
        if (index == this.getAnchors().size() - 1) {
            return this.isEndConnected();
        }
        return this.isControlConnected(index - 1);
    }

    public boolean isControlConnected(int index) {
        IAnchor anchor = this.getControlAnchor(index);
        return anchor.getAnchorage() != null && anchor.getAnchorage() != this;
    }

    public boolean isEndConnected() {
        IAnchor anchor = this.getEndAnchor();
        return anchor != null && anchor.getAnchorage() != null && anchor.getAnchorage() != this;
    }

    public boolean isStartConnected() {
        IAnchor anchor = this.getStartAnchor();
        return anchor != null && anchor.getAnchorage() != null && anchor.getAnchorage() != this;
    }

    protected void refresh() {
        if (this.inRefresh) {
            return;
        }
        this.inRefresh = true;
        this.getRouter().route(this);
        ICurve newGeometry = this.getInterpolator().interpolate(this);
        this.getChildren().retainAll((Object[])new Node[]{this.curveNode});
        if (!newGeometry.equals(this.curveNode.getGeometry())) {
            this.curveNode.setGeometry(newGeometry);
        }
        if (this.startDecoration != null) {
            this.getChildren().add((Object)this.startDecoration);
            this.arrangeStartDecoration();
        }
        if (this.endDecoration != null) {
            this.getChildren().add((Object)this.endDecoration);
            this.arrangeEndDecoration();
        }
        if (!(newGeometry.getBounds().isEmpty() || this.startDecoration == null && this.endDecoration == null)) {
            Bounds layoutBounds = this.curveNode.localToScene(this.curveNode.getLayoutBounds());
            Rectangle clip = new Rectangle(layoutBounds.getMinX(), layoutBounds.getMinY(), layoutBounds.getWidth(), layoutBounds.getHeight());
            clip.setFill((Paint)Color.RED);
            if (this.startDecoration != null) {
                clip = this.clipAtDecoration((Shape)clip, this.startDecoration);
            }
            if (this.endDecoration != null) {
                clip = this.clipAtDecoration((Shape)clip, this.endDecoration);
            }
            clip.getTransforms().add((Object)Geometry2FX.toFXAffine((AffineTransform)NodeUtils.getSceneToLocalTx(this.curveNode)));
            this.curveNode.setClip((Node)clip);
        } else {
            this.curveNode.setClip(null);
        }
        this.inRefresh = false;
    }

    public void removeAllControlAnchors() {
        this.removeAllControlPoints();
    }

    public void removeAllControlPoints() {
        int i = this.controlAnchorKeys.size() - 1;
        while (i >= 0) {
            this.removeControlPoint(i);
            --i;
        }
    }

    protected void removeAnchor(AnchorKey anchorKey, IAnchor anchor) {
        if (this.anchorPCL.containsKey(anchorKey)) {
            anchor.positionProperty().removeListener(this.anchorPCL.remove(anchorKey));
        }
        ArrayList<IAnchor> controlAnchorsToMove = new ArrayList<IAnchor>();
        int controlIndex = -1;
        if (!anchorKey.equals(this.getStartAnchorKey()) && !anchorKey.equals(this.getEndAnchorKey()) && this.controlAnchorKeys.contains(anchorKey)) {
            controlIndex = this.getControlAnchorIndex(anchorKey);
            int controlPointCount = this.controlAnchorKeys.size();
            int i = controlPointCount - 1;
            while (i > controlIndex) {
                AnchorKey ak = this.getControlAnchorKey(i);
                IAnchor a = this.getControlAnchor(i);
                controlAnchorsToMove.add(0, a);
                this.controlAnchorKeys.remove(ak);
                this.anchorsProperty.remove((Object)ak);
                a.detach(ak, null);
                --i;
            }
            this.controlAnchorKeys.remove(anchorKey);
        }
        this.anchorsProperty.remove((Object)anchorKey);
        anchor.detach(anchorKey, null);
        if (!anchorKey.equals(this.getStartAnchorKey()) && !anchorKey.equals(this.getEndAnchorKey())) {
            int i = 0;
            while (i < controlAnchorsToMove.size()) {
                AnchorKey ak = this.getControlAnchorKey(controlIndex + i);
                IAnchor a = (IAnchor)controlAnchorsToMove.get(i);
                this.controlAnchorKeys.add(ak);
                this.anchorsProperty.put((Object)ak, (Object)a);
                a.attach(ak, null);
                ++i;
            }
        }
        this.refresh();
    }

    public void removeControlAnchor(int index) {
        this.removeControlPoint(index);
    }

    public void removeControlPoint(int index) {
        if (index < 0 || index >= this.controlAnchorKeys.size()) {
            throw new IllegalArgumentException("Index out of range (index: " + index + ", size: " + this.controlAnchorKeys.size() + ").");
        }
        AnchorKey anchorKey = this.getControlAnchorKey(index);
        if (!this.anchorsProperty.containsKey((Object)anchorKey)) {
            throw new IllegalStateException("Inconsistent state: control anchor not in map!");
        }
        IAnchor oldAnchor = (IAnchor)this.anchorsProperty.get((Object)anchorKey);
        this.removeAnchor(anchorKey, oldAnchor);
    }

    public ObjectProperty<IConnectionRouter> routerProperty() {
        return this.routerProperty;
    }

    public void setAnchors(List<IAnchor> anchors) {
        if (anchors.size() < 2) {
            throw new IllegalArgumentException("start end end anchors have to be provided.");
        }
        boolean oldInRefresh = this.inRefresh;
        this.inRefresh = true;
        this.setStartAnchor(anchors.get(0));
        if (anchors.size() > 2) {
            this.setControlAnchors(anchors.subList(1, anchors.size() - 1));
        } else {
            this.removeAllControlPoints();
        }
        this.setEndAnchor(anchors.get(anchors.size() - 1));
        this.inRefresh = oldInRefresh;
        this.refresh();
    }

    public void setControlAnchor(int index, IAnchor anchor) {
        if (index < 0 || index >= this.controlAnchorKeys.size()) {
            throw new IllegalArgumentException("index out of range.");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        AnchorKey anchorKey = this.getControlAnchorKey(index);
        IAnchor oldAnchor = (IAnchor)this.anchorsProperty.get((Object)anchorKey);
        if (oldAnchor != anchor) {
            if (oldAnchor != null) {
                boolean oldInRefresh = this.inRefresh;
                this.inRefresh = true;
                this.removeAnchor(anchorKey, oldAnchor);
                this.inRefresh = oldInRefresh;
            }
            this.addAnchor(anchor, anchorKey, index);
        }
    }

    public void setControlAnchors(List<IAnchor> anchors) {
        int controlPointsSize = this.controlAnchorKeys.size();
        boolean oldInRefresh = this.inRefresh;
        this.inRefresh = true;
        int i = controlPointsSize - 1;
        while (i >= anchors.size()) {
            this.removeControlPoint(i);
            --i;
        }
        i = 0;
        while (i < controlPointsSize && i < anchors.size()) {
            this.setControlAnchor(i, anchors.get(i));
            ++i;
        }
        i = controlPointsSize;
        while (i < anchors.size()) {
            this.addControlAnchor(i, anchors.get(i));
            ++i;
        }
        this.inRefresh = oldInRefresh;
        this.refresh();
    }

    public void setControlPoint(int index, Point controlPointInLocal) {
        if (controlPointInLocal == null) {
            controlPointInLocal = new Point();
        }
        StaticAnchor anchor = new StaticAnchor((Node)this, controlPointInLocal);
        this.setControlAnchor(index, anchor);
    }

    public void setControlPoints(List<Point> controlPoints) {
        int controlSize = this.controlAnchorKeys.size();
        boolean oldInRefresh = this.inRefresh;
        this.inRefresh = true;
        int i = 0;
        while (i < controlSize && i < controlPoints.size()) {
            this.setControlPoint(i, controlPoints.get(i));
            ++i;
        }
        while (i < controlPoints.size()) {
            this.addControlPoint(i, controlPoints.get(i));
            ++i;
        }
        int initialRemovalIndex = i;
        while (i < controlSize) {
            this.removeControlPoint(controlSize - 1 - (i - initialRemovalIndex));
            ++i;
        }
        this.inRefresh = oldInRefresh;
        this.refresh();
    }

    public void setEndAnchor(IAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        AnchorKey anchorKey = this.getEndAnchorKey();
        IAnchor oldAnchor = (IAnchor)this.anchorsProperty.get((Object)anchorKey);
        if (oldAnchor != anchor) {
            if (oldAnchor != null) {
                boolean oldInRefresh = this.inRefresh;
                this.inRefresh = true;
                this.removeAnchor(anchorKey, oldAnchor);
                this.inRefresh = oldInRefresh;
            }
            this.addAnchor(anchor, anchorKey, -1);
        }
    }

    public void setEndDecoration(Shape endDeco) {
        if (this.endDecoration != null) {
            this.endDecoration.layoutBoundsProperty().removeListener(this.decorationLayoutBoundsListener);
        }
        this.endDecoration = endDeco;
        if (this.endDecoration != null) {
            this.endDecoration.layoutBoundsProperty().addListener(this.decorationLayoutBoundsListener);
            ObservableList styleClasses = this.endDecoration.getStyleClass();
            if (!styleClasses.contains((Object)CSS_CLASS_DECORATION)) {
                styleClasses.add((Object)CSS_CLASS_DECORATION);
            }
        }
        this.refresh();
    }

    public void setEndPoint(Point endPointInLocal) {
        if (endPointInLocal == null) {
            endPointInLocal = new Point();
        }
        StaticAnchor anchor = new StaticAnchor((Node)this, endPointInLocal);
        this.setEndAnchor(anchor);
    }

    public void setInterpolator(IConnectionInterpolator interpolator) {
        this.interpolatorProperty.set((Object)interpolator);
    }

    public void setRouter(IConnectionRouter router) {
        this.routerProperty.set((Object)router);
        this.refresh();
    }

    public void setStartAnchor(IAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        AnchorKey anchorKey = this.getStartAnchorKey();
        IAnchor oldAnchor = (IAnchor)this.anchorsProperty.get((Object)anchorKey);
        if (oldAnchor != anchor) {
            if (oldAnchor != null) {
                boolean oldInRefresh = this.inRefresh;
                this.inRefresh = true;
                this.removeAnchor(anchorKey, oldAnchor);
                this.inRefresh = oldInRefresh;
            }
            this.addAnchor(anchor, anchorKey, -1);
        }
    }

    public void setStartDecoration(Shape startDeco) {
        if (this.startDecoration != null) {
            this.startDecoration.layoutBoundsProperty().removeListener(this.decorationLayoutBoundsListener);
        }
        this.startDecoration = startDeco;
        if (this.startDecoration != null) {
            this.startDecoration.layoutBoundsProperty().addListener(this.decorationLayoutBoundsListener);
            ObservableList styleClasses = this.startDecoration.getStyleClass();
            if (!styleClasses.contains((Object)CSS_CLASS_DECORATION)) {
                styleClasses.add((Object)CSS_CLASS_DECORATION);
            }
        }
        this.refresh();
    }

    public void setStartPoint(Point startPointInLocal) {
        if (startPointInLocal == null) {
            startPointInLocal = new Point();
        }
        StaticAnchor anchor = new StaticAnchor((Node)this, startPointInLocal);
        this.setStartAnchor(anchor);
    }
}

