/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.nodes;

import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Parent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef4.fx.utils.Geometry2Shape;
import org.eclipse.gef4.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Arc;
import org.eclipse.gef4.geometry.planar.Ellipse;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IScalable;
import org.eclipse.gef4.geometry.planar.Pie;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.geometry.planar.RoundedRectangle;

public class GeometryNode<T extends IGeometry>
extends Parent {
    private Path geometricShape = new Path();
    private Path layoutBoundsComputationShape = new Path();
    private Path clickableAreaShape = null;
    private DoubleProperty clickableAreaWidth = new SimpleDoubleProperty();
    private ObjectProperty<T> geometryProperty = new SimpleObjectProperty();
    private double resizeWidth = Double.NaN;
    private double resizeHeight = Double.NaN;
    private ChangeListener<T> geometryChangeListener = new ChangeListener<T>(){

        public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
            GeometryNode.this.resizeWidth = Double.NaN;
            GeometryNode.this.resizeHeight = Double.NaN;
            if (newValue != null) {
                GeometryNode.this.updateVisuals();
            }
        }
    };

    public GeometryNode() {
        this.getChildren().add((Object)this.geometricShape);
        this.getStyleClass().addListener((ListChangeListener)new ListChangeListener<String>(){

            public void onChanged(ListChangeListener.Change<? extends String> c) {
                while (c.next()) {
                    if (c.wasPermutated() || c.wasUpdated()) {
                        GeometryNode.this.geometricShape.getStyleClass().clear();
                        GeometryNode.this.geometricShape.getStyleClass().addAll((Collection)GeometryNode.this.getStyleClass());
                        continue;
                    }
                    GeometryNode.this.geometricShape.getStyleClass().removeAll((Collection)c.getRemoved());
                    GeometryNode.this.geometricShape.getStyleClass().addAll((Collection)c.getAddedSubList());
                }
            }
        });
        this.styleProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                GeometryNode.this.geometricShape.setStyle(newValue);
            }
        });
        this.clickableAreaWidth.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (newValue != null && newValue.doubleValue() > GeometryNode.this.geometricShape.getStrokeWidth() && GeometryNode.this.clickableAreaShape == null && GeometryNode.this.geometryProperty.getValue() != null) {
                    GeometryNode.this.clickableAreaShape = new Path(Geometry2Shape.toPathElements(((IGeometry)GeometryNode.this.geometryProperty.getValue()).toPath()));
                    GeometryNode.this.clickableAreaShape.setId("clickable area of GeometryNode " + this);
                    GeometryNode.this.clickableAreaShape.setStroke((Paint)Color.TRANSPARENT);
                    GeometryNode.this.clickableAreaShape.setMouseTransparent(false);
                    GeometryNode.this.clickableAreaShape.strokeWidthProperty().bind((ObservableValue)GeometryNode.this.clickableAreaWidthProperty());
                    GeometryNode.this.getChildren().add((Object)GeometryNode.this.clickableAreaShape);
                } else if ((newValue == null || newValue.doubleValue() <= GeometryNode.this.geometricShape.getStrokeWidth()) && GeometryNode.this.clickableAreaShape != null) {
                    GeometryNode.this.getChildren().remove((Object)GeometryNode.this.clickableAreaShape);
                    GeometryNode.this.clickableAreaShape.strokeWidthProperty().unbind();
                    GeometryNode.this.clickableAreaShape = null;
                }
            }
        });
        this.layoutBoundsComputationShape.strokeProperty().bind((ObservableValue)this.geometricShape.strokeProperty());
        this.layoutBoundsComputationShape.strokeLineCapProperty().bind((ObservableValue)this.geometricShape.strokeLineCapProperty());
        this.layoutBoundsComputationShape.strokeLineJoinProperty().bind((ObservableValue)this.geometricShape.strokeLineJoinProperty());
        this.layoutBoundsComputationShape.strokeMiterLimitProperty().bind((ObservableValue)this.geometricShape.strokeMiterLimitProperty());
        this.layoutBoundsComputationShape.strokeTypeProperty().bind((ObservableValue)this.geometricShape.strokeTypeProperty());
        this.layoutBoundsComputationShape.strokeWidthProperty().bind((ObservableValue)this.geometricShape.strokeWidthProperty());
        this.layoutBoundsComputationShape.fillProperty().bind((ObservableValue)this.geometricShape.fillProperty());
        this.layoutBoundsComputationShape.smoothProperty().bind((ObservableValue)this.geometricShape.smoothProperty());
        this.layoutBoundsComputationShape.fillRuleProperty().bind((ObservableValue)this.geometricShape.fillRuleProperty());
        this.geometryProperty.addListener(this.geometryChangeListener);
    }

    public GeometryNode(T geom) {
        this();
        this.setGeometry(geom);
    }

    public DoubleProperty clickableAreaWidthProperty() {
        return this.clickableAreaWidth;
    }

    public final ObjectProperty<Paint> fillProperty() {
        return this.geometricShape.fillProperty();
    }

    public final ObjectProperty<FillRule> fillRuleProperty() {
        return this.geometricShape.fillRuleProperty();
    }

    public ObjectProperty<T> geometryProperty() {
        return this.geometryProperty;
    }

    public double getClickableAreaWidth() {
        return this.clickableAreaWidth.get();
    }

    public final Paint getFill() {
        return this.geometricShape.getFill();
    }

    public final FillRule getFillRule() {
        return this.geometricShape.getFillRule();
    }

    protected Shape getGeometricShape() {
        return this.geometricShape;
    }

    public T getGeometry() {
        return (T)((IGeometry)this.geometryProperty.getValue());
    }

    private PathElement[] getPathElements() {
        return Geometry2Shape.toPathElements(((IGeometry)this.geometryProperty.getValue()).toPath());
    }

    public final Paint getStroke() {
        return this.geometricShape.getStroke();
    }

    public final ObservableList<Double> getStrokeDashArray() {
        return this.geometricShape.getStrokeDashArray();
    }

    public final double getStrokeDashOffset() {
        return this.geometricShape.getStrokeDashOffset();
    }

    public final StrokeLineCap getStrokeLineCap() {
        return this.geometricShape.getStrokeLineCap();
    }

    public final StrokeLineJoin getStrokeLineJoin() {
        return this.geometricShape.getStrokeLineJoin();
    }

    public final double getStrokeMiterLimit() {
        return this.geometricShape.getStrokeMiterLimit();
    }

    public final StrokeType getStrokeType() {
        return this.geometricShape.getStrokeType();
    }

    public final double getStrokeWidth() {
        return this.geometricShape.getStrokeWidth();
    }

    protected Bounds impl_computeLayoutBounds() {
        Bounds layoutBounds = super.impl_computeLayoutBounds();
        double width = Double.isNaN(this.resizeWidth) ? layoutBounds.getWidth() : this.resizeWidth;
        double height = Double.isNaN(this.resizeHeight) ? layoutBounds.getHeight() : this.resizeHeight;
        return Geometry2FX.toFXBounds((Rectangle)new Rectangle(layoutBounds.getMinX(), layoutBounds.getMinY(), width, height));
    }

    public boolean isResizable() {
        return true;
    }

    public final boolean isSmooth() {
        return this.geometricShape.isSmooth();
    }

    public double maxHeight(double width) {
        return this.prefHeight(width);
    }

    public double maxWidth(double height) {
        return this.prefWidth(height);
    }

    public double minHeight(double width) {
        return this.prefHeight(width);
    }

    public double minWidth(double height) {
        return this.prefWidth(height);
    }

    public double prefHeight(double width) {
        double result = this.getLayoutBounds().getHeight();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    public double prefWidth(double height) {
        double result = this.getLayoutBounds().getWidth();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    public void resize(double width, double height) {
        if (width < 0.0) {
            throw new IllegalArgumentException("Cannot resize: width < 0.");
        }
        if (height < 0.0) {
            throw new IllegalArgumentException("Cannot resize: height < 0.");
        }
        if (this.geometryProperty.getValue() == null) {
            return;
        }
        Bounds layoutBounds = this.getLayoutBounds();
        if (layoutBounds.getWidth() == width && layoutBounds.getHeight() == height) {
            return;
        }
        this.geometryProperty.removeListener(this.geometryChangeListener);
        double offset = 0.0;
        if (this.geometricShape.getStroke() != null && this.geometricShape.getStrokeType() != StrokeType.INSIDE) {
            offset = (double)(-(this.geometricShape.getStrokeType() == StrokeType.CENTERED ? 1 : 2)) * this.geometricShape.getStrokeWidth() - 1.0;
        }
        double geometryWidth = width + offset;
        double geometryHeight = height + offset;
        if (geometryWidth < 0.0) {
            geometryWidth = 1.0E-5;
        }
        if (geometryHeight < 0.0) {
            geometryHeight = 1.0E-5;
        }
        this.resizeGeometry(geometryWidth, geometryHeight);
        this.updateVisuals(this.layoutBoundsComputationShape);
        layoutBounds = this.layoutBoundsComputationShape.getLayoutBounds();
        double dw = layoutBounds.getWidth() - width;
        double dh = layoutBounds.getHeight() - height;
        double previousDw = Double.MAX_VALUE;
        double previousDh = Double.MAX_VALUE;
        while (dw != 0.0 || dh != 0.0) {
            if (Math.abs(previousDw) > Math.abs(dw) && Math.abs(dw) > 1.0E-5) {
                if ((geometryWidth -= dw) < 0.0) {
                    geometryWidth = 0.0;
                }
            } else {
                dw = 0.0;
            }
            if (Math.abs(previousDh) > Math.abs(dh) && Math.abs(dh) > 1.0E-5) {
                if ((geometryHeight -= dh) < 0.0) {
                    geometryHeight = 0.0;
                }
            } else {
                dh = 0.0;
            }
            this.resizeGeometry(geometryWidth, geometryHeight);
            this.updateVisuals(this.layoutBoundsComputationShape);
            layoutBounds = this.layoutBoundsComputationShape.getLayoutBounds();
            previousDw = dw;
            if (dw != 0.0) {
                dw = layoutBounds.getWidth() - width;
            }
            previousDh = dh;
            if (dh == 0.0) continue;
            dh = layoutBounds.getHeight() - height;
        }
        this.resizeWidth = layoutBounds.getWidth() != width ? width : Double.NaN;
        this.resizeHeight = layoutBounds.getHeight() != height ? height : Double.NaN;
        this.geometryProperty.addListener(this.geometryChangeListener);
        this.updateVisuals();
    }

    public void resizeGeometry(double width, double height) {
        IGeometry geometry = (IGeometry)this.geometryProperty.getValue();
        if (geometry instanceof Rectangle) {
            ((Rectangle)geometry).setSize(width, height);
        } else if (geometry instanceof RoundedRectangle) {
            ((RoundedRectangle)geometry).setSize(width, height);
        } else if (geometry instanceof Ellipse) {
            ((Ellipse)geometry).setSize(width, height);
        } else if (geometry instanceof Pie) {
            ((Pie)geometry).setSize(width, height);
        } else if (geometry instanceof Arc) {
            ((Arc)geometry).setSize(width, height);
        } else {
            Rectangle geometricBounds = geometry.getBounds();
            double sx = width / geometricBounds.getWidth();
            double sy = height / geometricBounds.getHeight();
            if (geometry instanceof IScalable) {
                ((IScalable)geometry).scale(sx, sy, geometricBounds.getX(), geometricBounds.getY());
            } else {
                Point boundsOrigin = new Point(geometricBounds.getX(), geometricBounds.getY());
                this.geometryProperty.setValue((Object)geometry.getTransformed(new AffineTransform(1.0, 0.0, 0.0, 1.0, -boundsOrigin.x, -boundsOrigin.y)).getTransformed(new AffineTransform(sx, 0.0, 0.0, sy, 0.0, 0.0)).getTransformed(new AffineTransform(1.0, 0.0, 0.0, 1.0, boundsOrigin.x, boundsOrigin.y)));
            }
        }
    }

    public void setClickableAreaWidth(double clickableAreaWidth) {
        this.clickableAreaWidth.set(clickableAreaWidth);
    }

    public final void setFill(Paint value) {
        this.geometricShape.setFill(value);
    }

    public final void setFillRule(FillRule value) {
        this.geometricShape.setFillRule(value);
    }

    public void setGeometry(T geometry) {
        this.geometryProperty.setValue(geometry);
    }

    public final void setSmooth(boolean value) {
        this.geometricShape.setSmooth(value);
    }

    public final void setStroke(Paint value) {
        this.geometricShape.setStroke(value);
    }

    public final void setStrokeDashOffset(double value) {
        this.geometricShape.setStrokeDashOffset(value);
    }

    public final void setStrokeLineCap(StrokeLineCap value) {
        this.geometricShape.setStrokeLineCap(value);
    }

    public final void setStrokeLineJoin(StrokeLineJoin value) {
        this.geometricShape.setStrokeLineJoin(value);
    }

    public final void setStrokeMiterLimit(double value) {
        this.geometricShape.setStrokeMiterLimit(value);
    }

    public final void setStrokeType(StrokeType value) {
        this.geometricShape.setStrokeType(value);
    }

    public final void setStrokeWidth(double value) {
        this.geometricShape.setStrokeWidth(value);
    }

    public final BooleanProperty smoothProperty() {
        return this.geometricShape.smoothProperty();
    }

    public final DoubleProperty strokeDashOffsetProperty() {
        return this.geometricShape.strokeDashOffsetProperty();
    }

    public final ObjectProperty<StrokeLineCap> strokeLineCapProperty() {
        return this.geometricShape.strokeLineCapProperty();
    }

    public final ObjectProperty<StrokeLineJoin> strokeLineJoinProperty() {
        return this.geometricShape.strokeLineJoinProperty();
    }

    public final DoubleProperty strokeMiterLimitProperty() {
        return this.geometricShape.strokeMiterLimitProperty();
    }

    public final ObjectProperty<Paint> strokeProperty() {
        return this.geometricShape.strokeProperty();
    }

    public final ObjectProperty<StrokeType> strokeTypeProperty() {
        return this.geometricShape.strokeTypeProperty();
    }

    public final DoubleProperty strokeWidthProperty() {
        return this.geometricShape.strokeWidthProperty();
    }

    private void updateVisuals() {
        if (this.clickableAreaShape != null) {
            this.updateVisuals(this.geometricShape, this.clickableAreaShape);
        } else {
            this.updateVisuals(this.geometricShape);
        }
    }

    private void updateVisuals(Path ... paths) {
        Object[] pathElements = this.getPathElements();
        Path[] pathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            Path p = pathArray[n2];
            p.getElements().setAll(pathElements);
            ++n2;
        }
    }
}

