/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.adapt;

import com.google.common.reflect.TypeToken;
import java.util.Map;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.collections.ObservableMap;
import org.eclipse.gef4.common.adapt.AdaptableSupport;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.adapt.inject.InjectAdapters;

public class AdapterStore
implements IAdaptable {
    private AdaptableSupport<AdapterStore> ads = new AdaptableSupport<AdapterStore>(this);

    public AdapterStore() {
    }

    public <T> AdapterStore(T adapter) {
        this.setAdapter(adapter, "default");
    }

    public <T> AdapterStore(TypeToken<T> adapterType, T adapter) {
        this.setAdapter(adapterType, adapter, "default");
    }

    public <T> AdapterStore(TypeToken<T> adapterType, T adapter, String role) {
        this.setAdapter(adapterType, adapter, role);
    }

    @Override
    public <T> T getAdapter(AdapterKey<T> key) {
        return this.ads.getAdapter(key);
    }

    @Override
    public <T> T getAdapter(Class<T> key) {
        return this.ads.getAdapter(key);
    }

    @Override
    public <T> T getAdapter(TypeToken<T> key) {
        return this.ads.getAdapter(key);
    }

    @Override
    public <T> Map<AdapterKey<? extends T>, T> getAdapters(Class<? super T> key) {
        return this.ads.getAdapters(key);
    }

    @Override
    public <T> Map<AdapterKey<? extends T>, T> getAdapters(TypeToken<? super T> key) {
        return this.ads.getAdapters(key);
    }

    @Override
    public <T> void unsetAdapter(T adapter) {
        this.ads.unsetAdapter(adapter);
    }

    @Override
    public <T> void setAdapter(T adapter) {
        this.ads.setAdapter(adapter);
    }

    @Override
    public <T> void setAdapter(TypeToken<T> adapterType, T adapter) {
        this.ads.setAdapter(adapterType, adapter);
    }

    @Override
    public <T> void setAdapter(T adapter, String role) {
        this.ads.setAdapter(adapter, role);
    }

    @Override
    @InjectAdapters
    public <T> void setAdapter(TypeToken<T> adapterType, T adapter, String role) {
        this.ads.setAdapter(adapterType, adapter, role);
    }

    public void clear() {
        for (Object adapter : this.ads.getAdapters().values()) {
            this.ads.unsetAdapter(adapter);
        }
    }

    @Override
    public ReadOnlyMapProperty<AdapterKey<?>, Object> adaptersProperty() {
        return this.ads.adaptersProperty();
    }

    @Override
    public ObservableMap<AdapterKey<?>, Object> getAdapters() {
        return this.ads.getAdapters();
    }
}

