/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.adapt.inject;

import com.google.common.reflect.TypeToken;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.multibindings.MapBinderBinding;
import com.google.inject.multibindings.MultibinderBinding;
import com.google.inject.multibindings.MultibindingsTargetVisitor;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.adapt.inject.AdapterMap;

public class AdapterInjector
implements MembersInjector<IAdaptable> {
    private final List<Object> deferredInstances = new ArrayList<Object>();
    private Injector injector;
    private final Method method;

    public AdapterInjector(Method method) {
        this.method = method;
    }

    protected SortedMap<Key<?>, Binding<?>> getApplicableAdapterMapBindings(Class<?> adaptableType) {
        Map allBindings = this.injector.getAllBindings();
        TreeMap applicableBindings = new TreeMap(new Comparator<Key<?>>(){

            @Override
            public int compare(Key<?> o1, Key<?> o2) {
                if (!AdapterMap.class.equals((Object)o1.getAnnotationType()) || !AdapterMap.class.equals((Object)o2.getAnnotationType())) {
                    throw new IllegalArgumentException("Can only compare keys with AdapterMap annotations");
                }
                AdapterMap a1 = (AdapterMap)o1.getAnnotation();
                AdapterMap a2 = (AdapterMap)o2.getAnnotation();
                if (a1.adaptableType().equals(a2.adaptableType())) {
                    return 0;
                }
                if (a1.adaptableType().isAssignableFrom(a2.adaptableType())) {
                    return -1;
                }
                return 1;
            }
        });
        for (Key key : allBindings.keySet()) {
            AdapterMap keyAnnotation;
            if (key.getAnnotationType() == null || !AdapterMap.class.equals((Object)key.getAnnotationType()) || !(keyAnnotation = (AdapterMap)key.getAnnotation()).adaptableType().isAssignableFrom(adaptableType)) continue;
            applicableBindings.put(key, (Binding)allBindings.get(key));
        }
        return applicableBindings;
    }

    protected void injectAdapters(Object adaptable) {
        ArrayList<String> issues = new ArrayList<String>();
        this.injectAdapters(adaptable, issues);
        for (String issue : issues) {
            System.err.println(issue);
        }
    }

    protected void injectAdapters(Object adaptable, List<String> issues) {
        SortedMap<Key<?>, Binding<?>> polymorphicBindings = this.getApplicableAdapterMapBindings(adaptable.getClass());
        for (Map.Entry<Key<?>, Binding<?>> entry : polymorphicBindings.entrySet()) {
            try {
                Map adapterMap = (Map)entry.getValue().acceptTargetVisitor((BindingTargetVisitor)new AdapterMapInferrer(issues));
                if (adapterMap == null || adapterMap.isEmpty()) continue;
                for (AdapterKey key : adapterMap.keySet()) {
                    Object adapter = adapterMap.get(key);
                    TypeToken adapterType = key.getKey();
                    String role = key.getRole();
                    this.method.invoke(adaptable, adapterType, adapter, role);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void injectMembers(IAdaptable instance) {
        if (this.injector == null) {
            this.deferredInstances.add(instance);
        } else {
            this.injectAdapters(instance);
        }
    }

    @Inject
    public void setInjector(Injector injector) {
        this.injector = injector;
        for (Object instance : this.deferredInstances) {
            this.injectAdapters(instance);
        }
        this.deferredInstances.clear();
    }

    private class AdapterMapInferrer
    implements MultibindingsTargetVisitor<Object, Map<AdapterKey<?>, Object>> {
        private List<String> issues;

        public AdapterMapInferrer(List<String> issues) {
            this.issues = issues;
        }

        public Map<AdapterKey<?>, Object> visit(ConstructorBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(ConvertedConstantBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(ExposedBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(InstanceBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(LinkedKeyBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(MapBinderBinding<? extends Object> mapbinding) {
            HashMap adapters = new HashMap();
            for (Map.Entry entry : mapbinding.getEntries()) {
                AdapterKey key = (AdapterKey)entry.getKey();
                Object adapter = ((Binding)entry.getValue()).getProvider().get();
                TypeToken adapterType = (TypeToken)((Binding)entry.getValue()).acceptTargetVisitor((BindingTargetVisitor)new AdapterTypeInferrer());
                if (adapterType != null) {
                    if (key.getKey() != null) {
                        if (key.getKey().equals((Object)adapterType)) {
                            this.issues.add("*** WARNING: The actual type of adapter " + adapter + " could already be inferred as " + adapterType + " from the binding at " + ((Binding)entry.getValue()).getSource() + ".\n" + "             The redundant type key " + key.getKey() + " may be omitted in the adapter key of the binding, using AdapterKey.defaultRole() or AdapterKey.role(String) instead.");
                        } else if (adapterType.getType() instanceof ParameterizedType) {
                            this.issues.add("*** WARNING: The given key type " + key.getKey() + " does not seem to match the actual (parameterized) type of adapter " + adapter + " which was inferred as " + adapterType + " from the binding at " + ((Binding)entry.getValue()).getSource() + ".\n" + "             The adapter will only be retrievable via key types assignable to " + key.getKey() + ". You should probably adjust your binding.");
                        } else if (!adapterType.getRawType().equals(key.getKey().getRawType())) {
                            this.issues.add("*** WARNING: The given key (raw) type " + key.getKey().getRawType().getName() + " does not seem to match the actual type of adapter " + adapter + " which was inferred as " + adapterType + " from the binding at " + ((Binding)entry.getValue()).getSource() + ".\n" + "             The adapter will only be retrievable via key types assignable to " + key.getKey() + ". You should probably adjust your binding.");
                        }
                    }
                } else {
                    adapterType = TypeToken.of(adapter.getClass());
                }
                if (key.getKey() != null) {
                    adapterType = key.getKey();
                }
                adapters.put(AdapterKey.get(adapterType, key.getRole()), adapter);
            }
            return adapters;
        }

        public Map<AdapterKey<?>, Object> visit(MultibinderBinding<? extends Object> multibinding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(ProviderBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(ProviderInstanceBinding<? extends Object> binding) {
            HashMap adapters = new HashMap();
            Map adaptersByKeys = (Map)binding.getProviderInstance().get();
            for (AdapterKey adapterKey : adaptersByKeys.keySet()) {
                for (Object adapter : (Set)adaptersByKeys.get(adapterKey)) {
                    TypeToken keyType = adapterKey.getKey();
                    TypeToken adapterType = keyType != null ? keyType : TypeToken.of(adapter.getClass());
                    adapters.put(AdapterKey.get(adapterType, adapterKey.getRole()), adapter);
                }
            }
            return adapters;
        }

        public Map<AdapterKey<?>, Object> visit(ProviderKeyBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(UntargettedBinding<? extends Object> binding) {
            return null;
        }
    }

    private class AdapterTypeInferrer
    implements BindingTargetVisitor<Object, TypeToken<?>> {
        private AdapterTypeInferrer() {
        }

        public TypeToken<?> visit(InstanceBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(ProviderInstanceBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(ProviderKeyBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(LinkedKeyBinding<? extends Object> binding) {
            Binding linkedKeyBinding = AdapterInjector.this.injector.getBinding(binding.getLinkedKey());
            return (TypeToken)linkedKeyBinding.acceptTargetVisitor((BindingTargetVisitor)this);
        }

        public TypeToken<?> visit(ExposedBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(UntargettedBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(ConstructorBinding<? extends Object> binding) {
            return TypeToken.of((Type)binding.getKey().getTypeLiteral().getType());
        }

        public TypeToken<?> visit(ConvertedConstantBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(ProviderBinding<? extends Object> binding) {
            return null;
        }
    }
}

