/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.beans.binding;

import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.WeakListener;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.eclipse.gef4.common.collections.MultisetChangeListener;
import org.eclipse.gef4.common.collections.ObservableMultiset;
import org.eclipse.gef4.common.collections.ObservableSetMultimap;
import org.eclipse.gef4.common.collections.SetMultimapChangeListener;

public class BindingUtils {
    public static <E> void bindContent(Multiset<E> source, ObservableMultiset<? extends E> target) {
        if (source == null) {
            throw new NullPointerException("Cannot bind null value.");
        }
        if (target == null) {
            throw new NullPointerException("Cannot bind to null value.");
        }
        if (source == target) {
            throw new IllegalArgumentException("Cannot bind source to itself.");
        }
        if (source instanceof ObservableMultiset) {
            ((ObservableMultiset)source).replaceAll(target);
        } else {
            source.clear();
            source.addAll(target);
        }
        UnidirectionalMultisetContentBinding<E> contentBinding = new UnidirectionalMultisetContentBinding<E>(source);
        target.removeListener(contentBinding);
        target.addListener(contentBinding);
    }

    public static <K, V> void bindContent(SetMultimap<K, V> source, ObservableSetMultimap<? extends K, ? extends V> target) {
        if (source == null) {
            throw new NullPointerException("Cannot bind null value.");
        }
        if (target == null) {
            throw new NullPointerException("Cannot bind to null value.");
        }
        if (source == target) {
            throw new IllegalArgumentException("Cannot bind source to itself.");
        }
        if (source instanceof ObservableSetMultimap) {
            ((ObservableSetMultimap)source).replaceAll(target);
        } else {
            source.clear();
            source.putAll(target);
        }
        UnidirectionalSetMultimapContentBinding<K, V> contentBinding = new UnidirectionalSetMultimapContentBinding<K, V>(source);
        target.removeListener(contentBinding);
        target.addListener(contentBinding);
    }

    public static <E> void bindContentBidirectional(ObservableMultiset<E> source, ObservableMultiset<E> target) {
        if (source == null) {
            throw new NullPointerException("Cannot bind null value.");
        }
        if (target == null) {
            throw new NullPointerException("Cannot bind to null value.");
        }
        if (source == target) {
            throw new IllegalArgumentException("Cannot bind source to itself.");
        }
        source.replaceAll(target);
        BidirectionalMultisetContentBinding<E> contentBinding = new BidirectionalMultisetContentBinding<E>(source, target);
        source.removeListener(contentBinding);
        target.removeListener(contentBinding);
        source.addListener(contentBinding);
        target.addListener(contentBinding);
    }

    public static <K, V> void bindContentBidirectional(ObservableSetMultimap<K, V> source, ObservableSetMultimap<K, V> target) {
        if (source == null) {
            throw new NullPointerException("Cannot bind null value.");
        }
        if (target == null) {
            throw new NullPointerException("Cannot bind to null value.");
        }
        if (source == target) {
            throw new IllegalArgumentException("Cannot bind source to itself.");
        }
        source.replaceAll(target);
        BidirectionalSetMultimapContentBinding<K, V> contentBinding = new BidirectionalSetMultimapContentBinding<K, V>(source, target);
        source.removeListener(contentBinding);
        target.removeListener(contentBinding);
        source.addListener(contentBinding);
        target.addListener(contentBinding);
    }

    public static <E> void unbindContent(Multiset<E> source, ObservableMultiset<? extends E> target) {
        if (source == null) {
            throw new NullPointerException("Cannot unbind null value.");
        }
        if (target == null) {
            throw new NullPointerException("Cannot unbind from null value.");
        }
        if (source == target) {
            throw new IllegalArgumentException("Cannot unbind source to itself.");
        }
        target.removeListener(new UnidirectionalMultisetContentBinding<E>(source));
    }

    public static <K, V> void unbindContent(SetMultimap<K, V> source, ObservableSetMultimap<? extends K, ? extends V> target) {
        if (source == null) {
            throw new NullPointerException("Cannot unbind null value.");
        }
        if (target == null) {
            throw new NullPointerException("Cannot unbind from null value.");
        }
        if (source == target) {
            throw new IllegalArgumentException("Cannot unbind source to itself.");
        }
        target.removeListener(new UnidirectionalSetMultimapContentBinding<K, V>(source));
    }

    public static <E> void unbindContentBidirectional(ObservableMultiset<E> multiset1, ObservableMultiset<E> multiset2) {
        if (multiset1 == null) {
            throw new NullPointerException("Cannot bind null value.");
        }
        if (multiset2 == null) {
            throw new NullPointerException("Cannot bind to null value.");
        }
        if (multiset1 == multiset2) {
            throw new IllegalArgumentException("Cannot bind source to itself.");
        }
        BidirectionalMultisetContentBinding<E> contentBinding = new BidirectionalMultisetContentBinding<E>(multiset1, multiset2);
        multiset1.removeListener(contentBinding);
        multiset2.removeListener(contentBinding);
    }

    public static <K, V> void unbindContentBidirectional(ObservableSetMultimap<K, V> source, ObservableSetMultimap<K, V> target) {
        if (source == null) {
            throw new NullPointerException("Cannot bind null value.");
        }
        if (target == null) {
            throw new NullPointerException("Cannot bind to null value.");
        }
        if (source == target) {
            throw new IllegalArgumentException("Cannot bind source to itself.");
        }
        BidirectionalSetMultimapContentBinding<K, V> contentBinding = new BidirectionalSetMultimapContentBinding<K, V>(source, target);
        source.removeListener(contentBinding);
        target.removeListener(contentBinding);
    }

    public static <K, V> ObjectBinding<Set<V>> valuesAt(final ObservableSetMultimap<K, V> setMultimap, final K key) {
        if (setMultimap == null) {
            throw new UnsupportedOperationException("setMultimap may not be null.");
        }
        return new ObjectBinding<Set<V>>(){
            {
                super.bind(new Observable[]{observableSetMultimap});
            }

            protected Set<V> computeValue() {
                return setMultimap.get(key);
            }

            public void dispose() {
                super.unbind(new Observable[]{setMultimap});
            }

            public ObservableList<?> getDependencies() {
                return FXCollections.singletonObservableList((Object)setMultimap);
            }
        };
    }

    public static <K, V> ObjectBinding<Set<V>> valuesAt(final ObservableSetMultimap<K, V> setMultimap, final ObservableValue<K> key) {
        if (setMultimap == null) {
            throw new UnsupportedOperationException("setMultimap may not be null.");
        }
        if (key == null) {
            throw new UnsupportedOperationException("key may not be null");
        }
        return new ObjectBinding<Set<V>>(){
            {
                super.bind(new Observable[]{observableSetMultimap});
            }

            protected Set<V> computeValue() {
                return setMultimap.get(key.getValue());
            }

            public void dispose() {
                super.unbind(new Observable[]{setMultimap});
            }

            public ObservableList<?> getDependencies() {
                return FXCollections.unmodifiableObservableList((ObservableList)FXCollections.observableArrayList((Object[])new Observable[]{setMultimap, key}));
            }
        };
    }

    private static class BidirectionalMultisetContentBinding<E>
    implements MultisetChangeListener<E>,
    WeakListener {
        private final WeakReference<ObservableMultiset<E>> multiset1Ref;
        private final WeakReference<ObservableMultiset<E>> multiset2Ref;
        private boolean updating = false;

        public BidirectionalMultisetContentBinding(ObservableMultiset<E> multiset1, ObservableMultiset<E> multiset2) {
            this.multiset1Ref = new WeakReference<ObservableMultiset<E>>(multiset1);
            this.multiset2Ref = new WeakReference<ObservableMultiset<E>>(multiset2);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof BidirectionalMultisetContentBinding)) {
                return false;
            }
            try {
                BidirectionalMultisetContentBinding otherBinding = (BidirectionalMultisetContentBinding)other;
                ObservableMultiset multiset1 = (ObservableMultiset)this.multiset1Ref.get();
                ObservableMultiset multiset2 = (ObservableMultiset)this.multiset2Ref.get();
                ObservableMultiset otherMultiset1 = (ObservableMultiset)otherBinding.multiset1Ref.get();
                ObservableMultiset otherMultiset2 = (ObservableMultiset)otherBinding.multiset2Ref.get();
                return multiset1 == otherMultiset1 && multiset2 == otherMultiset2 || multiset1 == otherMultiset2 && multiset2 == otherMultiset1;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public void onChanged(MultisetChangeListener.Change<? extends E> change) {
            if (!this.updating) {
                ObservableMultiset multiset1 = (ObservableMultiset)this.multiset1Ref.get();
                ObservableMultiset multiset2 = (ObservableMultiset)this.multiset2Ref.get();
                if (multiset1 == null || multiset2 == null) {
                    if (multiset1 != null) {
                        multiset1.removeListener(this);
                    }
                    if (multiset2 != null) {
                        multiset2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        ObservableMultiset destination = multiset1 == change.getMultiset() ? multiset2 : multiset1;
                        while (change.next()) {
                            destination.setCount(change.getElement(), destination.count(change.getElement()), destination.count(change.getElement()) + change.getAddCount() - change.getRemoveCount());
                        }
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }

        public boolean wasGarbageCollected() {
            return this.multiset1Ref.get() == null || this.multiset2Ref.get() == null;
        }
    }

    private static class BidirectionalSetMultimapContentBinding<K, V>
    implements SetMultimapChangeListener<K, V>,
    WeakListener {
        private final WeakReference<ObservableSetMultimap<K, V>> setMultimap1Ref;
        private final WeakReference<ObservableSetMultimap<K, V>> setMultimap2Ref;
        private boolean updating = false;

        public BidirectionalSetMultimapContentBinding(ObservableSetMultimap<K, V> setMultimap1, ObservableSetMultimap<K, V> setMultimap2) {
            this.setMultimap1Ref = new WeakReference<ObservableSetMultimap<K, V>>(setMultimap1);
            this.setMultimap2Ref = new WeakReference<ObservableSetMultimap<K, V>>(setMultimap2);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof BidirectionalSetMultimapContentBinding)) {
                return false;
            }
            try {
                BidirectionalSetMultimapContentBinding otherBinding = (BidirectionalSetMultimapContentBinding)other;
                ObservableSetMultimap setMultimap1 = (ObservableSetMultimap)this.setMultimap1Ref.get();
                ObservableSetMultimap setMultimap2 = (ObservableSetMultimap)this.setMultimap2Ref.get();
                ObservableSetMultimap otherSetMultimap1 = (ObservableSetMultimap)otherBinding.setMultimap1Ref.get();
                ObservableSetMultimap otherSetMultimap2 = (ObservableSetMultimap)otherBinding.setMultimap2Ref.get();
                return setMultimap1 == otherSetMultimap1 && setMultimap2 == otherSetMultimap2 || setMultimap1 == otherSetMultimap2 && setMultimap2 == otherSetMultimap1;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public void onChanged(SetMultimapChangeListener.Change<? extends K, ? extends V> change) {
            if (!this.updating) {
                ObservableSetMultimap setMultimap1 = (ObservableSetMultimap)this.setMultimap1Ref.get();
                ObservableSetMultimap setMultimap2 = (ObservableSetMultimap)this.setMultimap2Ref.get();
                if (setMultimap1 == null || setMultimap2 == null) {
                    if (setMultimap1 != null) {
                        setMultimap1.removeListener(this);
                    }
                    if (setMultimap2 != null) {
                        setMultimap2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        ObservableSetMultimap source = setMultimap1 == change.getSetMultimap() ? setMultimap1 : setMultimap2;
                        ObservableSetMultimap destination = setMultimap1 == change.getSetMultimap() ? setMultimap2 : setMultimap1;
                        while (change.next()) {
                            destination.replaceValues(change.getKey(), new HashSet(source.get(change.getKey())));
                        }
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }

        public boolean wasGarbageCollected() {
            return this.setMultimap1Ref.get() == null || this.setMultimap2Ref.get() == null;
        }
    }

    private static class UnidirectionalMultisetContentBinding<E>
    implements MultisetChangeListener<E>,
    WeakListener {
        private final WeakReference<Multiset<E>> multisetRef;

        public UnidirectionalMultisetContentBinding(Multiset<E> multiset) {
            this.multisetRef = new WeakReference<Multiset<E>>(multiset);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof UnidirectionalMultisetContentBinding)) {
                return false;
            }
            try {
                UnidirectionalMultisetContentBinding otherBinding = (UnidirectionalMultisetContentBinding)other;
                Multiset multiset = (Multiset)this.multisetRef.get();
                Multiset otherMultiset = (Multiset)otherBinding.multisetRef.get();
                return multiset == otherMultiset;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public void onChanged(MultisetChangeListener.Change<? extends E> change) {
            while (change.next()) {
                Multiset destination = (Multiset)this.multisetRef.get();
                if (destination == null) {
                    change.getMultiset().removeListener(this);
                    continue;
                }
                destination.setCount(change.getElement(), destination.count(change.getElement()), destination.count(change.getElement()) + change.getAddCount() - change.getRemoveCount());
            }
        }

        public boolean wasGarbageCollected() {
            return this.multisetRef.get() == null;
        }
    }

    private static class UnidirectionalSetMultimapContentBinding<K, V>
    implements SetMultimapChangeListener<K, V>,
    WeakListener {
        private final WeakReference<SetMultimap<K, V>> setMultimapRef;

        public UnidirectionalSetMultimapContentBinding(SetMultimap<K, V> setMultimap) {
            this.setMultimapRef = new WeakReference<SetMultimap<K, V>>(setMultimap);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof UnidirectionalSetMultimapContentBinding)) {
                return false;
            }
            try {
                UnidirectionalSetMultimapContentBinding otherBinding = (UnidirectionalSetMultimapContentBinding)other;
                SetMultimap setMultimap = (SetMultimap)this.setMultimapRef.get();
                SetMultimap otherSetMultimap = (SetMultimap)otherBinding.setMultimapRef.get();
                return setMultimap == otherSetMultimap;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public void onChanged(SetMultimapChangeListener.Change<? extends K, ? extends V> change) {
            ObservableSetMultimap<? extends K, ? extends V> source = change.getSetMultimap();
            while (change.next()) {
                SetMultimap destination = (SetMultimap)this.setMultimapRef.get();
                if (destination == null) {
                    change.getSetMultimap().removeListener(this);
                    continue;
                }
                destination.replaceValues(change.getKey(), new HashSet(source.get(change.getKey())));
            }
        }

        public boolean wasGarbageCollected() {
            return this.setMultimapRef.get() == null;
        }
    }
}

