/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.OrthogonalRouter;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.behaviors.SelectionBehavior;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.CursorSupport;
import org.eclipse.gef4.mvc.fx.policies.FXBendConnectionPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnDragPolicy;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;

public class FXBendOnSegmentDragPolicy
extends AbstractFXInteractionPolicy
implements IFXOnDragPolicy {
    private CursorSupport cursorSupport = new CursorSupport(this);
    private Point initialMouseInScene;
    private boolean isInvalid = false;

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.isInvalid) {
            return;
        }
        Point currentMouseInScene = new Point(e.getSceneX(), e.getSceneY());
        this.getBendPolicy().move(this.initialMouseInScene, currentMouseInScene);
        this.updateHandles();
    }

    @Override
    public void dragAborted() {
        if (this.isInvalid) {
            return;
        }
        this.rollback((AbstractTransactionPolicy)this.getBendPolicy());
        this.restoreRefreshVisuals(this.getHost());
        this.updateHandles();
    }

    protected FXBendConnectionPolicy getBendPolicy() {
        return (FXBendConnectionPolicy)((Object)this.getHost().getAdapter(FXBendConnectionPolicy.class));
    }

    protected CursorSupport getCursorSupport() {
        return this.cursorSupport;
    }

    public IVisualPart<Node, Connection> getHost() {
        return super.getHost();
    }

    @Override
    public void hideIndicationCursor() {
        this.cursorSupport.restoreCursor();
    }

    @Override
    public void press(MouseEvent e) {
        this.isInvalid = false;
        if (!(((Connection)this.getHost().getVisual()).getRouter() instanceof OrthogonalRouter)) {
            this.isInvalid = true;
        } else {
            IVisualPart<Node, Connection> host = this.getHost();
            ObservableList selection = ((SelectionModel)host.getRoot().getViewer().getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).getSelectionUnmodifiable();
            boolean bl = this.isInvalid = selection.size() > 1 && selection.contains(host);
        }
        if (this.isInvalid) {
            return;
        }
        this.initialMouseInScene = new Point(e.getSceneX(), e.getSceneY());
        this.storeAndDisableRefreshVisuals(this.getHost());
        FXBendConnectionPolicy bendPolicy = this.getBendPolicy();
        this.init((AbstractTransactionPolicy)bendPolicy);
        Connection connection = bendPolicy.getConnection();
        ICurve curve = (ICurve)connection.getCurveNode().getGeometry();
        ICurve curveInScene = (ICurve)NodeUtils.localToScene((Node)connection.getCurveNode(), (IGeometry)curve);
        BezierCurve[] beziersInScene = curveInScene.toBezier();
        double minDistance = -1.0;
        int segmentIndex = -1;
        int i = 0;
        while (i < beziersInScene.length) {
            BezierCurve bc = beziersInScene[i];
            Line line = bc.toLine();
            Point projection = line.getProjection(this.initialMouseInScene);
            double distance = projection.getDistance(this.initialMouseInScene);
            if (minDistance < 0.0 || distance < minDistance) {
                minDistance = distance;
                segmentIndex = i;
            }
            ++i;
        }
        if (segmentIndex < 0) {
            throw new IllegalStateException("Cannot identify pressed segment.");
        }
        bendPolicy.selectSegment(segmentIndex);
        bendPolicy.move(this.initialMouseInScene, this.initialMouseInScene);
        this.updateHandles();
    }

    @Override
    public void release(MouseEvent e, Dimension delta) {
        if (this.isInvalid) {
            return;
        }
        this.commit((AbstractTransactionPolicy)this.getBendPolicy());
        this.restoreRefreshVisuals(this.getHost());
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    protected void updateHandles() {
        ((SelectionBehavior)this.getHost().getAdapter(SelectionBehavior.class)).updateHandles(null, null);
    }
}

