/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnClickPolicy;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.operations.ChangeFocusOperation;
import org.eclipse.gef4.mvc.operations.DeselectOperation;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.SelectOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXFocusAndSelectOnClickPolicy
extends AbstractFXInteractionPolicy
implements IFXOnClickPolicy {
    @Override
    public void click(MouseEvent e) {
        if (e.getClickCount() > 1) {
            return;
        }
        IVisualPart host = this.getHost();
        IViewer viewer = host.getRoot().getViewer();
        SelectionModel selectionModel = (SelectionModel)viewer.getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){});
        ObservableList oldSelection = selectionModel.getSelectionUnmodifiable();
        if (host instanceof IContentPart) {
            IContentPart contentPart = (IContentPart)host;
            if (this.isRegistered(e.getTarget()) && !this.isRegisteredForHost(e.getTarget())) {
                return;
            }
            boolean append = e.isControlDown();
            List<IContentPart> singletonHostList = Collections.singletonList(contentPart);
            boolean wasDeselected = false;
            DeselectOperation selectionChangeOperation = null;
            if (selectionModel.isSelected(contentPart)) {
                if (append) {
                    selectionChangeOperation = new DeselectOperation(viewer, singletonHostList);
                    wasDeselected = true;
                }
            } else if (contentPart.isSelectable()) {
                if (append) {
                    selectionChangeOperation = new SelectOperation(viewer, singletonHostList);
                } else {
                    ReverseUndoCompositeOperation revOp = new ReverseUndoCompositeOperation("SetSelection()");
                    revOp.add((IUndoableOperation)new DeselectOperation(viewer, (List)oldSelection));
                    revOp.add((IUndoableOperation)new SelectOperation(viewer, singletonHostList));
                    selectionChangeOperation = revOp;
                }
            }
            if (selectionChangeOperation != null) {
                try {
                    viewer.getDomain().execute((IUndoableOperation)selectionChangeOperation);
                }
                catch (ExecutionException e1) {
                    throw new IllegalStateException(e1);
                }
            }
            ChangeFocusOperation changeFocusOperation = null;
            ObservableList selection = selectionModel.getSelectionUnmodifiable();
            if (wasDeselected && selection.isEmpty()) {
                changeFocusOperation = new ChangeFocusOperation(viewer, null);
            } else {
                IContentPart primarySelection = (IContentPart)selection.get(0);
                if (primarySelection.isFocusable()) {
                    changeFocusOperation = new ChangeFocusOperation(viewer, primarySelection);
                }
            }
            if (changeFocusOperation != null) {
                try {
                    viewer.getDomain().execute((IUndoableOperation)changeFocusOperation);
                }
                catch (ExecutionException e1) {
                    throw new IllegalStateException(e1);
                }
            }
        } else if (host instanceof IRootPart && (!this.isRegistered(e.getTarget()) || this.isRegisteredForHost(e.getTarget()))) {
            try {
                viewer.getDomain().execute((IUndoableOperation)new ChangeFocusOperation(viewer, null));
                viewer.getDomain().execute((IUndoableOperation)new DeselectOperation(viewer, (List)selectionModel.getSelectionUnmodifiable()));
            }
            catch (ExecutionException e1) {
                throw new IllegalStateException(e1);
            }
        }
    }
}

