/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.mvc.fx.operations.FXRevealOperation;
import org.eclipse.gef4.mvc.models.FocusModel;
import org.eclipse.gef4.mvc.operations.AbstractCompositeOperation;
import org.eclipse.gef4.mvc.operations.ChangeFocusOperation;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXFocusTraversalPolicy
extends AbstractTransactionPolicy<Node> {
    private IViewer<Node> viewer;
    private FocusModel<Node> focusModel;

    protected ITransactionalOperation createOperation() {
        ForwardUndoCompositeOperation focusAndRevealOperation = new ForwardUndoCompositeOperation("Resize and Reveal");
        focusAndRevealOperation.add((IUndoableOperation)new ChangeFocusOperation(this.viewer, null));
        focusAndRevealOperation.add((IUndoableOperation)new FXRevealOperation((IVisualPart<Node, ? extends Node>)this.getHost()));
        return focusAndRevealOperation;
    }

    protected IContentPart<Node, ? extends Node> findInnerMostContentPart(IContentPart<Node, ? extends Node> part) {
        ObservableList children = part.getChildrenUnmodifiable();
        block0: while (!children.isEmpty()) {
            int i = children.size() - 1;
            while (i >= 0) {
                IVisualPart child = (IVisualPart)children.get(i);
                if (child instanceof IContentPart) {
                    part = (IContentPart)child;
                    children = part.getChildrenUnmodifiable();
                    continue block0;
                }
                --i;
            }
        }
        return part;
    }

    protected IContentPart<Node, ? extends Node> findNextContentPart(IContentPart<Node, ? extends Node> current) {
        ObservableList children = current.getChildrenUnmodifiable();
        if (!children.isEmpty()) {
            for (IVisualPart child : children) {
                if (!(child instanceof IContentPart)) continue;
                return (IContentPart)child;
            }
        }
        IVisualPart parent = current.getParent();
        while (parent instanceof IContentPart || parent instanceof IRootPart) {
            children = parent instanceof IContentPart ? parent.getChildrenUnmodifiable() : ((IRootPart)parent).getContentPartChildren();
            int index = children.indexOf(current) + 1;
            while (index < children.size()) {
                IVisualPart part = (IVisualPart)children.get(index);
                if (part instanceof IContentPart) {
                    return (IContentPart)part;
                }
                ++index;
            }
            if (parent instanceof IContentPart) {
                current = (IContentPart)parent;
                parent = current.getParent();
                continue;
            }
            return null;
        }
        return null;
    }

    protected IContentPart<Node, ? extends Node> findPreviousContentPart(IContentPart<Node, ? extends Node> current) {
        IVisualPart parent = current.getParent();
        if (parent instanceof IContentPart || parent instanceof IRootPart) {
            Object children = parent instanceof IContentPart ? parent.getChildrenUnmodifiable() : ((IRootPart)parent).getContentPartChildren();
            int index = children.indexOf(current) - 1;
            while (index >= 0) {
                IVisualPart part = (IVisualPart)children.get(index);
                if (part instanceof IContentPart) {
                    return this.findInnerMostContentPart((IContentPart<Node, ? extends Node>)((IContentPart)part));
                }
                --index;
            }
            if (parent instanceof IContentPart) {
                return (IContentPart)parent;
            }
        }
        return null;
    }

    public void focusNext() {
        this.traverse(false);
    }

    public void focusPrevious() {
        this.traverse(true);
    }

    protected ChangeFocusOperation<Node> getChangeFocusOperation() {
        return (ChangeFocusOperation)((AbstractCompositeOperation)this.getOperation()).getOperations().get(0);
    }

    protected FXRevealOperation getRevealOperation() {
        return (FXRevealOperation)((Object)((AbstractCompositeOperation)this.getOperation()).getOperations().get(1));
    }

    public void init() {
        this.viewer = this.getHost().getRoot().getViewer();
        this.focusModel = (FocusModel)this.viewer.getAdapter((TypeToken)new TypeToken<FocusModel<Node>>(){});
        super.init();
    }

    protected void traverse(boolean backwards) {
        List children;
        IContentPart<Node, ? extends Node> current = this.focusModel.getFocus();
        IContentPart<Node, ? extends Node> next = null;
        if (current == null && (children = this.viewer.getRootPart().getContentPartChildren()) != null && !children.isEmpty()) {
            next = backwards ? this.findInnerMostContentPart((IContentPart<Node, ? extends Node>)((IContentPart)children.get(children.size() - 1))) : (IContentPart<Node, ? extends Node>)children.get(0);
        }
        if (current != null || next != null && !next.isFocusable()) {
            if (next == null) {
                next = current;
            }
            if (backwards) {
                while ((next = this.findPreviousContentPart(next)) != null && !next.isFocusable()) {
                }
            } else {
                while ((next = this.findNextContentPart(next)) != null && !next.isFocusable()) {
                }
            }
        }
        if (next == null || next.isFocusable()) {
            this.getChangeFocusOperation().setNewFocused((IContentPart)next);
            this.getRevealOperation().setPart((IVisualPart<Node, ? extends Node>)next);
        }
    }
}

