/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.fx.anchors.StaticAnchor;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.operations.FXBendConnectionOperation;
import org.eclipse.gef4.mvc.fx.operations.FXRevealOperation;
import org.eclipse.gef4.mvc.fx.policies.FXBendConnectionPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXResizePolicy;
import org.eclipse.gef4.mvc.operations.AbstractCompositeOperation;
import org.eclipse.gef4.mvc.operations.BendContentOperation;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IBendableContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXResizeConnectionPolicy
extends FXResizePolicy {
    private List<IBendableContentPart.BendPoint> initialBendPoints;
    private Point[] initialPositions;
    private Double[] relX = null;
    private Double[] relY = null;

    public ITransactionalOperation commit() {
        ITransactionalOperation commit = super.commit();
        this.initialPositions = null;
        this.relX = null;
        this.relY = null;
        this.initialBendPoints = null;
        return commit;
    }

    @Override
    protected ITransactionalOperation createOperation() {
        ForwardUndoCompositeOperation resizeAndRevealOperation = new ForwardUndoCompositeOperation("Bend and Reveal");
        resizeAndRevealOperation.add((IUndoableOperation)new FXBendConnectionOperation((Connection)this.getHost().getVisual()));
        resizeAndRevealOperation.add((IUndoableOperation)new FXRevealOperation(this.getHost()));
        return resizeAndRevealOperation;
    }

    protected ITransactionalOperation createResizeContentOperation() {
        return new BendContentOperation((IBendableContentPart)this.getHost(), this.initialBendPoints, FXBendConnectionPolicy.getCurrentBendPoints(this.getHost()));
    }

    protected FXBendConnectionOperation getBendConnectionOperation() {
        return (FXBendConnectionOperation)((Object)((AbstractCompositeOperation)this.getOperation()).getOperations().get(0));
    }

    public IVisualPart<Node, Connection> getHost() {
        return super.getHost();
    }

    protected List<Integer> getIndicesOfMovableAnchors() {
        FXBendConnectionOperation op = this.getBendConnectionOperation();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (!op.getConnection().isStartConnected()) {
            indices.add(0);
        }
        int i = 0;
        while (i < op.getNewAnchors().size() - 2) {
            if (!op.getConnection().isControlConnected(i)) {
                indices.add(i + 1);
            }
            ++i;
        }
        if (!op.getConnection().isEndConnected()) {
            indices.add(op.getNewAnchors().size() - 1);
        }
        return indices;
    }

    public void init() {
        super.init();
        Connection connection = (Connection)this.getHost().getVisual();
        this.initialPositions = connection.getPoints().toArray(new Point[0]);
        Bounds layoutBounds = connection.getLayoutBounds();
        this.relX = new Double[this.initialPositions.length];
        this.relY = new Double[this.initialPositions.length];
        for (int i : this.getIndicesOfMovableAnchors()) {
            this.relX[i] = (this.initialPositions[i].x - layoutBounds.getMinX()) / layoutBounds.getWidth();
            this.relY[i] = (this.initialPositions[i].y - layoutBounds.getMinY()) / layoutBounds.getHeight();
        }
    }

    protected boolean isContentResizable() {
        return this.getHost() instanceof IBendableContentPart;
    }

    @Override
    protected void updateResizeOperation(double dw, double dh) {
        FXBendConnectionOperation bendConnectionOperation = this.getBendConnectionOperation();
        for (int i : this.getIndicesOfMovableAnchors()) {
            Point p = this.initialPositions[i];
            Point newPosition = new Point(p.x + this.relX[i] * dw, p.y + this.relY[i] * dh);
            bendConnectionOperation.getNewAnchors().set(i, (IAnchor)new StaticAnchor((Node)bendConnectionOperation.getConnection(), newPosition));
        }
    }
}

