/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.fx.anchors.StaticAnchor;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.operations.FXBendConnectionOperation;
import org.eclipse.gef4.mvc.fx.policies.FXBendConnectionPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.models.GridModel;
import org.eclipse.gef4.mvc.operations.BendContentOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IBendableContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXTransformConnectionPolicy
extends FXTransformPolicy {
    private List<IBendableContentPart.BendPoint> initialBendPoints;
    private Point[] initialPositions;

    public ITransactionalOperation commit() {
        ITransactionalOperation commit = super.commit();
        this.initialPositions = null;
        this.initialBendPoints = null;
        return commit;
    }

    @Override
    protected ITransactionalOperation createOperation() {
        return new FXBendConnectionOperation((Connection)this.getHost().getVisual());
    }

    protected ITransactionalOperation createTransformContentOperation() {
        return new BendContentOperation((IBendableContentPart)this.getHost(), this.initialBendPoints, FXBendConnectionPolicy.getCurrentBendPoints(this.getHost()));
    }

    protected FXBendConnectionOperation getBendConnectionOperation() {
        return (FXBendConnectionOperation)this.getOperation();
    }

    public IVisualPart<Node, Connection> getHost() {
        return super.getHost();
    }

    protected List<Integer> getIndicesOfUnconnectedAnchors() {
        FXBendConnectionOperation op = this.getBendConnectionOperation();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (!op.getConnection().isStartConnected()) {
            indices.add(0);
        }
        int i = 0;
        while (i < op.getNewAnchors().size() - 2) {
            if (!op.getConnection().isControlConnected(i)) {
                indices.add(i + 1);
            }
            ++i;
        }
        if (!op.getConnection().isEndConnected()) {
            indices.add(op.getNewAnchors().size() - 1);
        }
        return indices;
    }

    public void init() {
        super.init();
        AffineTransform inverse = null;
        try {
            inverse = this.getInitialTransform().invert();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        this.initialPositions = this.getBendConnectionOperation().getConnection().getPoints().toArray(new Point[0]);
        for (int i : this.getIndicesOfUnconnectedAnchors()) {
            this.initialPositions[i] = inverse.getTransformed(this.initialPositions[i]);
        }
        this.initialBendPoints = FXBendConnectionPolicy.getCurrentBendPoints(this.getHost());
    }

    protected boolean isContentTransformable() {
        return this.getHost() instanceof IBendableContentPart;
    }

    @Override
    protected void updateTransformOperation(AffineTransform newTransform) {
        for (int i : this.getIndicesOfUnconnectedAnchors()) {
            Point p = this.initialPositions[i];
            Point pTx = newTransform.getTransformed(p);
            double nx = pTx.x;
            double ny = pTx.y;
            Dimension snapToGridOffset = FXTransformConnectionPolicy.getSnapToGridOffset((GridModel)((GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class)), (double)nx, (double)ny, (double)0.5, (double)0.5);
            this.getBendConnectionOperation().getNewAnchors().set(i, (IAnchor)new StaticAnchor((Node)this.getHost().getVisual(), new Point(nx - snapToGridOffset.width, ny - snapToGridOffset.height)));
        }
    }
}

