/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.jface;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.collections.ListChangeListener;
import javafx.embed.swt.FXCanvas;
import javafx.embed.swt.SWTFXUtils;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import org.eclipse.gef4.common.activate.ActivatableSupport;
import org.eclipse.gef4.common.activate.IActivatable;
import org.eclipse.gef4.fx.swt.canvas.IFXCanvasFactory;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.mvc.fx.domain.FXDomain;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.ZestProperties;
import org.eclipse.gef4.zest.fx.jface.IGraphAttributesProvider;
import org.eclipse.gef4.zest.fx.jface.IGraphContentProvider;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;

public class ZestContentViewer
extends ContentViewer {
    private SelectionNotifier selectionNotifier = new SelectionNotifier();
    private Injector injector;
    private FXCanvas canvas;
    private FXDomain domain;
    private FXViewer viewer;
    private ILayoutAlgorithm layoutAlgorithm;
    private Map<Object, org.eclipse.gef4.graph.Node> contentNodeMap = new IdentityHashMap<Object, org.eclipse.gef4.graph.Node>();

    public ZestContentViewer(Module module) {
        this.injector = Guice.createInjector((Module[])new Module[]{module});
    }

    protected FXCanvas createCanvas(Composite parent, int style) {
        IFXCanvasFactory canvasFactory = (IFXCanvasFactory)this.injector.getInstance(IFXCanvasFactory.class);
        return canvasFactory.createCanvas(parent, style);
    }

    public void createControl(Composite parent, int style) {
        this.canvas = this.createCanvas(parent, style);
        this.domain = (FXDomain)this.injector.getInstance(FXDomain.class);
        this.viewer = (FXViewer)this.domain.getAdapter(FXViewer.class);
        this.canvas.setScene(new Scene((Parent)this.viewer.getCanvas()));
        this.getSelectionModel().getSelectionUnmodifiable().addListener((ListChangeListener)this.selectionNotifier);
        this.selectionNotifier.activate();
        this.domain.activate();
    }

    protected Edge createEdge(ILabelProvider labelProvider, Object contentSourceNode, org.eclipse.gef4.graph.Node sourceNode, Object contentTargetNode, org.eclipse.gef4.graph.Node targetNode) {
        IGraphAttributesProvider graphNodeLabelProvider;
        Map<String, Object> edgeAttributes;
        Edge edge = new Edge(sourceNode, targetNode);
        if (labelProvider instanceof IGraphAttributesProvider && (edgeAttributes = (graphNodeLabelProvider = (IGraphAttributesProvider)labelProvider).getEdgeAttributes(contentSourceNode, contentTargetNode)) != null) {
            edge.attributesProperty().putAll(edgeAttributes);
        }
        return edge;
    }

    protected Graph createEmptyGraph() {
        Graph graph = new Graph();
        if (this.layoutAlgorithm != null) {
            ZestProperties.setLayoutAlgorithm((Graph)graph, (ILayoutAlgorithm)this.layoutAlgorithm);
        }
        return graph;
    }

    protected Graph createNestedGraph(Object contentNestingNode, IGraphContentProvider graphContentProvider, ILabelProvider labelProvider) {
        Object[] contentNodes;
        IGraphAttributesProvider nestedGraphLabelProvider;
        Map<String, Object> nestedGraphAttributes;
        Graph graph = this.createEmptyGraph();
        if (labelProvider instanceof IGraphAttributesProvider && (nestedGraphAttributes = (nestedGraphLabelProvider = (IGraphAttributesProvider)labelProvider).getNestedGraphAttributes(contentNestingNode)) != null) {
            graph.attributesProperty().putAll(nestedGraphAttributes);
        }
        if ((contentNodes = graphContentProvider.getNestedGraphNodes(contentNestingNode)) != null) {
            this.createNodesAndEdges(graphContentProvider, labelProvider, graph, contentNodes);
        }
        return graph;
    }

    protected org.eclipse.gef4.graph.Node createNode(final Object contentNode, IGraphContentProvider graphContentProvider, final ILabelProvider labelProvider) {
        IGraphAttributesProvider graphNodeLabelProvider;
        Map<String, Object> nodeAttributes;
        if (this.contentNodeMap.containsKey(contentNode)) {
            throw new IllegalStateException("A node for content <" + contentNode + "> has already been created.");
        }
        org.eclipse.gef4.graph.Node node = new org.eclipse.gef4.graph.Node();
        this.contentNodeMap.put(contentNode, node);
        ZestProperties.setLabel((org.eclipse.gef4.graph.Node)node, (Provider)new Provider<String>(){

            public String get() {
                return labelProvider.getText(contentNode);
            }
        });
        org.eclipse.swt.graphics.Image icon = labelProvider.getImage(contentNode);
        if (icon != null) {
            ZestProperties.setIcon((org.eclipse.gef4.graph.Node)node, (Image)SWTFXUtils.toFXImage((ImageData)icon.getImageData(), null));
        }
        if (labelProvider instanceof IToolTipProvider) {
            final IToolTipProvider toolTipProvider = (IToolTipProvider)labelProvider;
            ZestProperties.setTooltip((org.eclipse.gef4.graph.Node)node, (Provider)new Provider<String>(){

                public String get() {
                    return toolTipProvider.getToolTipText(contentNode);
                }
            });
        }
        String textCssStyle = "";
        if (labelProvider instanceof IColorProvider) {
            IColorProvider colorProvider = (IColorProvider)labelProvider;
            Color foreground = colorProvider.getForeground(contentNode);
            Color background = colorProvider.getBackground(contentNode);
            String rectCssStyle = "";
            if (background != null) {
                rectCssStyle = String.valueOf(rectCssStyle) + "-fx-fill: " + this.toCssRgb(background) + ";";
            }
            if (foreground != null) {
                rectCssStyle = String.valueOf(rectCssStyle) + "-fx-stroke: " + this.toCssRgb(foreground) + ";";
                textCssStyle = "-fx-fill: " + this.toCssRgb(foreground) + ";";
            }
            if (!rectCssStyle.isEmpty()) {
                ZestProperties.setNodeRectCssStyle((org.eclipse.gef4.graph.Node)node, (String)rectCssStyle);
            }
        }
        if (labelProvider instanceof IFontProvider) {
            FontData[] fontData;
            IFontProvider fontProvider = (IFontProvider)labelProvider;
            Font font = fontProvider.getFont(contentNode);
            FontData[] fontDataArray = fontData = font == null ? null : font.getFontData();
            if (fontData != null && fontData.length > 0 && fontData[0] != null) {
                String name = fontData[0].getName();
                int size = fontData[0].getHeight();
                int style = fontData[0].getStyle();
                boolean isBold = (style & 1) != 0;
                boolean isItalic = (style & 2) != 0;
                textCssStyle = String.valueOf(textCssStyle) + "-fx-font-family: \"" + name + "\";" + "-fx-font-size: " + size + "pt;";
                if (isItalic) {
                    textCssStyle = String.valueOf(textCssStyle) + "-fx-font-style: italic;";
                }
                if (isBold) {
                    textCssStyle = String.valueOf(textCssStyle) + "-fx-font-weight: bold;";
                }
            }
        }
        ZestProperties.setLabelCssStyle((org.eclipse.gef4.graph.Node)node, (String)textCssStyle);
        if (labelProvider instanceof IGraphAttributesProvider && (nodeAttributes = (graphNodeLabelProvider = (IGraphAttributesProvider)labelProvider).getNodeAttributes(contentNode)) != null) {
            node.attributesProperty().putAll(nodeAttributes);
        }
        if (graphContentProvider.hasNestedGraph(contentNode)) {
            Graph graph = this.createNestedGraph(contentNode, graphContentProvider, labelProvider);
            graph.setNestingNode(node);
        }
        return node;
    }

    protected void createNodesAndEdges(IGraphContentProvider graphContentProvider, ILabelProvider labelProvider, Graph graph, Object[] contentNodes) {
        Object[] objectArray = contentNodes;
        int n = contentNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            org.eclipse.gef4.graph.Node graphNode = this.createNode(node, graphContentProvider, labelProvider);
            graph.getNodes().add((Object)graphNode);
            graphNode.setGraph(graph);
            ++n2;
        }
        objectArray = contentNodes;
        n = contentNodes.length;
        n2 = 0;
        while (n2 < n) {
            Object contentSourceNode = objectArray[n2];
            org.eclipse.gef4.graph.Node sourceNode = this.contentNodeMap.get(contentSourceNode);
            Object[] connectedTo = graphContentProvider.getAdjacentNodes(contentSourceNode);
            if (connectedTo != null) {
                Object[] objectArray2 = connectedTo;
                int n3 = connectedTo.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object contentTargetNode = objectArray2[n4];
                    org.eclipse.gef4.graph.Node targetNode = this.contentNodeMap.get(contentTargetNode);
                    Edge edge = this.createEdge(labelProvider, contentSourceNode, sourceNode, contentTargetNode, targetNode);
                    graph.getEdges().add((Object)edge);
                    edge.setGraph(graph);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    protected Graph createRootGraph(IContentProvider contentProvider, ILabelProvider labelProvider) {
        IGraphContentProvider graphNodeProvider;
        Object[] nodes;
        IGraphAttributesProvider graphNodeLabelProvider;
        Map<String, Object> rootGraphAttributes;
        Graph graph = this.createEmptyGraph();
        if (labelProvider instanceof IGraphAttributesProvider && (rootGraphAttributes = (graphNodeLabelProvider = (IGraphAttributesProvider)labelProvider).getGraphAttributes()) != null) {
            graph.attributesProperty().putAll(rootGraphAttributes);
        }
        if (contentProvider instanceof IGraphContentProvider && (nodes = (graphNodeProvider = (IGraphContentProvider)contentProvider).getNodes()) != null) {
            this.createNodesAndEdges(graphNodeProvider, labelProvider, graph, nodes);
        }
        return graph;
    }

    public Map<Object, org.eclipse.gef4.graph.Node> getContentNodeMap() {
        return Collections.unmodifiableMap(this.contentNodeMap);
    }

    public FXCanvas getControl() {
        return this.canvas;
    }

    public FXViewer getFXViewer() {
        return this.viewer;
    }

    public ILabelProvider getLabelProvider() {
        return (ILabelProvider)super.getLabelProvider();
    }

    public ILayoutAlgorithm getLayoutAlgorithm() {
        return this.layoutAlgorithm;
    }

    public ISelection getSelection() {
        ArrayList<Object> selectedContents = new ArrayList<Object>();
        SelectionModel<Node> selectionModel = this.getSelectionModel();
        for (IContentPart selectedPart : selectionModel.getSelectionUnmodifiable()) {
            selectedContents.add(selectedPart.getContent());
        }
        return new StructuredSelection(selectedContents);
    }

    protected SelectionModel<Node> getSelectionModel() {
        SelectionModel selectionModel = (SelectionModel)this.viewer.getAdapter(SelectionModel.class);
        if (selectionModel == null) {
            throw new IllegalStateException("No SelectionModel bound.");
        }
        return selectionModel;
    }

    protected void handleDispose(DisposeEvent event) {
        this.selectionNotifier.deactivate();
        this.getSelectionModel().getSelectionUnmodifiable().removeListener((ListChangeListener)this.selectionNotifier);
        this.domain.deactivate();
        this.domain.dispose();
        super.handleDispose(event);
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (!(input == oldInput || input != null && input.equals(oldInput))) {
            this.refresh();
        }
    }

    public void refresh() {
        this.contentNodeMap.clear();
        ((ContentModel)this.viewer.getAdapter(ContentModel.class)).getContents().setAll(Collections.singletonList(this.createRootGraph(this.getContentProvider(), this.getLabelProvider())));
    }

    public void setLayoutAlgorithm(ILayoutAlgorithm layoutAlgorithm) {
        this.layoutAlgorithm = layoutAlgorithm;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (selection.isEmpty()) {
            this.getSelectionModel().clearSelection();
        } else if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            if (!structuredSelection.isEmpty()) {
                ArrayList<IContentPart> toBeSelectedParts = new ArrayList<IContentPart>();
                Object[] objectArray = structuredSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object toBeSelectedContent = objectArray[n2];
                    IContentPart toBeSelectedPart = (IContentPart)this.viewer.getContentPartMap().get(toBeSelectedContent);
                    if (toBeSelectedPart != null) {
                        toBeSelectedParts.add(toBeSelectedPart);
                        if (reveal) {
                            this.viewer.reveal((IVisualPart)toBeSelectedPart);
                        }
                    } else {
                        throw new IllegalArgumentException(toBeSelectedContent + " is not visualized by a content part of this viewer.");
                    }
                    ++n2;
                }
                this.getSelectionModel().prependToSelection(toBeSelectedParts);
            }
        } else {
            throw new IllegalArgumentException("A non-empty selection of unsupported type '" + selection.getClass() + "' was passed in.");
        }
    }

    protected String toCssRgb(Color color) {
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    private final class SelectionNotifier
    implements ListChangeListener<IContentPart<Node, ? extends Node>>,
    IActivatable {
        private ActivatableSupport acs = new ActivatableSupport((IActivatable)this);

        private SelectionNotifier() {
        }

        public void activate() {
            this.acs.activate();
        }

        public ReadOnlyBooleanProperty activeProperty() {
            return this.acs.activeProperty();
        }

        public void deactivate() {
            this.acs.deactivate();
        }

        public boolean isActive() {
            return this.acs.isActive();
        }

        public void onChanged(ListChangeListener.Change<? extends IContentPart<Node, ? extends Node>> c) {
            if (this.isActive()) {
                ZestContentViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)ZestContentViewer.this, ZestContentViewer.this.getSelection()));
            }
        }
    }
}

