/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.behaviors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.ReadOnlyBooleanProperty;
import org.eclipse.gef4.common.activate.ActivatableSupport;
import org.eclipse.gef4.common.activate.IActivatable;
import org.eclipse.gef4.common.adapt.inject.AdaptableScopes;
import org.eclipse.gef4.common.collections.ObservableSetMultimap;
import org.eclipse.gef4.mvc.behaviors.BehaviorUtils;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.domain.IDomain;
import org.eclipse.gef4.mvc.parts.IFeedbackPart;
import org.eclipse.gef4.mvc.parts.IHandlePart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public abstract class AbstractBehavior<VR>
implements IBehavior<VR> {
    private IVisualPart<VR, ? extends VR> host;
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this);
    private List<IHandlePart<VR, ? extends VR>> handleParts;
    private List<IFeedbackPart<VR, ? extends VR>> feedbackParts;

    public final void activate() {
        if (!this.acs.isActive()) {
            this.acs.activate();
            this.doActivate();
        }
    }

    public ReadOnlyBooleanProperty activeProperty() {
        return this.acs.activeProperty();
    }

    protected void addFeedback(List<? extends IVisualPart<VR, ? extends VR>> targets, List<? extends IFeedbackPart<VR, ? extends VR>> feedback) {
        if (targets != null && !targets.isEmpty()) {
            this.feedbackParts = new ArrayList<IFeedbackPart<VR, VR>>(feedback);
            BehaviorUtils.addAnchoreds(this.getHost().getRoot(), targets, this.feedbackParts);
        }
    }

    protected void addHandles(List<? extends IVisualPart<VR, ? extends VR>> targets, List<? extends IHandlePart<VR, ? extends VR>> handles) {
        if (handles != null && !handles.isEmpty()) {
            this.handleParts = new ArrayList<IHandlePart<VR, VR>>(handles);
            BehaviorUtils.addAnchoreds(this.getHost().getRoot(), targets, this.handleParts);
        }
    }

    public final void deactivate() {
        if (this.acs.isActive()) {
            this.doDeactivate();
            this.acs.deactivate();
        }
    }

    protected void doActivate() {
    }

    protected void doDeactivate() {
    }

    public IVisualPart<VR, ? extends VR> getAdaptable() {
        return this.getHost();
    }

    protected List<IFeedbackPart<VR, ? extends VR>> getFeedbackParts() {
        return this.feedbackParts;
    }

    protected List<IHandlePart<VR, ? extends VR>> getHandleParts() {
        return this.handleParts;
    }

    @Override
    public IVisualPart<VR, ? extends VR> getHost() {
        return this.host;
    }

    public boolean isActive() {
        return this.acs.isActive();
    }

    protected void removeFeedback(List<? extends IVisualPart<VR, ? extends VR>> targets) {
        if (this.feedbackParts != null && !this.feedbackParts.isEmpty() && targets != null && !targets.isEmpty()) {
            BehaviorUtils.removeAnchoreds(this.getHost().getRoot(), targets, this.feedbackParts);
            this.feedbackParts.clear();
        }
    }

    protected void removeHandles(List<? extends IVisualPart<VR, ? extends VR>> targets) {
        if (this.handleParts != null && !this.handleParts.isEmpty() && targets != null && !targets.isEmpty()) {
            BehaviorUtils.removeAnchoreds(this.getHost().getRoot(), targets, this.handleParts);
            this.handleParts.clear();
        }
    }

    public void setAdaptable(IVisualPart<VR, ? extends VR> adaptable) {
        this.host = adaptable;
    }

    protected void switchAdaptableScopes() {
        IVisualPart<VR, VR> host = this.getHost();
        IViewer<VR> viewer = host.getRoot().getViewer();
        IDomain<VR> domain = viewer.getDomain();
        AdaptableScopes.switchTo(domain);
        AdaptableScopes.switchTo(viewer);
        AdaptableScopes.switchTo(host);
    }

    protected IHandlePart<VR, ? extends VR> updateHandles(IVisualPart<VR, ? extends VR> target, List<? extends IHandlePart<VR, ? extends VR>> handles, Comparator<IHandlePart<VR, ? extends VR>> interactedWithComparator, IHandlePart<VR, ? extends VR> interactedWith) {
        IHandlePart replacementHandle = null;
        if (handles != null && !handles.isEmpty()) {
            ArrayList<IHandlePart<VR, VR>> oldHandles = new ArrayList<IHandlePart<VR, VR>>(this.getHandleParts());
            Iterator it = oldHandles.iterator();
            while (it.hasNext()) {
                IHandlePart oldHandle = (IHandlePart)it.next();
                ObservableSetMultimap anchorages = oldHandle.getAnchoragesUnmodifiable();
                if (anchorages.keySet().contains(target)) continue;
                it.remove();
            }
            ArrayList<IHandlePart<VR, VR>> newHandles = new ArrayList<IHandlePart<VR, VR>>(handles);
            BehaviorUtils.addAnchoreds(this.getHost().getRoot(), Collections.singletonList(target), newHandles);
            if (interactedWithComparator != null) {
                double minDistance = -1.0;
                for (IHandlePart iHandlePart : newHandles) {
                    double d = interactedWithComparator.compare(interactedWith, iHandlePart);
                    if (replacementHandle != null && !(d < minDistance)) continue;
                    minDistance = d;
                    replacementHandle = iHandlePart;
                }
                if (replacementHandle != null) {
                    newHandles.remove(replacementHandle);
                }
            }
            if (interactedWith != null) {
                oldHandles.remove(interactedWith);
            }
            ArrayList<IHandlePart> toRemove = new ArrayList<IHandlePart>();
            it = oldHandles.iterator();
            while (it.hasNext()) {
                boolean bl;
                IHandlePart oldHandle = (IHandlePart)it.next();
                boolean bl2 = true;
                for (IHandlePart iHandlePart : newHandles) {
                    Comparable comparable;
                    int compareTo;
                    if (!(iHandlePart instanceof Comparable) || (compareTo = (comparable = (Comparable)((Object)oldHandle)).compareTo(iHandlePart)) != 0) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                toRemove.add(oldHandle);
                it.remove();
            }
            BehaviorUtils.removeAnchoreds(this.getHost().getRoot(), Collections.singletonList(target), toRemove);
            this.handleParts.removeAll(toRemove);
            ArrayList<IHandlePart> alreadyExists = new ArrayList<IHandlePart>();
            it = newHandles.iterator();
            while (it.hasNext()) {
                boolean bl;
                IHandlePart iHandlePart = (IHandlePart)it.next();
                boolean bl3 = false;
                for (IHandlePart iHandlePart2 : oldHandles) {
                    Comparable comparable;
                    int compareTo;
                    if (!(iHandlePart2 instanceof Comparable) || (compareTo = (comparable = (Comparable)((Object)iHandlePart2)).compareTo(iHandlePart)) != 0) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                alreadyExists.add(iHandlePart);
                it.remove();
            }
            if (replacementHandle != null) {
                alreadyExists.add(replacementHandle);
            }
            BehaviorUtils.removeAnchoreds(this.getHost().getRoot(), Collections.singletonList(target), alreadyExists);
            this.handleParts.addAll(newHandles);
        }
        return replacementHandle;
    }
}

