/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import org.eclipse.gef4.common.attributes.IAttributeStore;
import org.eclipse.gef4.common.beans.property.ReadOnlyMapWrapperEx;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;

public class Node
implements IAttributeStore {
    private final ReadOnlyMapWrapper<String, Object> attributesProperty = new ReadOnlyMapWrapperEx((Object)this, "attributes", FXCollections.observableHashMap());
    private Graph graph;
    private Graph nestedGraph;

    public Node() {
        this(new HashMap<String, Object>());
    }

    public Node(Map<String, Object> attributes) {
        this.attributesProperty.putAll(attributes);
    }

    public ReadOnlyMapProperty<String, Object> attributesProperty() {
        return this.attributesProperty.getReadOnlyProperty();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Node)) {
            return false;
        }
        return this.attributesProperty.get() == null ? false : ((ObservableMap)this.attributesProperty().get()).equals(((Node)other).attributesProperty());
    }

    public Set<Edge> getAllIncomingEdges() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set<Edge> incoming = Collections.newSetFromMap(new IdentityHashMap());
        incoming.addAll(this.getLocalIncomingEdges());
        if (this.graph.getNestingNode() != null) {
            incoming.addAll(this.graph.getNestingNode().getAllIncomingEdges());
        }
        return incoming;
    }

    public Set<Node> getAllNeighbors() {
        Set<Node> neighbors = Collections.newSetFromMap(new IdentityHashMap());
        neighbors.addAll(this.getAllPredecessorNodes());
        neighbors.addAll(this.getAllSuccessorNodes());
        return neighbors;
    }

    public Set<Edge> getAllOutgoingEdges() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set<Edge> outgoing = Collections.newSetFromMap(new IdentityHashMap());
        outgoing.addAll(this.getLocalOutgoingEdges());
        if (this.graph.getNestingNode() != null) {
            outgoing.addAll(this.graph.getNestingNode().getAllOutgoingEdges());
        }
        return outgoing;
    }

    public Set<Node> getAllPredecessorNodes() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set<Node> predecessors = Collections.newSetFromMap(new IdentityHashMap());
        predecessors.addAll(this.getLocalPredecessorNodes());
        if (this.graph.getNestingNode() != null) {
            predecessors.addAll(this.graph.getNestingNode().getAllPredecessorNodes());
        }
        return predecessors;
    }

    public Set<Node> getAllSuccessorNodes() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set<Node> successors = Collections.newSetFromMap(new IdentityHashMap());
        successors.addAll(this.getLocalSuccessorNodes());
        if (this.graph.getNestingNode() != null) {
            successors.addAll(this.graph.getNestingNode().getAllSuccessorNodes());
        }
        return successors;
    }

    public ObservableMap<String, Object> getAttributes() {
        return this.attributesProperty.get();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Set<Edge> getLocalIncomingEdges() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set<Edge> incoming = Collections.newSetFromMap(new IdentityHashMap());
        for (Edge e : this.graph.getEdges()) {
            if (e.getTarget() != this) continue;
            incoming.add(e);
        }
        return incoming;
    }

    public Set<Node> getLocalNeighbors() {
        Set<Node> neighbors = Collections.newSetFromMap(new IdentityHashMap());
        neighbors.addAll(this.getLocalPredecessorNodes());
        neighbors.addAll(this.getLocalSuccessorNodes());
        return neighbors;
    }

    public Set<Edge> getLocalOutgoingEdges() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set<Edge> outgoing = Collections.newSetFromMap(new IdentityHashMap());
        for (Edge e : this.graph.getEdges()) {
            if (e.getSource() != this) continue;
            outgoing.add(e);
        }
        return outgoing;
    }

    public Set<Node> getLocalPredecessorNodes() {
        Set<Node> predecessors = Collections.newSetFromMap(new IdentityHashMap());
        for (Edge incoming : this.getLocalIncomingEdges()) {
            predecessors.add(incoming.getSource());
        }
        return predecessors;
    }

    public Set<Node> getLocalSuccessorNodes() {
        Set<Node> successors = Collections.newSetFromMap(new IdentityHashMap());
        for (Edge outgoing : this.getLocalOutgoingEdges()) {
            successors.add(outgoing.getTarget());
        }
        return successors;
    }

    public Graph getNestedGraph() {
        return this.nestedGraph;
    }

    public int hashCode() {
        return this.attributesProperty.get() == null ? 0 : this.attributesProperty.get().hashCode();
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setNestedGraph(Graph nestedGraph) {
        this.nestedGraph = nestedGraph;
        if (nestedGraph.getNestingNode() != this) {
            nestedGraph.setNestingNode(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node {");
        boolean separator = false;
        TreeMap<String, Object> sortedAttrs = new TreeMap<String, Object>();
        sortedAttrs.putAll((Map<String, Object>)this.attributesProperty);
        for (Object attrKey : sortedAttrs.keySet()) {
            if (separator) {
                sb.append(", ");
            } else {
                separator = true;
            }
            sb.append(String.valueOf(attrKey.toString()) + " : " + this.attributesProperty.get(attrKey));
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private Map<String, Object> attrs = new HashMap<String, Object>();
        private Graph.Builder.Context context;
        private Object key;

        public Builder() {
            this(null);
        }

        public Builder(Graph.Builder.Context context) {
            this(context, null);
        }

        public Builder(Graph.Builder.Context context, Object key) {
            this.context = context;
            if (context != null) {
                this.key = key == null ? UUID.randomUUID() : key;
                this.context.nodeBuilders.put(this.key, this);
            }
        }

        public Builder attr(String key, Object value) {
            this.attrs.put(key, value);
            return this;
        }

        public Graph build() {
            return this.context.builder.build();
        }

        public Node buildNode() {
            return new Node(this.attrs);
        }

        public Edge.Builder edge(Object sourceNodeOrKey, Object targetNodeOrKey) {
            Edge.Builder eb = new Edge.Builder(this.context, sourceNodeOrKey, targetNodeOrKey);
            return eb;
        }

        protected Object getKey() {
            return this.key;
        }

        public Builder node() {
            Builder nb = new Builder(this.context);
            return nb;
        }

        public Builder node(Object key) {
            Builder nb = new Builder(this.context, key);
            return nb;
        }
    }
}

