/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal;

import com.google.common.base.Objects;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import org.eclipse.gef4.common.attributes.IAttributeStore;
import org.eclipse.gef4.dot.internal.DotAttributes;
import org.eclipse.gef4.dot.internal.DotFileUtils;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeOp;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class DotExport {
    public String exportDot(Graph graph) {
        Functions.Function1<Node, Boolean> _function;
        boolean _not;
        String _xblockexpression = null;
        ObservableMap _attributes = graph.getAttributes();
        boolean _containsKey = _attributes.containsKey((Object)"_type");
        boolean bl = _not = !_containsKey;
        if (_not) {
            throw new IllegalArgumentException("The _type attribute has to be set on the input graph " + graph + ".");
        }
        ObservableList _nodes = graph.getNodes();
        boolean _exists = IterableExtensions.exists((Iterable)_nodes, (Functions.Function1)(_function = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                ObservableMap _attributes = it.getAttributes();
                Object _get = _attributes.get((Object)"_name");
                return Objects.equal((Object)_get, null);
            }
        }));
        if (_exists) {
            throw new IllegalArgumentException("The _name attribute has to be set for all nodes of the input graph " + graph + ".");
        }
        _xblockexpression = this.print(graph);
        return _xblockexpression;
    }

    public File exportDot(Graph graph, String pathname) {
        String _exportDot = this.exportDot(graph);
        File _file = new File(pathname);
        return DotFileUtils.write(_exportDot, _file);
    }

    private String print(Graph graph) {
        StringConcatenation _builder = new StringConcatenation();
        ObservableMap _attributes = graph.getAttributes();
        Object _get = _attributes.get((Object)"_type");
        _builder.append(_get, "");
        _builder.append((Object)" ");
        boolean _hasName = this.hasName((IAttributeStore)graph);
        if (_hasName) {
            String _name = this.name((IAttributeStore)graph);
            _builder.append((Object)_name, "");
            _builder.append((Object)" ");
        }
        _builder.append((Object)"{");
        _builder.newLineIfNotEmpty();
        boolean _hasNonMetaAttributes = this.hasNonMetaAttributes((IAttributeStore)graph);
        if (_hasNonMetaAttributes) {
            _builder.append((Object)"\t");
            String _printNonMetaAttributes = this.printNonMetaAttributes((IAttributeStore)graph, ";");
            _builder.append((Object)_printNonMetaAttributes, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        ObservableList _nodes = graph.getNodes();
        Functions.Function1<Node, String> _function = new Functions.Function1<Node, String>(){

            public String apply(Node it) {
                ObservableMap _attributes = it.getAttributes();
                Object _get = _attributes.get((Object)"_name");
                return (String)_get;
            }
        };
        List _sortBy = IterableExtensions.sortBy((Iterable)_nodes, (Functions.Function1)_function);
        Functions.Function1<Node, String> _function_1 = new Functions.Function1<Node, String>(){

            public String apply(Node it) {
                return DotExport.this.print(it);
            }
        };
        List _map = ListExtensions.map((List)_sortBy, (Functions.Function1)_function_1);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"; ");
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        ObservableList _edges = graph.getEdges();
        Functions.Function1<Edge, String> _function_2 = new Functions.Function1<Edge, String>(){

            public String apply(Edge it) {
                ObservableMap _attributes = it.getAttributes();
                Object _get = _attributes.get((Object)"_name");
                return (String)_get;
            }
        };
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)_edges, (Functions.Function1)_function_2);
        for (Edge edge : _sortBy_1) {
            _builder.append((Object)"\t");
            String _name_1 = this.name((IAttributeStore)edge);
            _builder.append((Object)_name_1, "\t");
            boolean _hasNonMetaAttributes_1 = this.hasNonMetaAttributes((IAttributeStore)edge);
            if (_hasNonMetaAttributes_1) {
                _builder.append((Object)" [");
                String _printNonMetaAttributes_1 = this.printNonMetaAttributes((IAttributeStore)edge, ",");
                _builder.append((Object)_printNonMetaAttributes_1, "\t");
                _builder.append((Object)"]");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private boolean isMetaAttribute(String key) {
        return key.startsWith("_");
    }

    private boolean isDirected(Graph graph) {
        ObservableMap _attributes = graph.getAttributes();
        Object _get = _attributes.get((Object)"_type");
        return DotAttributes._TYPE__G__DIGRAPH.equals(_get);
    }

    private String print(Node node) {
        String _name = this.name((IAttributeStore)node);
        String _xifexpression = null;
        boolean _hasNonMetaAttributes = this.hasNonMetaAttributes((IAttributeStore)node);
        if (_hasNonMetaAttributes) {
            String _printNonMetaAttributes = this.printNonMetaAttributes((IAttributeStore)node, ",");
            String _plus = " [" + _printNonMetaAttributes;
            _xifexpression = String.valueOf(_plus) + "]";
        } else {
            _xifexpression = "";
        }
        return String.valueOf(_name) + _xifexpression;
    }

    private boolean hasName(IAttributeStore it) {
        ObservableMap _attributes = it.getAttributes();
        Object _get = _attributes.get((Object)"_name");
        return !Objects.equal((Object)_get, null);
    }

    private String _name(IAttributeStore store) {
        ObservableMap _attributes = store.getAttributes();
        Object _get = _attributes.get((Object)"_name");
        return (String)_get;
    }

    private String _name(Edge edge) {
        Node _source = edge.getSource();
        String _name = this.name((IAttributeStore)_source);
        String _xifexpression = null;
        Graph _graph = edge.getGraph();
        boolean _isDirected = this.isDirected(_graph);
        _xifexpression = _isDirected ? EdgeOp.DIRECTED.getLiteral() : EdgeOp.UNDIRECTED.getLiteral();
        String _plus = String.valueOf(_name) + _xifexpression;
        Node _target = edge.getTarget();
        String _name_1 = this.name((IAttributeStore)_target);
        return String.valueOf(_plus) + _name_1;
    }

    private boolean hasNonMetaAttributes(IAttributeStore store) {
        ObservableMap _attributes = store.getAttributes();
        Set _keySet = _attributes.keySet();
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                boolean _isMetaAttribute = DotExport.this.isMetaAttribute(it);
                return !_isMetaAttribute;
            }
        };
        return IterableExtensions.exists((Iterable)_keySet, (Functions.Function1)_function);
    }

    private String printNonMetaAttributes(IAttributeStore store, String separator) {
        ObservableMap _attributes = store.getAttributes();
        Set _entrySet = _attributes.entrySet();
        Functions.Function1<Map.Entry<String, Object>, Boolean> _function = new Functions.Function1<Map.Entry<String, Object>, Boolean>(){

            public Boolean apply(Map.Entry<String, Object> it) {
                String _key = it.getKey();
                boolean _isMetaAttribute = DotExport.this.isMetaAttribute(_key);
                return !_isMetaAttribute;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_entrySet, (Functions.Function1)_function);
        Functions.Function1<Map.Entry<String, Object>, String> _function_1 = new Functions.Function1<Map.Entry<String, Object>, String>(){

            public String apply(Map.Entry<String, Object> it) {
                String _key = it.getKey();
                String _plus = String.valueOf(_key) + "=\"";
                Object _value = it.getValue();
                String _plus_1 = String.valueOf(_plus) + _value;
                return String.valueOf(_plus_1) + "\"";
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        List _sort = IterableExtensions.sort((Iterable)_map);
        return IterableExtensions.join((Iterable)_sort, (CharSequence)(String.valueOf(separator) + " "));
    }

    private String name(IAttributeStore edge) {
        if (edge instanceof Edge) {
            return this._name((Edge)edge);
        }
        if (edge != null) {
            return this._name(edge);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(edge).toString());
    }
}

