/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.behaviors;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.collections.ListChangeListener;
import org.eclipse.gef4.common.collections.CollectionUtils;
import org.eclipse.gef4.common.reflect.Types;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPartFactory;
import org.eclipse.gef4.mvc.parts.IHandlePart;
import org.eclipse.gef4.mvc.parts.IHandlePartFactory;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class SelectionBehavior<VR>
extends AbstractBehavior<VR> {
    public static final String PART_FACTORIES_BINDING_NAME = "selection";
    @Inject
    @Named(value="selection")
    private IFeedbackPartFactory<VR> feedbackPartFactory;
    @Inject
    @Named(value="selection")
    private IHandlePartFactory<VR> handlePartFactory;
    private ListChangeListener<IContentPart<VR, ? extends VR>> selectionObserver = new ListChangeListener<IContentPart<VR, ? extends VR>>(){

        public void onChanged(ListChangeListener.Change<? extends IContentPart<VR, ? extends VR>> c) {
            ArrayList newSelection = new ArrayList(c.getList());
            List oldSelection = CollectionUtils.getPreviousContents(c);
            SelectionBehavior.this.removeFeedbackAndHandles(oldSelection);
            SelectionBehavior.this.addFeedbackAndHandles(newSelection);
        }
    };

    protected void addFeedbackAndHandles(List<? extends IContentPart<VR, ? extends VR>> selected) {
        if (this.getHost() instanceof IRootPart && selected.size() > 1) {
            this.switchAdaptableScopes();
            this.addFeedback(selected, this.feedbackPartFactory.createFeedbackParts(selected, this, Collections.emptyMap()));
            this.addHandles(selected, this.handlePartFactory.createHandleParts(selected, this, Collections.emptyMap()));
        } else if (selected.contains(this.getHost())) {
            this.getHost().getRoot().getViewer().reveal(this.getHost());
            List targets = Collections.singletonList(this.getHost());
            this.switchAdaptableScopes();
            this.addFeedback(targets, this.feedbackPartFactory.createFeedbackParts(targets, this, Collections.emptyMap()));
            if (selected.get(0) == this.getHost() && selected.size() <= 1) {
                this.addHandles(targets, this.handlePartFactory.createHandleParts(targets, this, Collections.emptyMap()));
            }
        }
    }

    @Override
    protected void doActivate() {
        SelectionModel<VR> selectionModel = this.getSelectionModel();
        selectionModel.getSelectionUnmodifiable().addListener(this.selectionObserver);
        this.addFeedbackAndHandles((List<? extends IContentPart<VR, ? extends VR>>)selectionModel.getSelectionUnmodifiable());
    }

    @Override
    protected void doDeactivate() {
        SelectionModel<VR> selectionModel = this.getSelectionModel();
        this.removeFeedbackAndHandles((List<? extends IContentPart<VR, ? extends VR>>)selectionModel.getSelectionUnmodifiable());
        selectionModel.getSelectionUnmodifiable().removeListener(this.selectionObserver);
    }

    protected IFeedbackPartFactory<VR> getFeedbackPartFactory() {
        return this.feedbackPartFactory;
    }

    protected IHandlePartFactory<VR> getHandlePartFactory() {
        return this.handlePartFactory;
    }

    protected SelectionModel<VR> getSelectionModel() {
        IViewer viewer = this.getHost().getRoot().getViewer();
        SelectionModel selectionModel = (SelectionModel)viewer.getAdapter(new TypeToken<SelectionModel<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(viewer.getClass())));
        return selectionModel;
    }

    protected void removeFeedbackAndHandles(List<? extends IContentPart<VR, ? extends VR>> selected) {
        if (this.getHost() instanceof IRootPart && selected.size() > 1) {
            this.removeHandles(selected);
            this.removeFeedback(selected);
        } else if (selected.contains(this.getHost())) {
            this.removeHandles(Collections.singletonList(this.getHost()));
            this.removeFeedback(Collections.singletonList(this.getHost()));
        }
    }

    public IHandlePart<VR, ? extends VR> updateHandles(Comparator<IHandlePart<VR, ? extends VR>> interactedWithComparator, IHandlePart<VR, ? extends VR> interactedWith) {
        this.switchAdaptableScopes();
        List<IHandlePart<VR, VR>> newHandles = this.handlePartFactory.createHandleParts(Collections.singletonList(this.getHost()), this, Collections.emptyMap());
        return this.updateHandles(this.getHost(), newHandles, interactedWithComparator, interactedWith);
    }
}

