/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.mvc.behaviors.HoverBehavior;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.fx.parts.FXHoverFeedbackPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPartFactory;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXDefaultHoverFeedbackPartFactory
implements IFeedbackPartFactory<Node> {
    public static final String HOVER_FEEDBACK_GEOMETRY_PROVIDER = "HOVER_FEEDBACK_GEOMETRY_PROVIDER";
    @Inject
    private Injector injector;

    public List<IFeedbackPart<Node, ? extends Node>> createFeedbackParts(List<? extends IVisualPart<Node, ? extends Node>> targets, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap) {
        if (!(contextBehavior instanceof HoverBehavior)) {
            throw new IllegalArgumentException("The FXDefaultHoverFeedbackPartFactory can only generate feedback parts in the context of a HoverBehavior, but the context behavior is a <" + contextBehavior + ">.");
        }
        if (targets == null || targets.isEmpty()) {
            throw new IllegalArgumentException("Part factory is called without targets.");
        }
        if (targets.size() > 1) {
            throw new IllegalArgumentException("Cannot create feedback for multiple targets.");
        }
        final IVisualPart<Node, ? extends Node> target = targets.iterator().next();
        ArrayList<IFeedbackPart<Node, ? extends Node>> feedbackParts = new ArrayList<IFeedbackPart<Node, ? extends Node>>();
        final Provider hoverFeedbackGeometryProvider = (Provider)target.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)HOVER_FEEDBACK_GEOMETRY_PROVIDER));
        if (hoverFeedbackGeometryProvider != null) {
            Provider<IGeometry> geometryInSceneProvider = new Provider<IGeometry>(){

                public IGeometry get() {
                    return NodeUtils.localToScene((Node)((Node)target.getVisual()), (IGeometry)((IGeometry)hoverFeedbackGeometryProvider.get()));
                }
            };
            FXHoverFeedbackPart part = (FXHoverFeedbackPart)((Object)this.injector.getInstance(FXHoverFeedbackPart.class));
            part.setGeometryProvider((Provider<? extends IGeometry>)geometryInSceneProvider);
            feedbackParts.add((IFeedbackPart<Node, ? extends Node>)part);
        }
        return feedbackParts;
    }
}

