/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.anchors.DynamicAnchor;
import org.eclipse.gef4.fx.anchors.ProjectionStrategy;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.behaviors.SelectionBehavior;
import org.eclipse.gef4.mvc.fx.parts.FXSelectionFeedbackPart;
import org.eclipse.gef4.mvc.fx.parts.FXSelectionLinkFeedbackPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPartFactory;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXDefaultSelectionFeedbackPartFactory
implements IFeedbackPartFactory<Node> {
    public static final String SELECTION_FEEDBACK_GEOMETRY_PROVIDER = "SELECTION_FEEDBACK_GEOMETRY_PROVIDER";
    public static final String SELECTION_LINK_FEEDBACK_GEOMETRY_PROVIDER = "SELECTION_LINK_FEEDBACK_GEOMETRY_PROVIDER";
    @Inject
    private Injector injector;

    public List<IFeedbackPart<Node, ? extends Node>> createFeedbackParts(List<? extends IVisualPart<Node, ? extends Node>> targets, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap) {
        if (!(contextBehavior instanceof SelectionBehavior)) {
            throw new IllegalArgumentException("The FXDefaultSelectionFeedbackPartFactory can only generate feedback parts in the context of a SelectionBehavior, but the context behavior is a <" + contextBehavior + ">.");
        }
        if (targets == null || targets.isEmpty()) {
            throw new IllegalArgumentException("Part factory is called without targets.");
        }
        ArrayList<IFeedbackPart<Node, ? extends Node>> feedbackParts = new ArrayList<IFeedbackPart<Node, ? extends Node>>();
        final IVisualPart<Node, ? extends Node> target = targets.iterator().next();
        final Provider selectionFeedbackGeometryProvider = (Provider)target.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)SELECTION_FEEDBACK_GEOMETRY_PROVIDER));
        if (selectionFeedbackGeometryProvider != null) {
            Provider<IGeometry> provider = new Provider<IGeometry>(){

                public IGeometry get() {
                    return NodeUtils.localToScene((Node)((Node)target.getVisual()), (IGeometry)((IGeometry)selectionFeedbackGeometryProvider.get()));
                }
            };
            FXSelectionFeedbackPart selectionFeedbackPart = (FXSelectionFeedbackPart)((Object)this.injector.getInstance(FXSelectionFeedbackPart.class));
            selectionFeedbackPart.setGeometryProvider((Provider<? extends IGeometry>)provider);
            feedbackParts.add((IFeedbackPart<Node, ? extends Node>)selectionFeedbackPart);
        }
        for (IVisualPart<Node, ? extends Node> iVisualPart : targets) {
            if (iVisualPart.getAnchoragesUnmodifiable().isEmpty()) continue;
            for (Map.Entry entry : iVisualPart.getAnchoragesUnmodifiable().entries()) {
                IFeedbackPart<Node, ? extends Node> anchorLinkFeedbackPart;
                if (!(entry.getKey() instanceof IVisualPart) || (anchorLinkFeedbackPart = this.createLinkFeedbackPart(iVisualPart, (IVisualPart<Node, ? extends Node>)((IVisualPart)entry.getKey()), (String)entry.getValue())) == null) continue;
                feedbackParts.add(anchorLinkFeedbackPart);
            }
        }
        return feedbackParts;
    }

    private IFeedbackPart<Node, ? extends Node> createLinkFeedbackPart(final IVisualPart<Node, ? extends Node> anchored, final IVisualPart<Node, ? extends Node> anchorage, String anchorageRole) {
        if (!(anchored.getVisual() instanceof Connection)) {
            final Provider anchorageGeometryProvider = (Provider)anchorage.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)SELECTION_LINK_FEEDBACK_GEOMETRY_PROVIDER));
            final Provider anchoredGeometryProvider = (Provider)anchored.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)SELECTION_LINK_FEEDBACK_GEOMETRY_PROVIDER));
            if (anchoredGeometryProvider != null && anchorageGeometryProvider != null) {
                Provider<IGeometry> linkFeedbackGeometryProvider = new Provider<IGeometry>(){
                    private final ProjectionStrategy computationStrategy = new ProjectionStrategy();

                    private Point computePosition(Node n1, IGeometry n1Geometry, Node n2, IGeometry n2Geometry) {
                        Point n2RefPoint = n2Geometry.getBounds().getCenter();
                        HashSet<Object> parameters = new HashSet<Object>();
                        parameters.add(new DynamicAnchor.AnchorageReferenceGeometry(n1Geometry));
                        parameters.add(new DynamicAnchor.AnchoredReferencePoint(n2RefPoint));
                        return this.computationStrategy.computePositionInScene(n1, n2, parameters);
                    }

                    public IGeometry get() {
                        Node anchoredVisual = (Node)anchored.getVisual();
                        IGeometry anchoredGeometryInLocal = (IGeometry)anchoredGeometryProvider.get();
                        Node anchorageVisual = (Node)anchorage.getVisual();
                        IGeometry anchorageGeometryInLocal = (IGeometry)anchorageGeometryProvider.get();
                        Point sourcePointInScene = this.computePosition(anchoredVisual, anchoredGeometryInLocal, anchorageVisual, anchorageGeometryInLocal);
                        Point targetPointInScene = this.computePosition(anchorageVisual, anchorageGeometryInLocal, anchoredVisual, anchoredGeometryInLocal);
                        return new Line(sourcePointInScene, targetPointInScene);
                    }
                };
                FXSelectionLinkFeedbackPart part = (FXSelectionLinkFeedbackPart)((Object)this.injector.getInstance(FXSelectionLinkFeedbackPart.class));
                part.setGeometryProvider((Provider<? extends IGeometry>)linkFeedbackGeometryProvider);
                return part;
            }
        }
        return null;
    }
}

