/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXBendConnectionPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnDragPolicy;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;

public class FXNormalizeConnectedOnDragPolicy
extends AbstractFXInteractionPolicy
implements IFXOnDragPolicy {
    private Set<IVisualPart<Node, ? extends Node>> connected;

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.connected == null) {
            return;
        }
        for (IVisualPart<Node, ? extends Node> part : this.connected) {
            ((FXBendConnectionPolicy)((Object)part.getAdapter(FXBendConnectionPolicy.class))).normalize();
        }
    }

    @Override
    public void dragAborted() {
        if (this.connected == null) {
            return;
        }
        for (IVisualPart<Node, ? extends Node> part : this.connected) {
            this.rollback((AbstractTransactionPolicy)part.getAdapter(FXBendConnectionPolicy.class));
            this.restoreRefreshVisuals(part);
        }
        this.connected = null;
    }

    @Override
    public void hideIndicationCursor() {
    }

    @Override
    public void press(MouseEvent e) {
        this.connected = Collections.newSetFromMap(new IdentityHashMap());
        for (IVisualPart anchored : this.getHost().getAnchoredsUnmodifiable()) {
            FXBendConnectionPolicy bendConnectionPolicy;
            if (!(anchored instanceof IContentPart) || (bendConnectionPolicy = (FXBendConnectionPolicy)((Object)anchored.getAdapter(FXBendConnectionPolicy.class))) == null || this.connected.contains(anchored)) continue;
            this.connected.add((IVisualPart<Node, ? extends Node>)anchored);
        }
        SelectionModel selectionModel = (SelectionModel)this.getHost().getRoot().getViewer().getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){});
        Iterator<IVisualPart<Node, ? extends Node>> it = this.connected.iterator();
        while (it.hasNext()) {
            IVisualPart<Node, ? extends Node> part = it.next();
            if (!(part instanceof IContentPart) || !selectionModel.isSelected((IContentPart)part)) continue;
            it.remove();
        }
        if (this.connected.isEmpty()) {
            this.connected = null;
        } else {
            for (IVisualPart<Node, ? extends Node> part : this.connected) {
                this.storeAndDisableRefreshVisuals(part);
                this.init((AbstractTransactionPolicy)part.getAdapter(FXBendConnectionPolicy.class));
            }
        }
    }

    @Override
    public void release(MouseEvent e, Dimension delta) {
        if (this.connected == null) {
            return;
        }
        for (IVisualPart<Node, ? extends Node> part : this.connected) {
            this.commit((AbstractTransactionPolicy)part.getAdapter(FXBendConnectionPolicy.class));
            this.restoreRefreshVisuals(part);
        }
        this.connected = null;
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }
}

