/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.ICompositeOperation;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;

public abstract class AbstractCompositeOperation
extends AbstractOperation
implements ICompositeOperation,
ITransactionalOperation {
    List<ITransactionalOperation> operations = new ArrayList<ITransactionalOperation>();

    public AbstractCompositeOperation(String label) {
        super(label);
    }

    public void add(IUndoableOperation operation) {
        if (!(operation instanceof ITransactionalOperation)) {
            throw new IllegalArgumentException("The given operation may not be null and must implement ITransactionalOperation.");
        }
        this.operations.add((ITransactionalOperation)operation);
    }

    public void addAll(List<ITransactionalOperation> operations) {
        for (ITransactionalOperation op : operations) {
            this.add(op);
        }
    }

    public void addContext(IUndoContext context) {
        super.addContext(context);
    }

    public boolean canExecute() {
        for (ITransactionalOperation operation : this.operations) {
            if (operation.canExecute()) continue;
            return false;
        }
        return true;
    }

    public boolean canRedo() {
        for (ITransactionalOperation operation : this.operations) {
            if (operation.canRedo()) continue;
            return false;
        }
        return true;
    }

    public boolean canUndo() {
        for (ITransactionalOperation operation : this.operations) {
            if (operation.canUndo()) continue;
            return false;
        }
        return true;
    }

    protected IStatus combine(IStatus s1, IStatus s2) {
        MultiStatus status = new MultiStatus("org.eclipse.gef4.mvc", 0, null, null);
        status.merge(s1);
        status.merge(s2);
        return status;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        for (ITransactionalOperation operation : this.operations) {
            this.combine(status, operation.execute(monitor, info));
        }
        return status;
    }

    public List<ITransactionalOperation> getOperations() {
        return this.operations;
    }

    @Override
    public boolean isContentRelevant() {
        for (ITransactionalOperation op : this.operations) {
            if (!op.isContentRelevant()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    @Override
    public boolean isNoOp() {
        for (ITransactionalOperation op : this.operations) {
            if (op.isNoOp()) continue;
            return false;
        }
        return true;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        for (ITransactionalOperation operation : this.operations) {
            this.combine(status, operation.redo(monitor, info));
        }
        return status;
    }

    public void remove(IUndoableOperation operation) {
        this.operations.remove(operation);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        for (ITransactionalOperation operation : this.operations) {
            this.combine(status, operation.undo(monitor, info));
        }
        return status;
    }

    public ITransactionalOperation unwrap(boolean filterNoOps) {
        if (filterNoOps) {
            int i = this.operations.size() - 1;
            while (i >= 0) {
                ITransactionalOperation op = this.operations.get(i);
                if (op.isNoOp()) {
                    this.operations.remove(i);
                }
                --i;
            }
        }
        if (this.operations.size() == 0) {
            return null;
        }
        if (this.operations.size() == 1) {
            return this.operations.get(0);
        }
        return this;
    }
}

