/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.ui.parts;

import com.google.inject.Inject;
import com.google.inject.Injector;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.swt.canvas.IFXCanvasFactory;
import org.eclipse.gef4.mvc.fx.domain.FXDomain;
import org.eclipse.gef4.mvc.fx.ui.parts.DeleteActionHandler;
import org.eclipse.gef4.mvc.fx.ui.parts.SelectionForwarder;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.ui.properties.IPropertySheetPageFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class AbstractFXView
extends ViewPart {
    @Inject
    private FXDomain domain;
    @Inject
    private IFXCanvasFactory canvasFactory;
    private FXCanvas canvas = null;
    @Inject(optional=true)
    private ISelectionProvider selectionProvider;
    private SelectionForwarder<Node> selectionForwarder;
    @Inject(optional=true)
    private IPropertySheetPageFactory propertySheetPageFactory;
    private IPropertySheetPage propertySheetPage;
    private UndoRedoActionGroup undoRedoActionGroup;
    private DeleteActionHandler deleteActionHandler;

    public AbstractFXView(Injector injector) {
        injector.injectMembers((Object)this);
    }

    protected void activate() {
        this.domain.activate();
    }

    protected FXCanvas createCanvas(Composite parent) {
        return this.canvasFactory.createCanvas(parent, 0);
    }

    public void createPartControl(Composite parent) {
        this.canvas = this.createCanvas(parent);
        this.hookViewers();
        this.registerWorkbenchSelectionForwarder(this.getContentViewer());
        this.activate();
    }

    protected IPropertySheetPage createPropertySheetPage() {
        if (this.propertySheetPageFactory != null) {
            return this.propertySheetPageFactory.create((IWorkbenchPart)this);
        }
        return null;
    }

    protected void deactivate() {
        this.domain.deactivate();
    }

    public void dispose() {
        this.deactivate();
        this.unhookViewers();
        if (this.selectionProvider != null) {
            this.getSite().setSelectionProvider(null);
        }
        if (this.undoRedoActionGroup != null) {
            this.undoRedoActionGroup.dispose();
        }
        this.deleteActionHandler.init(null);
        this.domain.dispose();
        super.dispose();
    }

    public Object getAdapter(Class key) {
        if (ISelectionProvider.class.equals((Object)key)) {
            return this.selectionProvider;
        }
        if (IPropertySheetPage.class.equals((Object)key)) {
            if (this.propertySheetPage == null) {
                this.propertySheetPage = this.createPropertySheetPage();
            }
            return this.propertySheetPage;
        }
        if (IUndoContext.class.equals((Object)key)) {
            return this.domain.getUndoContext();
        }
        if (IOperationHistory.class.equals((Object)key)) {
            return this.domain.getOperationHistory();
        }
        return super.getAdapter(key);
    }

    protected FXCanvas getCanvas() {
        return this.canvas;
    }

    protected FXViewer getContentViewer() {
        return (FXViewer)this.domain.getAdapter(AdapterKey.get(FXViewer.class, (String)"contentViewer"));
    }

    protected FXDomain getDomain() {
        return this.domain;
    }

    protected void hookViewers() {
        FXViewer contentViewer = this.getContentViewer();
        this.canvas.setScene(new Scene((Parent)contentViewer.getCanvas()));
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.undoRedoActionGroup = new UndoRedoActionGroup(this.getSite(), (IUndoContext)this.getAdapter(IUndoContext.class), true);
        this.undoRedoActionGroup.fillActionBars(site.getActionBars());
        this.deleteActionHandler = new DeleteActionHandler();
        this.deleteActionHandler.init(this.getContentViewer());
        site.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteActionHandler);
        if (this.selectionProvider != null) {
            site.setSelectionProvider(this.selectionProvider);
        }
    }

    protected void registerWorkbenchSelectionForwarder(FXViewer contentViewer) {
        if (this.selectionProvider != null) {
            this.selectionForwarder = new SelectionForwarder(this.selectionProvider, contentViewer);
        }
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    protected void unhookViewers() {
        if (this.selectionForwarder != null) {
            this.selectionForwarder.dispose();
            this.selectionForwarder = null;
        }
    }
}

