/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal;

import com.google.inject.Injector;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.gef4.dot.internal.parser.DotArrowTypeStandaloneSetup;
import org.eclipse.gef4.dot.internal.parser.DotPointStandaloneSetup;
import org.eclipse.gef4.dot.internal.parser.DotShapeStandaloneSetup;
import org.eclipse.gef4.dot.internal.parser.DotSplineTypeStandaloneSetup;
import org.eclipse.gef4.dot.internal.parser.DotStyleStandaloneSetup;
import org.eclipse.gef4.dot.internal.parser.dir.DirType;
import org.eclipse.gef4.dot.internal.parser.parser.antlr.DotArrowTypeParser;
import org.eclipse.gef4.dot.internal.parser.parser.antlr.DotPointParser;
import org.eclipse.gef4.dot.internal.parser.parser.antlr.DotShapeParser;
import org.eclipse.gef4.dot.internal.parser.parser.antlr.DotSplineTypeParser;
import org.eclipse.gef4.dot.internal.parser.parser.antlr.DotStyleParser;
import org.eclipse.gef4.dot.internal.parser.rankdir.Rankdir;
import org.eclipse.gef4.dot.internal.parser.validation.DotArrowTypeJavaValidator;
import org.eclipse.gef4.dot.internal.parser.validation.DotPointJavaValidator;
import org.eclipse.gef4.dot.internal.parser.validation.DotShapeJavaValidator;
import org.eclipse.gef4.dot.internal.parser.validation.DotSplineTypeJavaValidator;
import org.eclipse.gef4.dot.internal.parser.validation.DotStyleJavaValidator;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.serializer.ISerializer;

public class DotLanguageSupport {
    public static IPrimitiveValueParser<DirType> DIRTYPE_PARSER = new IPrimitiveValueParser<DirType>(){

        @Override
        public IPrimitiveValueParseResult<DirType> parse(String rawValue) {
            if (rawValue == null) {
                return null;
            }
            DirType[] dirTypeArray = DirType.values();
            int n = dirTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DirType value = dirTypeArray[n2];
                if (value.toString().equals(rawValue)) {
                    return new PrimitiveValueParseResultImpl<DirType>((Object)value);
                }
                ++n2;
            }
            return new PrimitiveValueParseResultImpl<DirType>(Collections.singletonList(new BasicDiagnostic(4, rawValue, -1, "Value has to be one of " + DotLanguageSupport.getFormattedValues((Object[])DirType.values()) + ".", new Object[0])));
        }
    };
    public static IPrimitiveValueParser<Rankdir> RANKDIR_PARSER = new IPrimitiveValueParser<Rankdir>(){

        @Override
        public IPrimitiveValueParseResult<Rankdir> parse(String rawValue) {
            if (rawValue == null) {
                return null;
            }
            Rankdir[] rankdirArray = Rankdir.values();
            int n = rankdirArray.length;
            int n2 = 0;
            while (n2 < n) {
                Rankdir value = rankdirArray[n2];
                if (value.toString().equals(rawValue)) {
                    return new PrimitiveValueParseResultImpl<Rankdir>((Object)value);
                }
                ++n2;
            }
            return new PrimitiveValueParseResultImpl<Rankdir>(Collections.singletonList(new BasicDiagnostic(4, rawValue, -1, "The given value '" + rawValue + "' has to be one of " + DotLanguageSupport.getFormattedValues((Object[])Rankdir.values()), new Object[0])));
        }
    };
    public static IPrimitiveValueParser<Boolean> BOOL_PARSER = new IPrimitiveValueParser<Boolean>(){

        @Override
        public IPrimitiveValueParseResult<Boolean> parse(String rawValue) {
            if (rawValue == null) {
                return null;
            }
            if (Boolean.TRUE.toString().equalsIgnoreCase(rawValue) || "yes".equalsIgnoreCase(rawValue)) {
                return new PrimitiveValueParseResultImpl<Boolean>((Object)Boolean.TRUE);
            }
            if (Boolean.FALSE.toString().equalsIgnoreCase(rawValue) || "no".equalsIgnoreCase(rawValue)) {
                return new PrimitiveValueParseResultImpl<Boolean>((Object)Boolean.FALSE);
            }
            try {
                int parsedValue = Integer.parseInt(rawValue);
                return new PrimitiveValueParseResultImpl<Boolean>((Object)(parsedValue > 0 ? Boolean.TRUE : Boolean.FALSE));
            }
            catch (NumberFormatException numberFormatException) {
                return new PrimitiveValueParseResultImpl<Boolean>(Collections.singletonList(new BasicDiagnostic(4, rawValue, -1, "The given value '" + rawValue + "' does not (case-insensitively) equal 'true', 'yes', 'false', or 'no' and is also not parsable as an integer value", new Object[0])));
            }
        }
    };
    public static IPrimitiveValueParser<Double> DOUBLE_PARSER = new IPrimitiveValueParser<Double>(){

        @Override
        public IPrimitiveValueParseResult<Double> parse(String rawValue) {
            if (rawValue == null) {
                return null;
            }
            try {
                double parsedValue = Double.parseDouble(rawValue);
                return new PrimitiveValueParseResultImpl<Double>((Object)new Double(parsedValue));
            }
            catch (NumberFormatException exception) {
                return new PrimitiveValueParseResultImpl<Double>(Collections.singletonList(new BasicDiagnostic(4, rawValue, -1, exception.getMessage(), new Object[0])));
            }
        }
    };
    public static IPrimitiveValueParser<Integer> INT_PARSER = new IPrimitiveValueParser<Integer>(){

        @Override
        public IPrimitiveValueParseResult<Integer> parse(String rawValue) {
            if (rawValue == null) {
                return null;
            }
            try {
                int parsedValue = Integer.parseInt(rawValue);
                return new PrimitiveValueParseResultImpl<Integer>((Object)new Integer(parsedValue));
            }
            catch (NumberFormatException exception) {
                return new PrimitiveValueParseResultImpl<Integer>(Collections.singletonList(new BasicDiagnostic(4, rawValue, -1, exception.getMessage(), new Object[0])));
            }
        }
    };
    private static final Injector arrowTypeInjector = new DotArrowTypeStandaloneSetup().createInjectorAndDoEMFRegistration();
    public static final DotArrowTypeJavaValidator ARROWTYPE_VALIDATOR = (DotArrowTypeJavaValidator)((Object)arrowTypeInjector.getInstance(DotArrowTypeJavaValidator.class));
    public static final DotArrowTypeParser ARROWTYPE_PARSER = (DotArrowTypeParser)((Object)arrowTypeInjector.getInstance(DotArrowTypeParser.class));
    public static final ISerializer ARROWTYPE_SERIALIZER = (ISerializer)arrowTypeInjector.getInstance(ISerializer.class);
    private static final Injector pointInjector = new DotPointStandaloneSetup().createInjectorAndDoEMFRegistration();
    public static final DotPointParser POINT_PARSER = (DotPointParser)((Object)pointInjector.getInstance(DotPointParser.class));
    public static final ISerializer POINT_SERIALIZER = (ISerializer)pointInjector.getInstance(ISerializer.class);
    public static final DotPointJavaValidator POINT_VALIDATOR = (DotPointJavaValidator)((Object)pointInjector.getInstance(DotPointJavaValidator.class));
    private static final Injector shapeInjector = new DotShapeStandaloneSetup().createInjectorAndDoEMFRegistration();
    public static final DotShapeJavaValidator SHAPE_VALIDATOR = (DotShapeJavaValidator)((Object)shapeInjector.getInstance(DotShapeJavaValidator.class));
    public static final DotShapeParser SHAPE_PARSER = (DotShapeParser)((Object)shapeInjector.getInstance(DotShapeParser.class));
    public static final ISerializer SHAPE_SERIALIZER = (ISerializer)shapeInjector.getInstance(ISerializer.class);
    private static final Injector splineTypeInjector = new DotSplineTypeStandaloneSetup().createInjectorAndDoEMFRegistration();
    public static final DotSplineTypeParser SPLINETYPE_PARSER = (DotSplineTypeParser)((Object)splineTypeInjector.getInstance(DotSplineTypeParser.class));
    public static final ISerializer SPLINETYPE_SERIALIZER = (ISerializer)splineTypeInjector.getInstance(ISerializer.class);
    private static final Injector styleInjector = new DotStyleStandaloneSetup().createInjectorAndDoEMFRegistration();
    public static final ISerializer STYLE_SERIALIZER = (ISerializer)styleInjector.getInstance(ISerializer.class);
    public static final DotStyleJavaValidator STYLE_VALIDATOR = (DotStyleJavaValidator)((Object)styleInjector.getInstance(DotStyleJavaValidator.class));
    public static final DotStyleParser STYLE_PARSER = (DotStyleParser)((Object)styleInjector.getInstance(DotStyleParser.class));
    public static final DotSplineTypeJavaValidator SPLINETYPE_VALIDATOR = (DotSplineTypeJavaValidator)((Object)splineTypeInjector.getInstance(DotSplineTypeJavaValidator.class));

    private static String getFormattedValues(Object[] values) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("'" + value.toString() + "'");
            ++n2;
        }
        return sb.append(".").toString();
    }

    public static <T> T parseAttributeValue(IPrimitiveValueParser<T> parser, String attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        IPrimitiveValueParseResult<T> parsedAttributeValue = parser.parse(attributeValue);
        return parsedAttributeValue.getParsedValue();
    }

    public static <T> T parseAttributeValue(IParser parser, String attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        IParseResult parsedAttributeValue = parser.parse((Reader)new StringReader(attributeValue));
        return (T)parsedAttributeValue.getRootASTElement();
    }

    public static interface IPrimitiveValueParseResult<T> {
        public T getParsedValue();

        public List<Diagnostic> getSyntaxErrors();

        public boolean hasSyntaxErrors();
    }

    public static interface IPrimitiveValueParser<T> {
        public IPrimitiveValueParseResult<T> parse(String var1);
    }

    private static class PrimitiveValueParseResultImpl<T>
    implements IPrimitiveValueParseResult<T> {
        private T parsedValue;
        private List<Diagnostic> syntaxErrors;

        private PrimitiveValueParseResultImpl(T parsedValue) {
            this(parsedValue, Collections.emptyList());
        }

        private PrimitiveValueParseResultImpl(List<Diagnostic> syntaxErrors) {
            this(null, syntaxErrors);
        }

        private PrimitiveValueParseResultImpl(T parsedValue, List<Diagnostic> syntaxErrors) {
            this.parsedValue = parsedValue;
            this.syntaxErrors = syntaxErrors;
        }

        @Override
        public T getParsedValue() {
            return this.parsedValue;
        }

        @Override
        public List<Diagnostic> getSyntaxErrors() {
            return this.syntaxErrors;
        }

        @Override
        public boolean hasSyntaxErrors() {
            return !this.syntaxErrors.isEmpty();
        }
    }
}

