/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.inject.Provider;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.transform.Affine;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXSegmentHandlePart;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.CursorSupport;
import org.eclipse.gef4.mvc.fx.policies.FXResizePolicy;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnDragPolicy;
import org.eclipse.gef4.mvc.models.GridModel;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;
import org.eclipse.gef4.mvc.policies.AbstractTransformPolicy;

public class FXResizeTranslateFirstAnchorageOnHandleDragPolicy
extends AbstractFXInteractionPolicy
implements IFXOnDragPolicy {
    private boolean invalidGesture = false;
    private Point initialPointerLocation;
    private double initialTx;
    private double initialTy;
    private int translationIndex;
    private CursorSupport cursorSupport = new CursorSupport(this);
    private IVisualPart<Node, ? extends Node> targetPart;

    protected IVisualPart<Node, ? extends Node> determineTargetPart() {
        return (IVisualPart)this.getHost().getAnchoragesUnmodifiable().keySet().iterator().next();
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        Node visual = (Node)this.getTargetPart().getVisual();
        Point2D startLocal = visual.sceneToLocal(this.initialPointerLocation.x, this.initialPointerLocation.y);
        Point2D endLocal = visual.sceneToLocal(e.getSceneX(), e.getSceneY());
        Point2D endParent = visual.localToParent(endLocal);
        Dimension snapToGridOffset = AbstractTransformPolicy.getSnapToGridOffset((GridModel)((GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class)), (double)endParent.getX(), (double)endParent.getY(), (double)this.getSnapToGridGranularityX(), (double)this.getSnapToGridGranularityY());
        endLocal = visual.parentToLocal(endParent.getX() - snapToGridOffset.width, endParent.getY() - snapToGridOffset.height);
        double deltaX = endLocal.getX() - startLocal.getX();
        double deltaY = endLocal.getY() - startLocal.getY();
        Point2D layout = visual.parentToLocal(this.initialTx, this.initialTy);
        double lx = layout.getX();
        double ly = layout.getY();
        int segment = this.getHost().getSegmentIndex();
        if (segment == 0 || segment == 3) {
            lx += deltaX;
        }
        if (segment == 0 || segment == 1) {
            ly += deltaY;
        }
        Point2D layoutParent = visual.localToParent(lx, ly);
        double pdx = layoutParent.getX() - this.initialTx;
        double pdy = layoutParent.getY() - this.initialTy;
        double ldw = segment == 1 || segment == 2 ? deltaX : -deltaX;
        double ldh = segment == 2 || segment == 3 ? deltaY : -deltaY;
        this.getResizePolicy().resize(ldw, ldh);
        this.getTransformPolicy().setPostTranslate(this.translationIndex, pdx, pdy);
    }

    @Override
    public void dragAborted() {
        if (this.invalidGesture) {
            return;
        }
        this.restoreRefreshVisuals(this.getTargetPart());
        this.commit((AbstractTransactionPolicy)this.getResizePolicy());
        this.commit((AbstractTransactionPolicy)this.getTransformPolicy());
    }

    protected CursorSupport getCursorSupport() {
        return this.cursorSupport;
    }

    public AbstractFXSegmentHandlePart<? extends Node> getHost() {
        return (AbstractFXSegmentHandlePart)super.getHost();
    }

    protected FXResizePolicy getResizePolicy() {
        return (FXResizePolicy)((Object)this.getTargetPart().getAdapter(FXResizePolicy.class));
    }

    protected double getSnapToGridGranularityX() {
        return 1.0;
    }

    protected double getSnapToGridGranularityY() {
        return 1.0;
    }

    protected IVisualPart<Node, ? extends Node> getTargetPart() {
        return this.targetPart;
    }

    private Affine getTargetTransform() {
        return (Affine)((Provider)this.getTargetPart().getAdapter(FXTransformPolicy.TRANSFORM_PROVIDER_KEY)).get();
    }

    protected FXTransformPolicy getTransformPolicy() {
        return (FXTransformPolicy)((Object)this.getTargetPart().getAdapter(FXTransformPolicy.class));
    }

    @Override
    public void hideIndicationCursor() {
        this.getCursorSupport().restoreCursor();
    }

    private boolean isMultiSelection() {
        return ((SelectionModel)this.getTargetPart().getRoot().getViewer().getAdapter(SelectionModel.class)).getSelectionUnmodifiable().size() > 1;
    }

    protected boolean isResizeTranslate(MouseEvent event) {
        return !event.isControlDown() && !this.isMultiSelection();
    }

    @Override
    public void press(MouseEvent e) {
        this.setTargetPart(this.determineTargetPart());
        boolean bl = this.invalidGesture = !this.isResizeTranslate(e);
        if (this.invalidGesture) {
            return;
        }
        this.storeAndDisableRefreshVisuals(this.getTargetPart());
        this.initialPointerLocation = new Point(e.getSceneX(), e.getSceneY());
        Affine targetTransform = this.getTargetTransform();
        this.initialTx = targetTransform.getTx();
        this.initialTy = targetTransform.getTy();
        this.init((AbstractTransactionPolicy)this.getResizePolicy());
        this.init((AbstractTransactionPolicy)this.getTransformPolicy());
        this.translationIndex = this.getTransformPolicy().createPostTransform();
    }

    @Override
    public void release(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            this.invalidGesture = false;
            return;
        }
        this.restoreRefreshVisuals(this.getTargetPart());
        this.commit((AbstractTransactionPolicy)this.getResizePolicy());
        this.commit((AbstractTransactionPolicy)this.getTransformPolicy());
    }

    protected void setTargetPart(IVisualPart<Node, ? extends Node> determinedTargetPart) {
        this.targetPart = determinedTargetPart;
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }
}

