/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.Comparator;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.OrthogonalRouter;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.behaviors.SelectionBehavior;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXSegmentHandlePart;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.CursorSupport;
import org.eclipse.gef4.mvc.fx.policies.FXBendConnectionPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnDragPolicy;
import org.eclipse.gef4.mvc.models.GridModel;
import org.eclipse.gef4.mvc.models.HoverModel;
import org.eclipse.gef4.mvc.parts.IHandlePart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;
import org.eclipse.gef4.mvc.policies.AbstractTransformPolicy;

public class FXBendFirstAnchorageOnSegmentHandleDragPolicy
extends AbstractFXInteractionPolicy
implements IFXOnDragPolicy {
    private CursorSupport cursorSupport = new CursorSupport(this);
    private IVisualPart<Node, ? extends Connection> targetPart;
    private boolean isSegmentDragged;
    private Point initialMouseInScene;
    private Point handlePositionInScene;
    private int initialSegmentIndex;
    private double initialSegmentParameter;
    private boolean isInvalid = false;
    private Comparator<IHandlePart<Node, ? extends Node>> handleDistanceComparator = new Comparator<IHandlePart<Node, ? extends Node>>(){

        @Override
        public int compare(IHandlePart<Node, ? extends Node> interactedWith, IHandlePart<Node, ? extends Node> other) {
            Bounds otherBounds = ((Node)other.getVisual()).getLayoutBounds();
            Point2D otherPosition = ((Node)other.getVisual()).localToScene(otherBounds.getMinX() + otherBounds.getWidth() / 2.0, otherBounds.getMinY() + otherBounds.getHeight() / 2.0);
            return (int)(FXBendFirstAnchorageOnSegmentHandleDragPolicy.this.handlePositionInScene.getDistance(FX2Geometry.toPoint((Point2D)otherPosition)) * 10.0);
        }
    };

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.isInvalid) {
            return;
        }
        Connection connection = (Connection)this.targetPart.getVisual();
        boolean isOrthogonal = this.isSegmentDragged && connection.getRouter() instanceof OrthogonalRouter;
        boolean isHorizontal = isOrthogonal && this.getBendPolicy(this.targetPart).isSelectionHorizontal();
        Point2D endPointInParent = ((Connection)this.targetPart.getVisual()).getParent().sceneToLocal(e.getSceneX(), e.getSceneY());
        Dimension snapToGridOffset = AbstractTransformPolicy.getSnapToGridOffset((GridModel)((GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class)), (double)endPointInParent.getX(), (double)endPointInParent.getY(), (double)this.getSnapToGridGranularityX(), (double)this.getSnapToGridGranularityY());
        endPointInParent = new Point2D(endPointInParent.getX() - snapToGridOffset.width, endPointInParent.getY() - snapToGridOffset.height);
        Point2D endPointInScene = ((Connection)this.targetPart.getVisual()).getParent().localToScene(endPointInParent);
        this.getBendPolicy(this.targetPart).move(this.initialMouseInScene, FX2Geometry.toPoint((Point2D)endPointInScene));
        if (isOrthogonal) {
            if (isHorizontal) {
                this.handlePositionInScene.setY(endPointInScene.getY());
            } else {
                this.handlePositionInScene.setX(endPointInScene.getX());
            }
        } else {
            this.handlePositionInScene.setX(endPointInScene.getX());
            this.handlePositionInScene.setY(endPointInScene.getY());
        }
        this.updateHandles();
    }

    @Override
    public void dragAborted() {
        if (this.isInvalid) {
            return;
        }
        this.restoreRefreshVisuals(this.targetPart);
        this.rollback((AbstractTransactionPolicy)this.getBendPolicy(this.targetPart));
        this.updateHandles();
    }

    protected FXBendConnectionPolicy getBendPolicy(IVisualPart<Node, ? extends Node> targetPart) {
        return (FXBendConnectionPolicy)((Object)targetPart.getAdapter(FXBendConnectionPolicy.class));
    }

    protected CursorSupport getCursorSupport() {
        return this.cursorSupport;
    }

    public AbstractFXSegmentHandlePart<? extends Node> getHost() {
        return (AbstractFXSegmentHandlePart)super.getHost();
    }

    protected double getSnapToGridGranularityX() {
        return 1.0;
    }

    protected double getSnapToGridGranularityY() {
        return 1.0;
    }

    protected IVisualPart<Node, ? extends Connection> getTargetPart() {
        return (IVisualPart)this.getHost().getAnchoragesUnmodifiable().keySet().iterator().next();
    }

    @Override
    public void hideIndicationCursor() {
        this.getCursorSupport().restoreCursor();
    }

    protected boolean isBend(MouseEvent event) {
        return true;
    }

    @Override
    public void press(MouseEvent e) {
        boolean bl = this.isInvalid = !this.isBend(e);
        if (this.isInvalid) {
            return;
        }
        this.isSegmentDragged = false;
        this.initialMouseInScene = new Point(e.getSceneX(), e.getSceneY());
        this.handlePositionInScene = this.initialMouseInScene.getCopy();
        AbstractFXSegmentHandlePart<? extends Node> hostPart = this.getHost();
        this.initialSegmentIndex = hostPart.getSegmentIndex();
        this.initialSegmentParameter = hostPart.getSegmentParameter();
        this.targetPart = this.getTargetPart();
        this.storeAndDisableRefreshVisuals(this.targetPart);
        FXBendConnectionPolicy bendPolicy = this.getBendPolicy(this.targetPart);
        this.init((AbstractTransactionPolicy)bendPolicy);
        if (hostPart.getSegmentParameter() == 0.5) {
            if (e.isShiftDown() || ((Connection)this.targetPart.getVisual()).getRouter() instanceof OrthogonalRouter) {
                bendPolicy.selectSegment(hostPart.getSegmentIndex());
                this.isSegmentDragged = true;
            } else {
                Integer previousAnchorHandle = bendPolicy.getExplicitIndexAtOrBefore(hostPart.getSegmentIndex());
                Integer newAnchorHandle = bendPolicy.createAfter(previousAnchorHandle, this.initialMouseInScene);
                bendPolicy.select(newAnchorHandle);
            }
        } else if (hostPart.getSegmentParameter() == 0.25 || hostPart.getSegmentParameter() == 0.75) {
            this.isSegmentDragged = true;
            boolean selectFirstHalve = hostPart.getSegmentParameter() == 0.25;
            int firstSegmentIndex = hostPart.getSegmentIndex();
            int secondSegmentIndex = hostPart.getSegmentIndex() + 1;
            Point firstPoint = ((Connection)this.targetPart.getVisual()).getPoint(firstSegmentIndex);
            Point secondPoint = ((Connection)this.targetPart.getVisual()).getPoint(secondSegmentIndex);
            Vector direction = new Vector(firstPoint, secondPoint);
            Point midPoint = firstPoint.getTranslated(direction.x / 2.0, direction.y / 2.0);
            Point2D midInScene = ((Connection)this.targetPart.getVisual()).localToScene(midPoint.x, midPoint.y);
            Node connectedAnchorage = ((Connection)this.targetPart.getVisual()).getAnchor(selectFirstHalve ? firstSegmentIndex : secondSegmentIndex).getAnchorage();
            boolean isConnected = connectedAnchorage != null && connectedAnchorage != this.targetPart.getVisual();
            List<Integer> explicit = bendPolicy.makeExplicit(firstSegmentIndex, secondSegmentIndex);
            Integer firstAnchorHandle = explicit.get(0);
            Integer secondAnchorHandle = explicit.get(1);
            if (isConnected) {
                int connectionIndex = bendPolicy.getBendOperation().getConnectionIndex(selectFirstHalve ? firstAnchorHandle : secondAnchorHandle);
                Point positionInScene = FX2Geometry.toPoint((Point2D)((Connection)this.targetPart.getVisual()).localToScene(Geometry2FX.toFXPoint((Point)bendPolicy.getConnection().getPoint(connectionIndex))));
                if (selectFirstHalve) {
                    firstAnchorHandle = bendPolicy.createAfter(firstAnchorHandle, positionInScene);
                } else {
                    secondAnchorHandle = bendPolicy.createBefore(secondAnchorHandle, positionInScene);
                }
            }
            if (selectFirstHalve) {
                secondAnchorHandle = bendPolicy.createAfter(firstAnchorHandle, FX2Geometry.toPoint((Point2D)midInScene));
                secondAnchorHandle = bendPolicy.createAfter(firstAnchorHandle, FX2Geometry.toPoint((Point2D)midInScene));
            } else {
                firstAnchorHandle = bendPolicy.createAfter(firstAnchorHandle, FX2Geometry.toPoint((Point2D)midInScene));
                firstAnchorHandle = bendPolicy.createAfter(firstAnchorHandle, FX2Geometry.toPoint((Point2D)midInScene));
                secondAnchorHandle = secondAnchorHandle + 2;
            }
            bendPolicy.select(firstAnchorHandle);
            bendPolicy.select(secondAnchorHandle);
        } else {
            int connectionIndex = hostPart.getSegmentIndex() + (hostPart.getSegmentParameter() == 1.0 ? 1 : 0);
            bendPolicy.select(bendPolicy.makeExplicit(connectionIndex, connectionIndex).get(0));
        }
        this.updateHandles();
    }

    @Override
    public void release(MouseEvent e, Dimension delta) {
        if (this.isInvalid) {
            return;
        }
        this.commit((AbstractTransactionPolicy)this.getBendPolicy(this.targetPart));
        this.restoreRefreshVisuals(this.targetPart);
        this.updateHandles();
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    protected void updateHandles() {
        IHandlePart replacementHandle = ((SelectionBehavior)this.targetPart.getAdapter((TypeToken)new TypeToken<SelectionBehavior<Node>>(){})).updateHandles(this.handleDistanceComparator, this.getHost());
        if (replacementHandle instanceof AbstractFXSegmentHandlePart) {
            AbstractFXSegmentHandlePart segmentData = (AbstractFXSegmentHandlePart)replacementHandle;
            this.getHost().setSegmentIndex(segmentData.getSegmentIndex());
            this.getHost().setSegmentParameter(segmentData.getSegmentParameter());
            if (segmentData.getSegmentParameter() == this.initialSegmentParameter) {
                ((HoverModel)this.getHost().getRoot().getViewer().getAdapter((TypeToken)new TypeToken<HoverModel<Node>>(){})).setHover(this.getHost());
            } else if (this.initialSegmentParameter != 0.25 && this.initialSegmentParameter != 0.75 || segmentData.getSegmentParameter() != 0.5 || Math.abs(segmentData.getSegmentIndex() - this.initialSegmentIndex) >= 2) {
                ((HoverModel)this.getHost().getRoot().getViewer().getAdapter((TypeToken)new TypeToken<HoverModel<Node>>(){})).clearHover();
            }
        }
    }
}

