/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.OrthogonalRouter;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Polyline;
import org.eclipse.gef4.mvc.behaviors.SelectionBehavior;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.CursorSupport;
import org.eclipse.gef4.mvc.fx.policies.FXBendConnectionPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnDragPolicy;
import org.eclipse.gef4.mvc.models.GridModel;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;
import org.eclipse.gef4.mvc.policies.AbstractTransformPolicy;

public class FXBendOnSegmentDragPolicy
extends AbstractFXInteractionPolicy
implements IFXOnDragPolicy {
    private CursorSupport cursorSupport = new CursorSupport(this);
    private Point initialMouseInScene;
    private boolean isInvalid = false;

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.isInvalid) {
            return;
        }
        Point2D endPointInParent = ((Connection)this.getHost().getVisual()).getParent().sceneToLocal(e.getSceneX(), e.getSceneY());
        Dimension snapToGridOffset = AbstractTransformPolicy.getSnapToGridOffset((GridModel)((GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class)), (double)endPointInParent.getX(), (double)endPointInParent.getY(), (double)this.getSnapToGridGranularityX(), (double)this.getSnapToGridGranularityY());
        endPointInParent = new Point2D(endPointInParent.getX() - snapToGridOffset.width, endPointInParent.getY() - snapToGridOffset.height);
        Point2D endPointInScene = ((Connection)this.getHost().getVisual()).getParent().localToScene(endPointInParent);
        this.getBendPolicy().move(this.initialMouseInScene, FX2Geometry.toPoint((Point2D)endPointInScene));
        this.updateHandles();
    }

    @Override
    public void dragAborted() {
        if (this.isInvalid) {
            return;
        }
        this.rollback((AbstractTransactionPolicy)this.getBendPolicy());
        this.restoreRefreshVisuals(this.getHost());
        this.updateHandles();
    }

    protected FXBendConnectionPolicy getBendPolicy() {
        return (FXBendConnectionPolicy)((Object)this.getHost().getAdapter(FXBendConnectionPolicy.class));
    }

    protected CursorSupport getCursorSupport() {
        return this.cursorSupport;
    }

    public IVisualPart<Node, Connection> getHost() {
        return super.getHost();
    }

    protected double getSnapToGridGranularityX() {
        return 1.0;
    }

    protected double getSnapToGridGranularityY() {
        return 1.0;
    }

    @Override
    public void hideIndicationCursor() {
        this.cursorSupport.restoreCursor();
    }

    protected boolean isBend(MouseEvent event) {
        IVisualPart<Node, Connection> host;
        ObservableList selection;
        boolean isInvalid = false;
        isInvalid = !(((Connection)this.getHost().getVisual()).getRouter() instanceof OrthogonalRouter) ? true : (selection = ((SelectionModel)(host = this.getHost()).getRoot().getViewer().getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).getSelectionUnmodifiable()).size() > 1 && selection.contains(host);
        return !isInvalid;
    }

    @Override
    public void press(MouseEvent e) {
        boolean bl = this.isInvalid = !this.isBend(e);
        if (this.isInvalid) {
            return;
        }
        this.initialMouseInScene = new Point(e.getSceneX(), e.getSceneY());
        this.storeAndDisableRefreshVisuals(this.getHost());
        FXBendConnectionPolicy bendPolicy = this.getBendPolicy();
        this.init((AbstractTransactionPolicy)bendPolicy);
        Connection connection = bendPolicy.getConnection();
        Polyline polyline = new Polyline((Point[])connection.getPointsUnmodifiable().toArray((Object[])new Point[0]));
        Polyline polylineInScene = (Polyline)NodeUtils.localToScene((Node)connection, (IGeometry)polyline);
        Line[] segmentsInScene = polylineInScene.getCurves();
        double minDistance = -1.0;
        int segmentIndex = -1;
        int i = 0;
        while (i < segmentsInScene.length) {
            Line segment = segmentsInScene[i];
            Point projection = segment.getProjection(this.initialMouseInScene);
            double distance = projection.getDistance(this.initialMouseInScene);
            if (minDistance < 0.0 || distance < minDistance) {
                minDistance = distance;
                segmentIndex = i;
            }
            ++i;
        }
        if (segmentIndex < 0) {
            throw new IllegalStateException("Cannot identify pressed segment.");
        }
        bendPolicy.selectSegment(segmentIndex);
        this.updateHandles();
    }

    @Override
    public void release(MouseEvent e, Dimension delta) {
        if (this.isInvalid) {
            return;
        }
        this.commit((AbstractTransactionPolicy)this.getBendPolicy());
        this.restoreRefreshVisuals(this.getHost());
        this.updateHandles();
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    protected void updateHandles() {
        ((SelectionBehavior)this.getHost().getAdapter(SelectionBehavior.class)).updateHandles(null, null);
    }
}

