/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.policies;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.policies.AbstractPolicy;

public abstract class AbstractTransactionPolicy<VR>
extends AbstractPolicy<VR> {
    private ITransactionalOperation operation;
    private boolean initialized;

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not yet initialized!");
        }
    }

    private void checkUninitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
    }

    public ITransactionalOperation commit() {
        this.checkInitialized();
        this.locallyExecuteOperation();
        this.initialized = false;
        ITransactionalOperation commit = this.getOperation();
        this.operation = null;
        if (commit != null && !commit.isNoOp()) {
            return commit;
        }
        return null;
    }

    protected abstract ITransactionalOperation createOperation();

    protected final ITransactionalOperation getOperation() {
        return this.operation;
    }

    public void init() {
        this.checkUninitialized();
        this.initialized = true;
        this.operation = this.createOperation();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void locallyExecuteOperation() {
        try {
            if (this.operation != null) {
                this.operation.execute(null, null);
            }
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    private void locallyUndoOperation() {
        try {
            if (this.operation != null) {
                this.operation.undo(null, null);
            }
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public void rollback() {
        this.initialized = false;
        this.locallyUndoOperation();
        this.operation = null;
    }
}

