/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.OrthogonalRouter;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.CursorSupport;
import org.eclipse.gef4.mvc.fx.policies.FXBendOnSegmentDragPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnDragPolicy;
import org.eclipse.gef4.mvc.models.GridModel;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;
import org.eclipse.gef4.mvc.policies.AbstractTransformPolicy;

public class FXTranslateSelectedOnDragPolicy
extends AbstractFXInteractionPolicy
implements IFXOnDragPolicy {
    private Point initialMouseLocationInScene = null;
    private Map<IContentPart<Node, ? extends Node>, Integer> translationIndices = new HashMap<IContentPart<Node, ? extends Node>, Integer>();
    private List<IContentPart<Node, ? extends Node>> targetParts;
    private CursorSupport cursorSupport = new CursorSupport(this);
    private boolean invalidGesture = false;

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        for (IContentPart<Node, ? extends Node> part : this.targetParts) {
            FXTransformPolicy policy = this.getTransformPolicy(part);
            if (policy == null) continue;
            Point2D startInParent = ((Node)this.getHost().getVisual()).getParent().sceneToLocal(0.0, 0.0);
            Point2D endInParent = ((Node)this.getHost().getVisual()).getParent().sceneToLocal(delta.width, delta.height);
            Dimension snapToGridOffset = AbstractTransformPolicy.getSnapToGridOffset((GridModel)((GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class)), (double)endInParent.getX(), (double)endInParent.getY(), (double)this.getSnapToGridGranularityX(), (double)this.getSnapToGridGranularityY());
            Point2D deltaInParent = new Point2D(endInParent.getX() - snapToGridOffset.width - startInParent.getX(), endInParent.getY() - snapToGridOffset.height - startInParent.getY());
            policy.setPostTranslate(this.translationIndices.get(part), deltaInParent.getX(), deltaInParent.getY());
        }
    }

    @Override
    public void dragAborted() {
        if (this.invalidGesture) {
            return;
        }
        for (IContentPart<Node, ? extends Node> part : this.targetParts) {
            FXTransformPolicy policy = this.getTransformPolicy(part);
            if (policy == null) continue;
            this.rollback((AbstractTransactionPolicy)policy);
            this.restoreRefreshVisuals((IVisualPart)part);
        }
        this.targetParts = null;
        this.setInitialMouseLocationInScene(null);
        this.translationIndices.clear();
    }

    protected CursorSupport getCursorSupport() {
        return this.cursorSupport;
    }

    protected Point getInitialMouseLocationInScene() {
        return this.initialMouseLocationInScene;
    }

    protected double getSnapToGridGranularityX() {
        return 1.0;
    }

    protected double getSnapToGridGranularityY() {
        return 1.0;
    }

    protected List<IContentPart<Node, ? extends Node>> getTargetParts() {
        return ((SelectionModel)this.getHost().getRoot().getViewer().getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).getSelectionUnmodifiable();
    }

    protected FXTransformPolicy getTransformPolicy(IContentPart<Node, ? extends Node> part) {
        return (FXTransformPolicy)((Object)part.getAdapter(FXTransformPolicy.class));
    }

    @Override
    public void hideIndicationCursor() {
        this.getCursorSupport().restoreCursor();
    }

    protected boolean isTranslate(MouseEvent event) {
        IContentPart<Node, ? extends Node> part;
        Node visual;
        if (this.targetParts.size() == 1 && this.targetParts.get(0).getAdapter(FXBendOnSegmentDragPolicy.class) != null && (visual = (Node)(part = this.targetParts.get(0)).getVisual()) instanceof Connection && ((Connection)visual).getRouter() instanceof OrthogonalRouter) {
            this.targetParts = null;
        }
        return this.targetParts != null && !this.targetParts.isEmpty();
    }

    @Override
    public void press(MouseEvent e) {
        this.targetParts = this.getTargetParts();
        boolean bl = this.invalidGesture = !this.isTranslate(e);
        if (this.invalidGesture) {
            return;
        }
        this.setInitialMouseLocationInScene(new Point(e.getSceneX(), e.getSceneY()));
        for (IContentPart<Node, ? extends Node> part : this.targetParts) {
            FXTransformPolicy policy = this.getTransformPolicy(part);
            if (policy == null) continue;
            this.storeAndDisableRefreshVisuals((IVisualPart)part);
            this.init((AbstractTransactionPolicy)policy);
            this.translationIndices.put(part, policy.createPostTransform());
        }
    }

    @Override
    public void release(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        for (IContentPart<Node, ? extends Node> part : this.targetParts) {
            FXTransformPolicy policy = this.getTransformPolicy(part);
            if (policy == null) continue;
            this.commit((AbstractTransactionPolicy)policy);
            this.restoreRefreshVisuals((IVisualPart)part);
        }
        this.targetParts = null;
        this.setInitialMouseLocationInScene(null);
        this.translationIndices.clear();
    }

    protected void setInitialMouseLocationInScene(Point point) {
        this.initialMouseLocationInScene = point;
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }
}

