/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Light;
import javafx.scene.effect.Lighting;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.CurvedPolygon;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.PolyBezier;
import org.eclipse.gef4.mvc.examples.logo.model.AbstractFXGeometricElement;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricCurve;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricShape;

public class FXGeometricModel {
    public static final double GEF_STROKE_WIDTH = 3.5;
    public static final Color GEF_COLOR_BLUE = Color.rgb((int)135, (int)150, (int)220);
    public static final Color GEF_COLOR_GREEN = Color.rgb((int)99, (int)123, (int)71);
    public static final Effect GEF_SHADOW_EFFECT = FXGeometricModel.createShadowEffect();
    public static final Double[] GEF_DASH_PATTERN = new Double[]{13.0, 8.0};
    public static final String SNAP_TO_GRID_PROPERTY = "snapToGrid";
    private final FXGeometricShape topLeftSelectionHandle = new FXGeometricShape(FXGeometricModel.createHandleShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 12.0, 15.0), (Paint)Color.WHITE, GEF_SHADOW_EFFECT);
    private final FXGeometricShape topRightSelectionHandle = new FXGeometricShape(FXGeometricModel.createHandleShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 243.0, 15.0), (Paint)Color.WHITE, GEF_SHADOW_EFFECT);
    private final FXGeometricShape bottomLeftSelectionHandle = new FXGeometricShape(FXGeometricModel.createHandleShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 12.0, 109.0), (Paint)Color.WHITE, GEF_SHADOW_EFFECT);
    private final FXGeometricShape bottomRightSelectionHandle = new FXGeometricShape(FXGeometricModel.createHandleShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 243.0, 109.0), (Paint)Color.WHITE, GEF_SHADOW_EFFECT);
    private final FXGeometricCurve selectionBoundsTopLine = new FXGeometricCurve(new Point[]{new Point(), new Point(140.0, 24.0), new Point()}, (Paint)GEF_COLOR_GREEN, 3.5, GEF_DASH_PATTERN, null);
    private final FXGeometricCurve selectionBoundsLeftLine = new FXGeometricCurve(new Point[]{new Point(), new Point(19.0, 70.0), new Point()}, (Paint)GEF_COLOR_GREEN, 3.5, GEF_DASH_PATTERN, null);
    private final FXGeometricCurve selectionBoundsBottomLine = new FXGeometricCurve(new Point[]{new Point(), new Point(140.0, 118.0), new Point()}, (Paint)GEF_COLOR_GREEN, 3.5, new Double[]{15.0, 10.0}, null);
    private final FXGeometricCurve selectionBoundsRightLine = new FXGeometricCurve(new Point[]{new Point(), new Point(250.0, 70.0), new Point()}, (Paint)GEF_COLOR_GREEN, 3.5, new Double[]{15.0, 10.0}, null);
    private final FXGeometricShape gBaseShape = new FXGeometricShape(FXGeometricModel.createGBaseShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 27.0, 22.0), (Paint)GEF_COLOR_BLUE, GEF_SHADOW_EFFECT);
    private final FXGeometricShape gTopShape = new FXGeometricShape(FXGeometricModel.createGTopShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 27.0, 22.0), (Paint)GEF_COLOR_BLUE, GEF_SHADOW_EFFECT);
    private final FXGeometricShape gMiddleShape = new FXGeometricShape(FXGeometricModel.createGMiddleShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 27.0, 22.0), (Paint)GEF_COLOR_BLUE, GEF_SHADOW_EFFECT);
    private final FXGeometricShape eShape = new FXGeometricShape(FXGeometricModel.createEShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 100.0, 22.0), (Paint)GEF_COLOR_BLUE, GEF_SHADOW_EFFECT);
    private final FXGeometricShape fShape = new FXGeometricShape(FXGeometricModel.createFShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 175.0, 22.0), (Paint)GEF_COLOR_BLUE, GEF_SHADOW_EFFECT);
    private final FXGeometricShape gDotShape = new FXGeometricShape(FXGeometricModel.createDotShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 87.0, 104.0), (Paint)GEF_COLOR_BLUE, GEF_SHADOW_EFFECT);
    private final FXGeometricShape eDotShape = new FXGeometricShape(FXGeometricModel.createDotShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 170.0, 104.0), (Paint)GEF_COLOR_BLUE, GEF_SHADOW_EFFECT);
    private final FXGeometricShape fDotShape = new FXGeometricShape(FXGeometricModel.createDotShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 225.0, 104.0), (Paint)GEF_COLOR_BLUE, GEF_SHADOW_EFFECT);
    private final FXGeometricShape cursorShape = new FXGeometricShape(FXGeometricModel.createCursorShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 227.0, 45.0), Color.WHITE, 2.0, (Paint)Color.BLACK, GEF_SHADOW_EFFECT);
    private List<AbstractFXGeometricElement<? extends IGeometry>> visualShapes;
    private final BooleanProperty snapToGridProperty = new SimpleBooleanProperty((Object)this, "snapToGrid", Boolean.FALSE.booleanValue());

    public static IShape createCursorShapeGeometry() {
        ArrayList<Line> segments = new ArrayList<Line>();
        segments.add(new Line(0.0, 31.0, 12.0, 41.0));
        segments.add(new Line(12.0, 41.0, 12.0, 32.0));
        segments.add(new Line(12.0, 32.0, 26.0, 32.0));
        segments.add(new Line(26.0, 32.0, 26.0, 47.0));
        segments.add(new Line(26.0, 47.0, 17.0, 47.0));
        segments.add(new Line(17.0, 47.0, 28.0, 59.0));
        segments.add(new Line(28.0, 59.0, 40.0, 47.0));
        segments.add(new Line(40.0, 47.0, 30.0, 47.0));
        segments.add(new Line(30.0, 47.0, 30.0, 32.0));
        segments.add(new Line(30.0, 32.0, 46.0, 32.0));
        segments.add(new Line(46.0, 32.0, 46.0, 41.0));
        segments.add(new Line(46.0, 41.0, 57.0, 30.0));
        segments.add(new Line(57.0, 30.0, 46.0, 18.0));
        segments.add(new Line(46.0, 18.0, 46.0, 28.0));
        segments.add(new Line(46.0, 28.0, 30.0, 28.0));
        segments.add(new Line(30.0, 28.0, 30.0, 12.0));
        segments.add(new Line(30.0, 12.0, 39.0, 12.0));
        segments.add(new Line(39.0, 12.0, 28.0, 0.0));
        segments.add(new Line(28.0, 0.0, 17.0, 12.0));
        segments.add(new Line(17.0, 12.0, 26.0, 12.0));
        segments.add(new Line(26.0, 12.0, 26.0, 28.0));
        segments.add(new Line(26.0, 28.0, 12.0, 28.0));
        segments.add(new Line(12.0, 28.0, 12.0, 18.0));
        segments.add(new Line(12.0, 18.0, 0.0, 31.0));
        return new CurvedPolygon(segments);
    }

    public static IShape createDotShapeGeometry() {
        ArrayList<Object> segments = new ArrayList<Object>();
        segments.add(new Line(3.0, 0.0, 0.0, 4.0));
        segments.add(new Line(0.0, 4.0, 4.0, 9.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{4.0, 9.0, 8.0, 5.0, 3.0, 0.0}).toBezier()));
        return new CurvedPolygon(segments);
    }

    public static IShape createEShapeGeometry() {
        ArrayList<Object> segments = new ArrayList<Object>();
        segments.add(new Line(1.0, 10.0, 6.0, 10.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{6.0, 10.0, 5.0, 25.0, 7.0, 52.0, 6.0, 70.0, 6.0, 81.0}).toBezier()));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{6.0, 81.0, 5.0, 81.0, 3.0, 84.0}).toBezier()));
        segments.add(new Line(3.0, 84.0, 3.0, 87.0));
        segments.add(new Line(3.0, 87.0, 64.0, 86.0));
        segments.add(new Line(64.0, 86.0, 65.0, 79.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{65.0, 79.0, 59.0, 81.0, 51.0, 82.0}).toBezier()));
        segments.add(new Line(51.0, 82.0, 12.0, 82.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{12.0, 82.0, 11.0, 56.0, 11.0, 30.0}).toBezier()));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{11.0, 30.0, 27.0, 30.0, 45.0, 31.0}).toBezier()));
        segments.add(new Line(45.0, 31.0, 48.0, 25.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{48.0, 25.0, 35.0, 27.0, 19.0, 27.0, 10.0, 26.0}).toBezier()));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{10.0, 26.0, 10.0, 20.0, 11.0, 10.0}).toBezier()));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{11.0, 10.0, 24.0, 11.0, 31.0, 11.0, 51.0, 12.0}).toBezier()));
        segments.add(new Line(51.0, 12.0, 55.0, 6.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{55.0, 6.0, 45.0, 7.0, 33.0, 8.0, 15.0, 7.0, 7.0, 6.0}).toBezier()));
        segments.add(new Line(7.0, 6.0, 1.0, 10.0));
        return new CurvedPolygon(segments);
    }

    public static IShape createFShapeGeometry() {
        ArrayList<Object> segments = new ArrayList<Object>();
        segments.add(new Line(3.0, 13.0, 3.0, 23.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{3.0, 23.0, 10.0, 25.0, 17.0, 27.0}).toBezier()));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{17.0, 27.0, 16.0, 34.0, 14.0, 44.0, 10.0, 46.0}).toBezier()));
        segments.add(new Line(10.0, 46.0, 10.0, 53.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{10.0, 53.0, 8.0, 70.0, 7.0, 83.0}).toBezier()));
        segments.add(new Line(7.0, 83.0, 13.0, 89.0));
        segments.add(new Line(13.0, 89.0, 17.0, 85.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{17.0, 85.0, 18.0, 69.0, 20.0, 54.0}).toBezier()));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{20.0, 54.0, 32.0, 52.0, 45.0, 50.0}).toBezier()));
        segments.add(new Line(45.0, 50.0, 45.0, 45.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{45.0, 45.0, 33.0, 46.0, 22.0, 46.0}).toBezier()));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{22.0, 46.0, 23.0, 34.0, 25.0, 24.0}).toBezier()));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{25.0, 24.0, 42.0, 24.0, 50.0, 21.0, 59.0, 18.0, 67.0, 16.0}).toBezier()));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{67.0, 16.0, 67.0, 12.0, 64.0, 10.0}).toBezier()));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{64.0, 10.0, 54.0, 14.0, 42.0, 16.0, 28.0, 16.0}).toBezier()));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{28.0, 16.0, 29.0, 11.0, 29.0, 8.0, 31.0, 0.0}).toBezier()));
        segments.add(new Line(31.0, 0.0, 24.0, 3.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{24.0, 3.0, 24.0, 8.0, 23.0, 12.0}).toBezier()));
        segments.add(new Line(23.0, 12.0, 20.0, 11.0));
        segments.add(new Line(20.0, 11.0, 20.0, 15.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{20.0, 15.0, 13.0, 15.0, 3.0, 13.0}).toBezier()));
        return new CurvedPolygon(segments);
    }

    public static IShape createGBaseShapeGeometry() {
        ArrayList<Object> segments = new ArrayList<Object>();
        segments.add(new Line(0.0, 55.0, 10.0, 54.0));
        segments.add(new Line(10.0, 54.0, 13.0, 42.0));
        segments.add(new Line(13.0, 42.0, 23.0, 42.0));
        segments.add(new Line(23.0, 42.0, 25.0, 32.0));
        segments.add(new Line(25.0, 32.0, 37.0, 33.0));
        segments.add(new Line(37.0, 33.0, 42.0, 23.0));
        segments.add(new Line(42.0, 23.0, 54.0, 24.0));
        segments.add(new Line(54.0, 24.0, 57.0, 12.0));
        segments.add(new Line(57.0, 12.0, 65.0, 28.0));
        segments.add(new Line(65.0, 28.0, 60.0, 31.0));
        segments.add(new Line(60.0, 31.0, 57.0, 30.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{57.0, 30.0, 45.0, 35.0, 22.0, 53.0, 14.0, 73.0, 40.0, 69.0}).toBezier()));
        segments.add(new Line(40.0, 69.0, 39.0, 61.0));
        segments.add(new Line(39.0, 61.0, 46.0, 58.0));
        segments.add(new Line(46.0, 58.0, 54.0, 63.0));
        segments.add(new Line(54.0, 63.0, 62.0, 57.0));
        segments.add(new Line(62.0, 57.0, 67.0, 58.0));
        segments.add(new Line(67.0, 58.0, 67.0, 65.0));
        segments.add(new Line(67.0, 65.0, 55.0, 66.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{55.0, 66.0, 53.0, 77.0, 51.0, 86.0}).toBezier()));
        segments.add(new Line(51.0, 86.0, 47.0, 86.0));
        segments.add(new Line(47.0, 86.0, 46.0, 71.0));
        segments.add(new Line(46.0, 71.0, 25.0, 84.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{25.0, 84.0, 17.0, 86.0, 14.0, 84.0}).toBezier()));
        segments.add(new Line(14.0, 84.0, 0.0, 55.0));
        return new CurvedPolygon(segments);
    }

    public static IShape createGMiddleShapeGeometry() {
        ArrayList<Line> segments = new ArrayList<Line>();
        segments.add(new Line(37.0, 48.0, 38.0, 56.0));
        segments.add(new Line(38.0, 56.0, 45.0, 52.0));
        segments.add(new Line(45.0, 52.0, 54.0, 57.0));
        segments.add(new Line(54.0, 57.0, 62.0, 51.0));
        segments.add(new Line(62.0, 51.0, 67.0, 54.0));
        segments.add(new Line(67.0, 54.0, 67.0, 45.0));
        segments.add(new Line(67.0, 45.0, 62.0, 44.0));
        segments.add(new Line(62.0, 44.0, 62.0, 48.0));
        segments.add(new Line(62.0, 48.0, 37.0, 48.0));
        return new CurvedPolygon(segments);
    }

    public static IShape createGTopShapeGeometry() {
        ArrayList<Object> segments = new ArrayList<Object>();
        segments.add(new Line(0.0, 51.0, 8.0, 49.0));
        segments.add(new Line(8.0, 49.0, 9.0, 38.0));
        segments.add(new Line(9.0, 38.0, 20.0, 38.0));
        segments.add(new Line(20.0, 38.0, 24.0, 26.0));
        segments.add(new Line(24.0, 26.0, 35.0, 27.0));
        segments.add(new Line(35.0, 27.0, 39.0, 15.0));
        segments.add(new Line(39.0, 15.0, 51.0, 17.0));
        segments.add(new Line(51.0, 17.0, 54.0, 8.0));
        segments.add(new Line(54.0, 8.0, 52.0, 4.0));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{52.0, 4.0, 40.0, 9.0, 14.0, 28.0, 1.0, 43.0, 0.0, 51.0}).toBezier()));
        return new CurvedPolygon(segments);
    }

    public static IShape createHandleShapeGeometry() {
        ArrayList<BezierCurve> segments = new ArrayList<BezierCurve>();
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{1.0, 1.0, 9.0, 0.0, 17.0, 1.0}).toBezier()));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{17.0, 1.0, 16.0, 8.0, 17.0, 16.0}).toBezier()));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{17.0, 16.0, 7.0, 15.0, 1.0, 16.0}).toBezier()));
        segments.addAll(Arrays.asList(PolyBezier.interpolateCubic((double[])new double[]{1.0, 16.0, 0.0, 8.0, 1.0, 1.0}).toBezier()));
        return new CurvedPolygon(segments);
    }

    private static Effect createShadowEffect() {
        DropShadow outerShadow = new DropShadow();
        outerShadow.setRadius(3.0);
        outerShadow.setSpread(0.2);
        outerShadow.setOffsetX(3.0);
        outerShadow.setOffsetY(3.0);
        outerShadow.setColor(new Color(0.3, 0.3, 0.3, 1.0));
        Light.Distant light = new Light.Distant();
        light.setAzimuth(-135.0);
        Lighting l = new Lighting();
        l.setLight((Light)light);
        l.setSurfaceScale(3.0);
        Blend effects = new Blend(BlendMode.MULTIPLY);
        effects.setTopInput((Effect)l);
        effects.setBottomInput((Effect)outerShadow);
        return effects;
    }

    public FXGeometricModel() {
        this.selectionBoundsTopLine.addSourceAnchorage(this.topLeftSelectionHandle);
        this.selectionBoundsTopLine.addTargetAnchorage(this.topRightSelectionHandle);
        this.selectionBoundsLeftLine.addSourceAnchorage(this.topLeftSelectionHandle);
        this.selectionBoundsLeftLine.addTargetAnchorage(this.bottomLeftSelectionHandle);
        this.selectionBoundsBottomLine.addSourceAnchorage(this.bottomLeftSelectionHandle);
        this.selectionBoundsBottomLine.addTargetAnchorage(this.bottomRightSelectionHandle);
        this.selectionBoundsRightLine.addSourceAnchorage(this.topRightSelectionHandle);
        this.selectionBoundsRightLine.addTargetAnchorage(this.bottomRightSelectionHandle);
        this.gDotShape.addAnchorage(this.gBaseShape);
        this.gMiddleShape.addAnchorage(this.gBaseShape);
        this.gTopShape.addAnchorage(this.gBaseShape);
        this.eDotShape.addAnchorage(this.eShape);
        this.fDotShape.addAnchorage(this.fShape);
        this.initVisualShapes();
    }

    public List<AbstractFXGeometricElement<? extends IGeometry>> getShapeVisuals() {
        return this.visualShapes;
    }

    private void initVisualShapes() {
        this.visualShapes = new ArrayList<AbstractFXGeometricElement<? extends IGeometry>>();
        this.visualShapes.add(this.selectionBoundsTopLine);
        this.visualShapes.add(this.selectionBoundsLeftLine);
        this.visualShapes.add(this.selectionBoundsBottomLine);
        this.visualShapes.add(this.selectionBoundsRightLine);
        this.visualShapes.add(this.topLeftSelectionHandle);
        this.visualShapes.add(this.topRightSelectionHandle);
        this.visualShapes.add(this.bottomLeftSelectionHandle);
        this.visualShapes.add(this.bottomRightSelectionHandle);
        this.visualShapes.add(this.gTopShape);
        this.visualShapes.add(this.gMiddleShape);
        this.visualShapes.add(this.gBaseShape);
        this.visualShapes.add(this.eShape);
        this.visualShapes.add(this.fShape);
        this.visualShapes.add(this.gDotShape);
        this.visualShapes.add(this.eDotShape);
        this.visualShapes.add(this.fDotShape);
        this.visualShapes.add(this.cursorShape);
    }

    public boolean isSnapToGrid() {
        return this.snapToGridProperty.get();
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.snapToGridProperty.set(snapToGrid);
    }

    public BooleanProperty snapToGridProperty() {
        return this.snapToGridProperty;
    }
}

