/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.policies;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Map;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Paint;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.collections.ObservableMultiset;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricCurve;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricModel;
import org.eclipse.gef4.mvc.examples.logo.parts.FXGeometricCurvePart;
import org.eclipse.gef4.mvc.examples.logo.parts.FXGeometricModelPart;
import org.eclipse.gef4.mvc.examples.logo.parts.FXGeometricShapePart;
import org.eclipse.gef4.mvc.fx.parts.FXCircleSegmentHandlePart;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnDragPolicy;
import org.eclipse.gef4.mvc.fx.tools.FXClickDragTool;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.operations.DeselectOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;
import org.eclipse.gef4.mvc.policies.CreationPolicy;

public class FXCreateCurveOnDragPolicy
extends AbstractFXInteractionPolicy
implements IFXOnDragPolicy {
    private FXCircleSegmentHandlePart bendTargetPart;
    private Map<AdapterKey<? extends IFXOnDragPolicy>, IFXOnDragPolicy> dragPolicies;
    private FXGeometricCurvePart curvePart;

    public void drag(MouseEvent event, Dimension delta) {
        if (this.bendTargetPart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IFXOnDragPolicy dragPolicy : this.dragPolicies.values()) {
                dragPolicy.drag(event, delta);
            }
        }
    }

    public void dragAborted() {
        if (this.bendTargetPart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IFXOnDragPolicy dragPolicy : this.dragPolicies.values()) {
                dragPolicy.dragAborted();
            }
        }
        this.restoreRefreshVisuals((IVisualPart)this.curvePart);
        this.curvePart = null;
        this.bendTargetPart = null;
        this.dragPolicies = null;
    }

    protected FXCircleSegmentHandlePart findBendTargetPart(FXGeometricCurvePart curvePart, EventTarget eventTarget) {
        ObservableMultiset anchoreds = curvePart.getAnchoredsUnmodifiable();
        for (IVisualPart anchored : anchoreds) {
            FXCircleSegmentHandlePart circleSegmentHandlePart;
            if (!(anchored instanceof FXCircleSegmentHandlePart) || (circleSegmentHandlePart = (FXCircleSegmentHandlePart)anchored).getSegmentParameter() != 1.0) continue;
            return circleSegmentHandlePart;
        }
        throw new IllegalStateException("Cannot find bend target part.");
    }

    protected Point getLocation(MouseEvent e) {
        Point2D location = ((FXViewer)this.getHost().getRoot().getViewer()).getCanvas().getContentGroup().sceneToLocal(e.getSceneX(), e.getSceneY());
        return new Point(location.getX(), location.getY());
    }

    protected FXGeometricShapePart getShapePart() {
        return (FXGeometricShapePart)((Object)this.getHost().getAnchoragesUnmodifiable().keySet().iterator().next());
    }

    public void hideIndicationCursor() {
    }

    public void press(MouseEvent event) {
        IVisualPart modelPart = (IVisualPart)this.getHost().getRoot().getChildrenUnmodifiable().get(0);
        if (!(modelPart instanceof FXGeometricModelPart)) {
            throw new IllegalStateException("Cannot find FXGeometricModelPart.");
        }
        FXGeometricCurve curve = new FXGeometricCurve(new Point[]{new Point(), new Point()}, (Paint)FXGeometricModel.GEF_COLOR_GREEN, 3.5, FXGeometricModel.GEF_DASH_PATTERN, null);
        curve.addSourceAnchorage(this.getShapePart().getContent());
        CreationPolicy creationPolicy = (CreationPolicy)this.getHost().getRoot().getAdapter((TypeToken)new TypeToken<CreationPolicy<Node>>(){});
        this.init((AbstractTransactionPolicy)creationPolicy);
        this.curvePart = (FXGeometricCurvePart)creationPolicy.create((Object)curve, (IContentPart)((FXGeometricModelPart)modelPart), (SetMultimap)HashMultimap.create());
        this.commit((AbstractTransactionPolicy)creationPolicy);
        this.storeAndDisableRefreshVisuals((IVisualPart)this.curvePart);
        ((Connection)this.curvePart.getVisual()).setEndPoint(this.getLocation(event));
        ArrayList toBeDeselected = new ArrayList(((SelectionModel)this.getHost().getRoot().getViewer().getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).getSelectionUnmodifiable());
        toBeDeselected.remove((Object)this.curvePart);
        DeselectOperation deselectOperation = new DeselectOperation(this.getHost().getRoot().getViewer(), toBeDeselected);
        try {
            this.getHost().getRoot().getViewer().getDomain().execute((ITransactionalOperation)deselectOperation);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.bendTargetPart = this.findBendTargetPart(this.curvePart, event.getTarget());
        if (this.bendTargetPart != null) {
            this.dragPolicies = this.bendTargetPart.getAdapters(FXClickDragTool.ON_DRAG_POLICY_KEY);
        }
        if (this.dragPolicies != null) {
            for (IFXOnDragPolicy dragPolicy : this.dragPolicies.values()) {
                dragPolicy.press(event);
            }
        }
    }

    public void release(MouseEvent e, Dimension delta) {
        if (this.bendTargetPart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IFXOnDragPolicy dragPolicy : this.dragPolicies.values()) {
                dragPolicy.release(e, delta);
            }
        }
        this.restoreRefreshVisuals((IVisualPart)this.curvePart);
        this.curvePart = null;
        this.bendTargetPart = null;
        this.dragPolicies = null;
    }

    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }
}

