/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.adapt.inject;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.MembersInjector;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.adapt.inject.AdapterInjector;
import org.eclipse.gef4.common.adapt.inject.AdapterMap;
import org.eclipse.gef4.common.adapt.inject.InjectAdapters;

public class AdaptableTypeListener
implements TypeListener {
    private Injector injector;
    private Set<AdapterInjector> nonInjectedMemberInjectors = new HashSet<AdapterInjector>();

    @Inject
    public void setInjector(Injector injector) {
        this.injector = injector;
        for (AdapterInjector memberInjector : this.nonInjectedMemberInjectors) {
            injector.injectMembers((Object)memberInjector);
        }
        this.nonInjectedMemberInjectors.clear();
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        if (IAdaptable.class.isAssignableFrom(type.getRawType())) {
            Method[] methodArray = type.getRawType().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                int i = 0;
                while (i < method.getParameterAnnotations().length) {
                    AdapterMap adapterMapAnnotation = this.getAnnotation(method.getParameterAnnotations()[i], AdapterMap.class);
                    if (adapterMapAnnotation != null) {
                        encounter.addError("@AdapterMap annotation may only be used in adapter map bindings, not to mark an injection point. Annotate method with @InjectAdapters instead.", new Object[]{method});
                    }
                    ++i;
                }
                if (this.eligibleForAdapterInjection(method)) {
                    Inject injectAnnotation = method.getAnnotation(Inject.class);
                    if (injectAnnotation != null) {
                        encounter.addError("To prevent that Guice member injection interferes with adapter injection, no @Inject annotation may be used on a method that provides an @InjectAdapters annotation.", new Object[0]);
                    }
                    AdapterInjector membersInjector = new AdapterInjector(method);
                    if (this.injector != null) {
                        this.injector.injectMembers((Object)membersInjector);
                    } else {
                        this.nonInjectedMemberInjectors.add(membersInjector);
                    }
                    encounter.register((MembersInjector)membersInjector);
                }
                ++n2;
            }
        }
    }

    protected boolean eligibleForAdapterInjection(Method method) {
        if (method.getAnnotation(InjectAdapters.class) != null) {
            return method.getName().equals("setAdapter") && method.getParameterTypes().length == 3 && method.getParameterTypes()[0].equals(TypeToken.class) && method.getParameterTypes()[1].equals(Object.class) && method.getParameterTypes()[2].equals(String.class);
        }
        return false;
    }

    private <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> annotationType) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (annotationType.isAssignableFrom(a.annotationType())) {
                return (T)a;
            }
            ++n2;
        }
        return null;
    }
}

