/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import org.eclipse.gef4.common.activate.ActivatableSupport;
import org.eclipse.gef4.common.activate.IActivatable;
import org.eclipse.gef4.mvc.domain.IDomain;
import org.eclipse.gef4.mvc.policies.IPolicy;
import org.eclipse.gef4.mvc.tools.ITool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public abstract class AbstractTool<VR>
implements ITool<VR> {
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this);
    private ReadOnlyObjectWrapper<IDomain<VR>> domainProperty = new ReadOnlyObjectWrapper();
    private Map<IViewer<VR>, List<IPolicy<VR>>> activePolicies = new IdentityHashMap<IViewer<VR>, List<IPolicy<VR>>>();

    public void activate() {
        if (this.getDomain() == null) {
            throw new IllegalStateException("The IEditDomain has to be set via setDomain(IDomain) before activation.");
        }
        this.acs.activate();
        this.registerListeners();
    }

    public ReadOnlyBooleanProperty activeProperty() {
        return this.acs.activeProperty();
    }

    public ReadOnlyObjectProperty<IDomain<VR>> adaptableProperty() {
        return this.domainProperty.getReadOnlyProperty();
    }

    protected void clearActivePolicies(IViewer<VR> viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException("The given viewer may not be null.");
        }
        this.activePolicies.remove(viewer);
    }

    public void deactivate() {
        this.unregisterListeners();
        this.acs.deactivate();
    }

    @Override
    public List<? extends IPolicy<VR>> getActivePolicies(IViewer<VR> viewer) {
        if (this.activePolicies.containsKey(viewer)) {
            return Collections.unmodifiableList(this.activePolicies.get(viewer));
        }
        return Collections.emptyList();
    }

    public IDomain<VR> getAdaptable() {
        return (IDomain)this.domainProperty.get();
    }

    @Override
    public IDomain<VR> getDomain() {
        return this.getAdaptable();
    }

    public boolean isActive() {
        return this.acs.isActive();
    }

    protected void registerListeners() {
    }

    protected void setActivePolicies(IViewer<VR> viewer, Collection<? extends IPolicy<VR>> activePolicies) {
        if (viewer == null) {
            throw new IllegalArgumentException("The given viewer may not be null.");
        }
        if (activePolicies == null) {
            throw new IllegalArgumentException("The given activePolicies may not be null.");
        }
        this.clearActivePolicies(viewer);
        this.activePolicies.put(viewer, new ArrayList<IPolicy<VR>>(activePolicies));
    }

    public void setAdaptable(IDomain<VR> adaptable) {
        if (this.isActive()) {
            throw new IllegalStateException("The reference to the IDomain may not be changed while the tool is active. Please deactivate the tool before setting the IEditDomain and re-activate it afterwards.");
        }
        this.domainProperty.set(adaptable);
    }

    protected void unregisterListeners() {
    }
}

