/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.policies;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.nodes.GeometryNode;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricShape;
import org.eclipse.gef4.mvc.examples.logo.parts.FXGeometricModelPart;
import org.eclipse.gef4.mvc.examples.logo.parts.FXGeometricShapePart;
import org.eclipse.gef4.mvc.examples.logo.parts.PaletteElementPart;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnDragPolicy;
import org.eclipse.gef4.mvc.fx.tools.FXClickDragTool;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.operations.DeselectOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;
import org.eclipse.gef4.mvc.policies.CreationPolicy;

public class CreateAndTranslateOnDragPolicy
extends AbstractFXInteractionPolicy
implements IFXOnDragPolicy {
    private FXGeometricShapePart createdShapePart;
    private Map<AdapterKey<? extends IFXOnDragPolicy>, IFXOnDragPolicy> dragPolicies;

    public void drag(MouseEvent event, Dimension delta) {
        if (this.createdShapePart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IFXOnDragPolicy dragPolicy : this.dragPolicies.values()) {
                dragPolicy.drag(event, delta);
            }
        }
    }

    public void dragAborted() {
        if (this.createdShapePart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IFXOnDragPolicy dragPolicy : this.dragPolicies.values()) {
                dragPolicy.dragAborted();
            }
        }
        this.createdShapePart = null;
        this.dragPolicies = null;
    }

    protected FXViewer getContentViewer() {
        Map viewers = this.getHost().getRoot().getViewer().getDomain().getViewers();
        for (Map.Entry e : viewers.entrySet()) {
            if (!"contentViewer".equals(((AdapterKey)e.getKey()).getRole())) continue;
            return (FXViewer)e.getValue();
        }
        throw new IllegalStateException("Cannot find content viewer!");
    }

    public PaletteElementPart getHost() {
        return (PaletteElementPart)super.getHost();
    }

    protected Point getLocation(MouseEvent e) {
        Point2D location = ((FXViewer)this.getHost().getRoot().getViewer()).getCanvas().getContentGroup().sceneToLocal(e.getSceneX(), e.getSceneY());
        return new Point(location.getX(), location.getY());
    }

    public void hideIndicationCursor() {
    }

    public void press(MouseEvent event) {
        IRootPart contentRoot = this.getContentViewer().getRootPart();
        IVisualPart modelPart = (IVisualPart)contentRoot.getChildrenUnmodifiable().get(0);
        if (!(modelPart instanceof FXGeometricModelPart)) {
            throw new IllegalStateException("Cannot find FXGeometricModelPart.");
        }
        FXGeometricShape copy = this.getHost().getContent().getCopy();
        Point2D localToScene = ((GeometryNode)this.getHost().getVisual()).localToScene(0.0, 0.0);
        Point2D originInModel = ((Node)modelPart.getVisual()).sceneToLocal(localToScene.getX(), localToScene.getY());
        double[] matrix = copy.getTransform().getMatrix();
        copy.getTransform().setTransform(matrix[0], matrix[1], matrix[2], matrix[3], originInModel.getX(), originInModel.getY());
        CreationPolicy creationPolicy = (CreationPolicy)contentRoot.getAdapter((TypeToken)new TypeToken<CreationPolicy<Node>>(){});
        this.init((AbstractTransactionPolicy)creationPolicy);
        this.createdShapePart = (FXGeometricShapePart)creationPolicy.create((Object)copy, (IContentPart)((FXGeometricModelPart)modelPart), (SetMultimap)HashMultimap.create());
        this.commit((AbstractTransactionPolicy)creationPolicy);
        this.storeAndDisableRefreshVisuals((IVisualPart)this.createdShapePart);
        ArrayList toBeDeselected = new ArrayList(((SelectionModel)this.getHost().getRoot().getViewer().getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).getSelectionUnmodifiable());
        toBeDeselected.remove((Object)this.createdShapePart);
        DeselectOperation deselectOperation = new DeselectOperation(this.getHost().getRoot().getViewer(), toBeDeselected);
        try {
            this.getHost().getRoot().getViewer().getDomain().execute((ITransactionalOperation)deselectOperation);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.dragPolicies = this.createdShapePart.getAdapters(FXClickDragTool.ON_DRAG_POLICY_KEY);
        if (this.dragPolicies != null) {
            for (IFXOnDragPolicy dragPolicy : this.dragPolicies.values()) {
                dragPolicy.press(event);
            }
        }
    }

    public void release(MouseEvent e, Dimension delta) {
        if (this.createdShapePart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IFXOnDragPolicy dragPolicy : this.dragPolicies.values()) {
                dragPolicy.release(e, delta);
            }
        }
        this.restoreRefreshVisuals((IVisualPart)this.createdShapePart);
        this.createdShapePart = null;
        this.dragPolicies = null;
    }

    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }
}

