/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.nodes.GeometryNode;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXFeedbackPart;
import org.eclipse.gef4.mvc.fx.parts.FXDefaultSelectionFeedbackPartFactory;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXSelectionFeedbackPart
extends AbstractFXFeedbackPart<GeometryNode<IGeometry>> {
    protected static final double DEFAULT_STROKE_WIDTH = 1.5;
    private Provider<? extends IGeometry> feedbackGeometryProvider;

    protected GeometryNode<IGeometry> createVisual() {
        GeometryNode feedbackVisual = new GeometryNode();
        feedbackVisual.setFill((Paint)Color.TRANSPARENT);
        feedbackVisual.setMouseTransparent(true);
        feedbackVisual.setManaged(false);
        feedbackVisual.setStrokeWidth(1.5);
        return feedbackVisual;
    }

    public void doRefreshVisual(GeometryNode<IGeometry> visual) {
        Set anchorages = this.getAnchoragesUnmodifiable().keySet();
        if (anchorages.isEmpty()) {
            return;
        }
        IGeometry feedbackGeometry = this.getFeedbackGeometry();
        if (feedbackGeometry == null) {
            return;
        }
        visual.setGeometry(feedbackGeometry);
        if (feedbackGeometry instanceof ICurve) {
            visual.setStrokeType(StrokeType.CENTERED);
        } else {
            visual.setStrokeType(StrokeType.OUTSIDE);
        }
        IVisualPart anchorage = (IVisualPart)anchorages.iterator().next();
        IViewer viewer = anchorage.getRoot().getViewer();
        ObservableList selected = ((SelectionModel)viewer.getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).getSelectionUnmodifiable();
        if (selected.get(0) == anchorage) {
            visual.setStroke((Paint)this.getPrimarySelectionColor());
            visual.toFront();
        } else {
            visual.setStroke((Paint)this.getSecondarySelectionColor());
        }
    }

    protected IGeometry getFeedbackGeometry() {
        return NodeUtils.sceneToLocal((Node)((GeometryNode)this.getVisual()).getParent(), (IGeometry)((IGeometry)this.feedbackGeometryProvider.get()));
    }

    protected Color getPrimarySelectionColor() {
        Provider connectedColorProvider = (Provider)this.getViewer().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Color>>(){}, (String)"PRIMARY_SELECTION_FEEDBACK_COLOR_PROVIDER"));
        return connectedColorProvider == null ? FXDefaultSelectionFeedbackPartFactory.DEFAULT_PRIMARY_SELECTION_FEEDBACK_COLOR : (Color)connectedColorProvider.get();
    }

    protected Color getSecondarySelectionColor() {
        Provider connectedColorProvider = (Provider)this.getViewer().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Color>>(){}, (String)"SECONDARY_SELECTION_FEEDBACK_COLOR_PROVIDER"));
        return connectedColorProvider == null ? FXDefaultSelectionFeedbackPartFactory.DEFAULT_SECONDARY_SELECTION_FEEDBACK_COLOR : (Color)connectedColorProvider.get();
    }

    public void setGeometryProvider(Provider<? extends IGeometry> geometryProvider) {
        this.feedbackGeometryProvider = geometryProvider;
    }
}

