/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.layout.ILayoutFilter;

public class LayoutContext {
    public static final String LAYOUT_ALGORITHM_PROPERTY = "layoutAlgorithm";
    private ObjectProperty<ILayoutAlgorithm> layoutAlgorithmProperty = new SimpleObjectProperty((Object)this, "layoutAlgorithm");
    private Graph graph;
    private final List<Runnable> postLayoutPass = new ArrayList<Runnable>();
    private final List<Runnable> preLayoutPass = new ArrayList<Runnable>();
    private final List<ILayoutFilter> layoutFilters = new ArrayList<ILayoutFilter>();

    public void addLayoutFilter(ILayoutFilter layoutFilter) {
        this.layoutFilters.add(layoutFilter);
    }

    public void applyLayout(boolean clear) {
        ILayoutAlgorithm layoutAlgorithm = (ILayoutAlgorithm)this.layoutAlgorithmProperty.get();
        if (layoutAlgorithm != null) {
            this.preLayout();
            layoutAlgorithm.setLayoutContext(this);
            layoutAlgorithm.applyLayout(clear);
            this.postLayout();
        }
    }

    public void postLayout() {
        for (Runnable r : new ArrayList<Runnable>(this.postLayoutPass)) {
            r.run();
        }
    }

    public void preLayout() {
        for (Runnable r : this.preLayoutPass) {
            r.run();
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        if (graph == null) {
            graph = new Graph();
        }
        this.graph = graph;
    }

    public Node[] getNodes() {
        return (Node[])this.graph.getNodes().toArray((Object[])new Node[0]);
    }

    public Edge[] getEdges() {
        return (Edge[])this.graph.getEdges().toArray((Object[])new Edge[0]);
    }

    public ILayoutAlgorithm getLayoutAlgorithm() {
        return (ILayoutAlgorithm)this.layoutAlgorithmProperty.get();
    }

    public boolean isLayoutIrrelevant(Edge edge) {
        for (ILayoutFilter filter : this.layoutFilters) {
            if (!filter.isLayoutIrrelevant(edge)) continue;
            return true;
        }
        return false;
    }

    public boolean isLayoutIrrelevant(Node nodeLayout) {
        for (ILayoutFilter filter : this.layoutFilters) {
            if (!filter.isLayoutIrrelevant(nodeLayout)) continue;
            return true;
        }
        return false;
    }

    public ObjectProperty<ILayoutAlgorithm> layoutAlgorithmProperty() {
        return this.layoutAlgorithmProperty;
    }

    public void removeLayoutFilter(ILayoutFilter layoutFilter) {
        this.layoutFilters.remove(layoutFilter);
    }

    public void schedulePostLayoutPass(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable may not be null.");
        }
        if (!this.postLayoutPass.contains(runnable)) {
            this.postLayoutPass.add(runnable);
        }
    }

    public void schedulePreLayoutPass(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable may not be null.");
        }
        if (!this.preLayoutPass.contains(runnable)) {
            this.preLayoutPass.add(runnable);
        }
    }

    public void setLayoutAlgorithm(ILayoutAlgorithm algorithm) {
        this.layoutAlgorithmProperty.set((Object)algorithm);
    }

    public void unschedulePostLayoutPass(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable may not be null.");
        }
        if (this.postLayoutPass.contains(runnable)) {
            this.postLayoutPass.remove(runnable);
        }
    }

    public void unschedulePreLayoutPass(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable may not be null.");
        }
        if (this.preLayoutPass.contains(runnable)) {
            this.preLayoutPass.remove(runnable);
        }
    }
}

