/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.domain;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.collections.ObservableMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef4.common.activate.ActivatableSupport;
import org.eclipse.gef4.common.activate.IActivatable;
import org.eclipse.gef4.common.adapt.AdaptableSupport;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.adapt.inject.AdaptableScopes;
import org.eclipse.gef4.common.adapt.inject.InjectAdapters;
import org.eclipse.gef4.mvc.domain.IDomain;
import org.eclipse.gef4.mvc.operations.AbstractCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.tools.ITool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public abstract class AbstractDomain<VR>
implements IDomain<VR> {
    private static final int DEFAULT_UNDO_LIMIT = 128;
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this);
    private AdaptableSupport<IDomain<VR>> ads = new AdaptableSupport((IAdaptable)this);
    private IOperationHistory operationHistory;
    private IUndoContext undoContext;
    private AbstractCompositeOperation transaction;
    private Set<ITool<VR>> transactionContext = new HashSet<ITool<VR>>();
    private IOperationHistoryListener operationHistoryListener = new IOperationHistoryListener(){

        public void historyNotification(OperationHistoryEvent event) {
            if (event.getEventType() == 3 && !AbstractDomain.this.transactionContext.isEmpty() && AbstractDomain.this.transaction != null) {
                if (AbstractDomain.this.transaction.getOperations().isEmpty()) {
                    for (ITool tool : AbstractDomain.this.transactionContext) {
                        AbstractDomain.this.closeExecutionTransaction(tool);
                    }
                } else {
                    throw new IllegalStateException("Cannot perform UNDO while a currently open execution transaction contains operations.");
                }
            }
        }
    };

    public AbstractDomain() {
        AdaptableScopes.enter((IAdaptable)this);
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        });
    }

    public void activate() {
        if (!this.acs.isActive()) {
            this.acs.activate();
        }
    }

    public ReadOnlyBooleanProperty activeProperty() {
        return this.acs.activeProperty();
    }

    public ReadOnlyMapProperty<AdapterKey<?>, Object> adaptersProperty() {
        return this.ads.adaptersProperty();
    }

    protected void applyUndoContext(ITransactionalOperation operation) {
        operation.addContext(this.getUndoContext());
    }

    @Override
    public void closeExecutionTransaction(ITool<VR> tool) {
        if (!this.transactionContext.contains(tool)) {
            return;
        }
        if (this.transactionContext.size() == 1 && this.transactionContext.contains(tool)) {
            if (this.transaction == null) {
                throw new IllegalStateException("No transaction is currently active, while the transaction context sill contained tool " + tool + ".");
            }
            List<ITransactionalOperation> operations = this.transaction.getOperations();
            if (!operations.isEmpty()) {
                StringBuffer label = new StringBuffer();
                int operationCount = operations.size();
                int i = 0;
                while (i < operationCount) {
                    label.append(operations.get(i).getLabel());
                    if (operations.size() - 1 > i) {
                        label.append(", ");
                    }
                    ++i;
                }
                this.transaction.setLabel(label.toString());
                this.applyUndoContext(this.transaction);
                this.getOperationHistory().add((IUndoableOperation)this.transaction);
            }
            this.transaction = null;
        }
        this.transactionContext.remove(tool);
    }

    protected AbstractCompositeOperation createExecutionTransaction() {
        ReverseUndoCompositeOperation transaction = new ReverseUndoCompositeOperation(Long.toString(System.currentTimeMillis()));
        return transaction;
    }

    public void deactivate() {
        if (this.acs.isActive()) {
            this.acs.deactivate();
        }
    }

    public void dispose() {
        this.operationHistory.dispose(this.undoContext, true, true, true);
        AdaptableScopes.leave((IAdaptable)this);
        this.ads.dispose();
    }

    @Override
    public void execute(ITransactionalOperation operation) throws ExecutionException {
        if (operation instanceof AbstractCompositeOperation) {
            operation = ((AbstractCompositeOperation)operation).unwrap(true);
        }
        if (operation.isNoOp()) {
            return;
        }
        if (!operation.canExecute()) {
            throw new IllegalArgumentException("Operation cannot be executed.");
        }
        if (this.transaction != null) {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
            this.transaction.add(operation);
        } else {
            this.applyUndoContext(operation);
            this.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
    }

    public <T> T getAdapter(AdapterKey<T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> T getAdapter(Class<T> classKey) {
        return (T)this.ads.getAdapter(classKey);
    }

    public <T> T getAdapter(TypeToken<T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> AdapterKey<T> getAdapterKey(T adapter) {
        return this.ads.getAdapterKey(adapter);
    }

    public ObservableMap<AdapterKey<?>, Object> getAdapters() {
        return this.ads.getAdapters();
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(Class<? super T> classKey) {
        return this.ads.getAdapters(classKey);
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(TypeToken<? super T> key) {
        return this.ads.getAdapters(key);
    }

    @Override
    public IOperationHistory getOperationHistory() {
        return this.operationHistory;
    }

    @Override
    public Map<AdapterKey<? extends ITool<VR>>, ITool<VR>> getTools() {
        return this.ads.getAdapters(ITool.class);
    }

    @Override
    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    @Override
    public Map<AdapterKey<? extends IViewer<VR>>, IViewer<VR>> getViewers() {
        return this.ads.getAdapters(IViewer.class);
    }

    public boolean isActive() {
        return this.acs.isActive();
    }

    protected boolean isExecutionTransactionOpen() {
        return this.transaction != null;
    }

    @Override
    public boolean isExecutionTransactionOpen(ITool<VR> tool) {
        return this.transactionContext.contains(tool);
    }

    @Override
    public void openExecutionTransaction(ITool<VR> tool) {
        if (this.transactionContext.contains(tool)) {
            return;
        }
        this.transactionContext.add(tool);
        if (this.transactionContext.size() == 1 && this.transactionContext.contains(tool)) {
            if (this.transaction != null) {
                throw new IllegalStateException("A transaction is already active, while this is the first tool within the transaction context.");
            }
            this.transaction = this.createExecutionTransaction();
        }
    }

    public <T> void setAdapter(T adapter) {
        this.ads.setAdapter(adapter);
    }

    public <T> void setAdapter(T adapter, String role) {
        this.ads.setAdapter(adapter, role);
    }

    public <T> void setAdapter(TypeToken<T> adapterType, T adapter) {
        this.ads.setAdapter(adapterType, adapter);
    }

    @InjectAdapters
    public <T> void setAdapter(TypeToken<T> adapterType, T adapter, String role) {
        this.ads.setAdapter(adapterType, adapter, role);
    }

    @Inject
    public void setOperationHistory(IOperationHistory operationHistory) {
        if (this.operationHistory != null && this.operationHistory != operationHistory) {
            this.operationHistory.removeOperationHistoryListener(this.operationHistoryListener);
        }
        if (this.operationHistory != operationHistory) {
            this.operationHistory = operationHistory;
            if (this.operationHistory != null) {
                this.operationHistory.addOperationHistoryListener(this.operationHistoryListener);
                if (this.undoContext != null) {
                    this.operationHistory.setLimit(this.undoContext, 128);
                }
            }
        }
    }

    @Inject
    public void setUndoContext(IUndoContext undoContext) {
        this.undoContext = undoContext;
        if (this.operationHistory != null && undoContext != null) {
            this.operationHistory.setLimit(undoContext, 128);
        }
    }

    public <T> void unsetAdapter(T adapter) {
        this.ads.unsetAdapter(adapter);
    }
}

