/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.swt.canvas;

import java.lang.reflect.Method;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swt.FXCanvas;
import javafx.embed.swt.SWTFXUtils;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Window;
import org.eclipse.gef4.common.reflect.ReflectionUtils;
import org.eclipse.gef4.fx.swt.gestures.SWT2FXEventConverter;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;

public class FXCanvasEx
extends FXCanvas {
    private SWT2FXEventConverter gestureConverter;
    private ChangeListener<Cursor> cursorChangeListener = new ChangeListener<Cursor>(){

        public void changed(ObservableValue<? extends Cursor> observable, Cursor oldCursor, Cursor newCursor) {
            if (newCursor instanceof ImageCursor) {
                ImageData imageData = SWTFXUtils.fromFXImage((Image)((ImageCursor)newCursor).getImage(), null);
                double hotspotX = ((ImageCursor)newCursor).getHotspotX();
                double hotspotY = ((ImageCursor)newCursor).getHotspotY();
                org.eclipse.swt.graphics.Cursor swtCursor = new org.eclipse.swt.graphics.Cursor((Device)FXCanvasEx.this.getDisplay(), imageData, (int)hotspotX, (int)hotspotY);
                try {
                    Method currentCursorFrameAccessor = Cursor.class.getDeclaredMethod("getCurrentFrame", new Class[0]);
                    currentCursorFrameAccessor.setAccessible(true);
                    Object currentCursorFrame = currentCursorFrameAccessor.invoke((Object)newCursor, new Object[0]);
                    Method platformCursorProvider = currentCursorFrame.getClass().getMethod("setPlatforCursor", Class.class, Object.class);
                    platformCursorProvider.setAccessible(true);
                    platformCursorProvider.invoke(currentCursorFrame, org.eclipse.swt.graphics.Cursor.class, swtCursor);
                }
                catch (Exception e) {
                    System.err.println("Failed to set platform cursor on the current cursor frame.");
                    e.printStackTrace();
                }
            }
        }
    };
    private TraverseListener eclipseUiTraversalListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
            if ((e.detail == 16 || e.detail == 8) && (e.stateMask & 0x40000) != 0) {
                e.doit = true;
            }
        }
    };

    public FXCanvasEx(Composite parent, int style) {
        super(parent, style);
        this.addTraverseListener(this.eclipseUiTraversalListener);
        this.gestureConverter = new SWT2FXEventConverter(this);
    }

    public void dispose() {
        this.gestureConverter.dispose();
        super.dispose();
    }

    public Window getStage() {
        return (Window)ReflectionUtils.getPrivateFieldValue((Object)((Object)this), (String)"stage");
    }

    public void setScene(Scene newScene) {
        Scene oldScene = this.getScene();
        if (oldScene != null) {
            oldScene.cursorProperty().removeListener(this.cursorChangeListener);
        }
        super.setScene(newScene);
        if (newScene != null) {
            newScene.cursorProperty().addListener(this.cursorChangeListener);
        }
    }
}

