/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.operations;

import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.fx.nodes.InfiniteCanvas;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;

public class FXChangeViewportOperation
extends AbstractOperation
implements ITransactionalOperation {
    private InfiniteCanvas canvas;
    private double initialWidth;
    private double newWidth;
    private double initialHeight;
    private double newHeight;
    private AffineTransform initialContentTransform;
    private AffineTransform newContentTransform;
    private double initialHorizontalScrollOffset;
    private double newHorizontalScrollOffset;
    private double initialVerticalScrollOffset;
    private double newVerticalScrollOffset;

    public FXChangeViewportOperation(InfiniteCanvas canvas) {
        super("Change Viewport");
        this.readViewport(canvas);
    }

    public FXChangeViewportOperation(InfiniteCanvas canvas, AffineTransform newContentTransform) {
        this(canvas);
        this.newContentTransform = newContentTransform;
    }

    public FXChangeViewportOperation(InfiniteCanvas canvas, double newHorizontalScrollOffset, double newVerticalScrollOffset) {
        this(canvas);
        this.newHorizontalScrollOffset = newHorizontalScrollOffset;
        this.newVerticalScrollOffset = newVerticalScrollOffset;
    }

    public FXChangeViewportOperation(InfiniteCanvas canvas, double newHorizontalScrollOffset, double newVerticalScrollOffset, AffineTransform newContentTransform) {
        this(canvas);
        this.newContentTransform = newContentTransform;
        this.newHorizontalScrollOffset = newHorizontalScrollOffset;
        this.newVerticalScrollOffset = newVerticalScrollOffset;
    }

    public FXChangeViewportOperation(InfiniteCanvas canvas, double newHorizontalScrollOffset, double newVerticalScrollOffset, double newWidth, double newHeight, AffineTransform newContentTransform) {
        this(canvas);
        this.newWidth = newWidth;
        this.newHeight = newHeight;
        this.newContentTransform = newContentTransform;
        this.newHorizontalScrollOffset = newHorizontalScrollOffset;
        this.newVerticalScrollOffset = newVerticalScrollOffset;
    }

    public void concatenateToNewContentTransform(AffineTransform t) {
        this.newContentTransform.concatenate(t);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.canvas.getPrefWidth() != this.newWidth) {
            this.canvas.setPrefWidth(this.newWidth);
        }
        if (this.canvas.getPrefHeight() != this.newHeight) {
            this.canvas.setPrefHeight(this.newHeight);
        }
        Affine newContentAffine = Geometry2FX.toFXAffine((AffineTransform)this.newContentTransform);
        if (!this.canvas.getContentTransform().equals(newContentAffine)) {
            this.canvas.setContentTransform(newContentAffine);
        }
        if (this.canvas.getHorizontalScrollOffset() != this.newHorizontalScrollOffset) {
            this.canvas.setHorizontalScrollOffset(this.newHorizontalScrollOffset);
        }
        if (this.canvas.getVerticalScrollOffset() != this.newVerticalScrollOffset) {
            this.canvas.setVerticalScrollOffset(this.newVerticalScrollOffset);
        }
        return Status.OK_STATUS;
    }

    public InfiniteCanvas getInfiniteCanvas() {
        return this.canvas;
    }

    public AffineTransform getInitialContentTransform() {
        return this.initialContentTransform;
    }

    public double getInitialHeight() {
        return this.initialHeight;
    }

    public double getInitialHorizontalScrollOffset() {
        return this.initialHorizontalScrollOffset;
    }

    public double getInitialVerticalScrollOffset() {
        return this.initialVerticalScrollOffset;
    }

    public double getInitialWidth() {
        return this.initialWidth;
    }

    public double getNewHeight() {
        return this.newHeight;
    }

    public double getNewHorizontalScrollOffset() {
        return this.newHorizontalScrollOffset;
    }

    public AffineTransform getNewTransform() {
        return this.newContentTransform;
    }

    public double getNewVerticalScrollOffset() {
        return this.newVerticalScrollOffset;
    }

    public double getNewWidth() {
        return this.newWidth;
    }

    public boolean isContentRelevant() {
        return false;
    }

    public boolean isNoOp() {
        return this.getNewWidth() == this.getInitialWidth() && this.getNewHeight() == this.getInitialHeight() && (this.getNewTransform() == null ? this.getInitialContentTransform() == null : this.getNewTransform().equals((Object)this.getInitialContentTransform())) && this.getNewHorizontalScrollOffset() == this.getInitialHorizontalScrollOffset() && this.getNewVerticalScrollOffset() == this.getInitialVerticalScrollOffset();
    }

    protected void readViewport(InfiniteCanvas canvas) {
        this.canvas = canvas;
        this.initialWidth = canvas.getWidth();
        this.initialHeight = canvas.getHeight();
        this.initialContentTransform = FX2Geometry.toAffineTransform((Transform)canvas.getContentTransform());
        this.initialHorizontalScrollOffset = canvas.getHorizontalScrollOffset();
        this.initialVerticalScrollOffset = canvas.getVerticalScrollOffset();
        this.newWidth = this.initialWidth;
        this.newHeight = this.initialHeight;
        this.newContentTransform = this.initialContentTransform.getCopy();
        this.newHorizontalScrollOffset = this.initialHorizontalScrollOffset;
        this.newVerticalScrollOffset = this.initialVerticalScrollOffset;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public void setInitialContentTransform(AffineTransform initialContentTransform) {
        this.initialContentTransform = initialContentTransform;
    }

    public void setInitialHeight(double initialHeight) {
        this.initialHeight = initialHeight;
    }

    public void setInitialHorizontalScrollOffset(double initialHorizontalScrollOffset) {
        this.initialHorizontalScrollOffset = initialHorizontalScrollOffset;
    }

    public void setInitialVerticalScrollOffset(double initialVerticalScrollOffset) {
        this.initialVerticalScrollOffset = initialVerticalScrollOffset;
    }

    public void setInitialWidth(double initialWidth) {
        this.initialWidth = initialWidth;
    }

    public void setNewContentTransform(AffineTransform newContentTransform) {
        this.newContentTransform = newContentTransform;
    }

    public void setNewHeight(double newHeight) {
        this.newHeight = newHeight;
    }

    public void setNewHorizontalScrollOffset(double newHorizontalScrollOffset) {
        this.newHorizontalScrollOffset = newHorizontalScrollOffset;
    }

    public void setNewVerticalScrollOffset(double newVerticalScrollOffset) {
        this.newVerticalScrollOffset = newVerticalScrollOffset;
    }

    public void setNewWidth(double newWidth) {
        this.newWidth = newWidth;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.canvas.getPrefWidth() != this.initialWidth) {
            this.canvas.setPrefWidth(this.initialWidth);
        }
        if (this.canvas.getPrefHeight() != this.initialHeight) {
            this.canvas.setPrefHeight(this.initialHeight);
        }
        Affine initialContentAffine = Geometry2FX.toFXAffine((AffineTransform)this.initialContentTransform);
        if (!this.canvas.getContentTransform().equals(initialContentAffine)) {
            this.canvas.setContentTransform(initialContentAffine);
        }
        if (this.canvas.getHorizontalScrollOffset() != this.initialHorizontalScrollOffset) {
            this.canvas.setHorizontalScrollOffset(this.initialHorizontalScrollOffset);
        }
        if (this.canvas.getVerticalScrollOffset() != this.initialVerticalScrollOffset) {
            this.canvas.setVerticalScrollOffset(this.initialVerticalScrollOffset);
        }
        return Status.OK_STATUS;
    }
}

