/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class ChangeContentsOperation
extends AbstractOperation
implements ITransactionalOperation {
    public static final String DEFAULT_LABEL = "Change Contents";
    private IViewer<?> viewer;
    private List<? extends Object> newContents;
    private List<? extends Object> initialContents;

    public ChangeContentsOperation(IViewer<?> viewer) {
        this(DEFAULT_LABEL, viewer, new ArrayList<Object>((Collection<Object>)((ContentModel)viewer.getAdapter(ContentModel.class)).getContents()));
    }

    public ChangeContentsOperation(IViewer<?> viewer, List<? extends Object> contents) {
        this(DEFAULT_LABEL, viewer, contents);
    }

    public ChangeContentsOperation(String label, IViewer<?> viewer, List<? extends Object> contents) {
        super(label);
        this.viewer = viewer;
        this.newContents = new ArrayList<Object>(contents);
        this.initialContents = new ArrayList<Object>((Collection<Object>)((ContentModel)viewer.getAdapter(ContentModel.class)).getContents());
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ContentModel contentModel = (ContentModel)this.viewer.getAdapter(ContentModel.class);
        if (!contentModel.getContents().equals(this.newContents)) {
            contentModel.getContents().setAll(this.newContents);
        }
        return Status.OK_STATUS;
    }

    protected List<? extends Object> getInitialContents() {
        return this.initialContents;
    }

    protected List<? extends Object> getNewContents() {
        return this.newContents;
    }

    @Override
    public boolean isContentRelevant() {
        return true;
    }

    @Override
    public boolean isNoOp() {
        return this.initialContents == this.newContents || this.initialContents != null && this.initialContents.equals(this.newContents);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public void setNewContents(List<? extends Object> newContents) {
        this.newContents = new ArrayList<Object>(newContents);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ContentModel contentModel = (ContentModel)this.viewer.getAdapter(ContentModel.class);
        contentModel.getContents().setAll(this.initialContents);
        return Status.OK_STATUS;
    }
}

