/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.nodes;

import java.util.Arrays;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import javafx.util.Duration;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef4.geometry.planar.AffineTransform;

public class InfiniteCanvas
extends Region {
    public static final double DEFAULT_GRID_CELL_WIDTH = 10.0;
    public static final double DEFAULT_GRID_CELL_HEIGHT = 10.0;
    private GridCanvas gridCanvas;
    private final DoubleProperty gridCellHeightProperty = new SimpleDoubleProperty(10.0);
    private final DoubleProperty gridCellWidthProperty = new SimpleDoubleProperty(10.0);
    private final ReadOnlyObjectWrapper<Affine> gridTransformProperty = new ReadOnlyObjectWrapper((Object)new Affine());
    private final BooleanProperty showGridProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty zoomGridProperty = new SimpleBooleanProperty(true);
    private Rectangle clippingRectangle = new Rectangle();
    private final BooleanProperty clipContentProperty = new SimpleBooleanProperty(true);
    private Group scrollBarGroup;
    private ScrollBar horizontalScrollBar;
    private ScrollBar verticalScrollBar;
    private final ObjectProperty<ScrollPane.ScrollBarPolicy> horizontalScrollBarPolicyProperty = new SimpleObjectProperty((Object)ScrollPane.ScrollBarPolicy.AS_NEEDED);
    private final ObjectProperty<ScrollPane.ScrollBarPolicy> verticalScrollBarPolicyProperty = new SimpleObjectProperty((Object)ScrollPane.ScrollBarPolicy.AS_NEEDED);
    private Group contentGroup = new Group();
    private ReadOnlyObjectWrapper<Affine> contentTransformProperty = new ReadOnlyObjectWrapper((Object)new Affine());
    private double[] contentBounds = new double[]{0.0, 0.0, 0.0, 0.0};
    private double[] scrollableBounds = new double[]{0.0, 0.0, 0.0, 0.0};
    private ObjectBinding<Bounds> contentBoundsBinding = new ObjectBinding<Bounds>(){

        protected Bounds computeValue() {
            return new BoundingBox(InfiniteCanvas.this.contentBounds[0], InfiniteCanvas.this.contentBounds[1], InfiniteCanvas.this.contentBounds[2] - InfiniteCanvas.this.contentBounds[0], InfiniteCanvas.this.contentBounds[3] - InfiniteCanvas.this.contentBounds[1]);
        }
    };
    private ObjectBinding<Bounds> scrollableBoundsBinding = new ObjectBinding<Bounds>(){

        protected Bounds computeValue() {
            return new BoundingBox(InfiniteCanvas.this.scrollableBounds[0], InfiniteCanvas.this.scrollableBounds[1], InfiniteCanvas.this.scrollableBounds[2] - InfiniteCanvas.this.scrollableBounds[0], InfiniteCanvas.this.scrollableBounds[3] - InfiniteCanvas.this.scrollableBounds[1]);
        }
    };
    private ReadOnlyObjectWrapper<Bounds> contentBoundsProperty = new ReadOnlyObjectWrapper();
    private ReadOnlyObjectWrapper<Bounds> scrollableBoundsProperty = new ReadOnlyObjectWrapper();
    private Pane scrolledPane = new Pane();
    private Group underlayGroup = new Group();
    private Group scrolledUnderlayGroup = new Group();
    private Group scrolledOverlayGroup = new Group();
    private Group overlayGroup = new Group();
    private ChangeListener<Number> updateScrollBarsOnSizeChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldHeight, Number newHeight) {
            InfiniteCanvas.this.updateScrollBars();
        }
    };
    private ChangeListener<Bounds> updateScrollBarsOnBoundsChangeListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldBounds, Bounds newBounds) {
            InfiniteCanvas.this.updateScrollBars();
        }
    };
    private ChangeListener<ScrollPane.ScrollBarPolicy> updateScrollBarsOnPolicyChangeListener = new ChangeListener<ScrollPane.ScrollBarPolicy>(){

        public void changed(ObservableValue<? extends ScrollPane.ScrollBarPolicy> observable, ScrollPane.ScrollBarPolicy oldValue, ScrollPane.ScrollBarPolicy newValue) {
            InfiniteCanvas.this.updateScrollBars();
        }
    };

    public InfiniteCanvas() {
        this.contentBoundsProperty.bind(this.contentBoundsBinding);
        this.scrollableBoundsProperty.bind(this.scrollableBoundsBinding);
        this.scrollBarGroup = this.createScrollBarGroup();
        this.gridCanvas = this.createGridCanvas();
        this.getChildren().addAll(this.createLayers());
        this.getScrolledPane().getChildren().addAll(this.createScrolledLayers());
        this.getContentGroup().getTransforms().add((Object)this.getContentTransform());
        this.registerUpdateScrollBarsOnBoundsChanges();
        this.registerUpdateScrollBarsOnSizeChanges();
        this.registerUpdateScrollBarsOnPolicyChanges();
        if (this.showGridProperty.get()) {
            this.showGrid();
        }
        this.showGridProperty.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    InfiniteCanvas.this.showGrid();
                } else {
                    InfiniteCanvas.this.hideGrid();
                }
            }
        });
        if (this.showGridProperty.get()) {
            this.zoomGrid();
        }
        this.zoomGridProperty.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    InfiniteCanvas.this.zoomGrid();
                } else {
                    InfiniteCanvas.this.unzoomGrid();
                }
            }
        });
        if (this.clipContentProperty.get()) {
            this.clipContent();
        }
        this.clipContentProperty.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    InfiniteCanvas.this.clipContent();
                } else {
                    InfiniteCanvas.this.unclipContent();
                }
            }
        });
    }

    protected void clipContent() {
        this.clippingRectangle.widthProperty().bind((ObservableValue)this.widthProperty());
        this.clippingRectangle.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setClip((Node)this.clippingRectangle);
    }

    public BooleanProperty clipContentProperty() {
        return this.clipContentProperty;
    }

    protected double[] computeContentBoundsInLocal() {
        Bounds contentBoundsInScrolledPane = this.getContentGroup().getBoundsInParent();
        double minX = contentBoundsInScrolledPane.getMinX();
        double maxX = contentBoundsInScrolledPane.getMaxX();
        double minY = contentBoundsInScrolledPane.getMinY();
        double maxY = contentBoundsInScrolledPane.getMaxY();
        Point2D minInScrolled = this.getScrolledPane().localToParent(minX, minY);
        double realMinX = minInScrolled.getX();
        double realMinY = minInScrolled.getY();
        double realMaxX = realMinX + (maxX - minX);
        double realMaxY = realMinY + (maxY - minY);
        return new double[]{realMinX, realMinY, realMaxX, realMaxY};
    }

    protected double computeHv(double tx) {
        return this.lerp(this.horizontalScrollBar.getMin(), this.horizontalScrollBar.getMax(), this.norm(this.scrollableBounds[0], this.scrollableBounds[2] - this.getWidth(), -tx));
    }

    protected double[] computeScrollableBoundsInLocal() {
        double[] cb = Arrays.copyOf(this.contentBounds, this.contentBounds.length);
        Bounds db = this.getContentGroup().getBoundsInParent();
        if (cb[0] < 0.0) {
            cb[0] = 0.0;
        }
        if (cb[1] < 0.0) {
            cb[1] = 0.0;
        }
        cb[2] = cb[2] > this.getWidth() ? 0.0 : this.getWidth() - cb[2];
        cb[3] = cb[3] > this.getHeight() ? 0.0 : this.getHeight() - cb[3];
        return new double[]{db.getMinX() - cb[0], db.getMinY() - cb[1], db.getMaxX() + cb[2], db.getMaxY() + cb[3]};
    }

    protected double computeTx(double hv) {
        return -this.lerp(this.scrollableBounds[0], this.scrollableBounds[2] - this.getWidth(), this.norm(this.horizontalScrollBar.getMin(), this.horizontalScrollBar.getMax(), hv));
    }

    protected double computeTy(double vv) {
        return -this.lerp(this.scrollableBounds[1], this.scrollableBounds[3] - this.getHeight(), this.norm(this.verticalScrollBar.getMin(), this.verticalScrollBar.getMax(), vv));
    }

    protected double computeVv(double ty) {
        return this.lerp(this.verticalScrollBar.getMin(), this.verticalScrollBar.getMax(), this.norm(this.scrollableBounds[1], this.scrollableBounds[3] - this.getHeight(), -ty));
    }

    public ReadOnlyObjectProperty<Bounds> contentBoundsProperty() {
        return this.contentBoundsProperty.getReadOnlyProperty();
    }

    public ReadOnlyObjectProperty<Affine> contentTransformProperty() {
        return this.contentTransformProperty.getReadOnlyProperty();
    }

    protected GridCanvas createGridCanvas() {
        return new GridCanvas();
    }

    protected List<? extends Node> createLayers() {
        return Arrays.asList(this.getUnderlayGroup(), this.getScrolledPane(), this.getOverlayGroup(), this.getScrollBarGroup());
    }

    protected Group createScrollBarGroup() {
        this.horizontalScrollBar = new ScrollBar();
        this.horizontalScrollBar.setVisible(false);
        this.horizontalScrollBar.setOpacity(0.5);
        this.verticalScrollBar = new ScrollBar();
        this.verticalScrollBar.setOrientation(Orientation.VERTICAL);
        this.verticalScrollBar.setVisible(false);
        this.verticalScrollBar.setOpacity(0.5);
        DoubleBinding vWidth = new DoubleBinding(){
            {
                this.bind(new Observable[]{InfiniteCanvas.this.verticalScrollBar.visibleProperty(), InfiniteCanvas.this.verticalScrollBar.widthProperty()});
            }

            protected double computeValue() {
                return InfiniteCanvas.this.verticalScrollBar.isVisible() ? InfiniteCanvas.this.verticalScrollBar.getWidth() : 0.0;
            }
        };
        this.horizontalScrollBar.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)vWidth));
        this.horizontalScrollBar.layoutYProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.horizontalScrollBar.heightProperty()));
        DoubleBinding hHeight = new DoubleBinding(){
            {
                this.bind(new Observable[]{InfiniteCanvas.this.horizontalScrollBar.visibleProperty(), InfiniteCanvas.this.horizontalScrollBar.heightProperty()});
            }

            protected double computeValue() {
                return InfiniteCanvas.this.horizontalScrollBar.isVisible() ? InfiniteCanvas.this.horizontalScrollBar.getHeight() : 0.0;
            }
        };
        this.verticalScrollBar.prefHeightProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)hHeight));
        this.verticalScrollBar.layoutXProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.verticalScrollBar.widthProperty()));
        this.registerFadeInOutTransitions((Node)this.horizontalScrollBar);
        this.registerFadeInOutTransitions((Node)this.verticalScrollBar);
        EventHandler<MouseEvent> mousePressFilter = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                InfiniteCanvas.this.updateScrollBars();
            }
        };
        this.horizontalScrollBar.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)mousePressFilter);
        this.verticalScrollBar.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)mousePressFilter);
        this.horizontalScrollBar.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (InfiniteCanvas.this.horizontalScrollBar.isVisible()) {
                    InfiniteCanvas.this.getScrolledPane().setTranslateX(InfiniteCanvas.this.computeTx(newValue.doubleValue()));
                }
            }
        });
        this.verticalScrollBar.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (InfiniteCanvas.this.verticalScrollBar.isVisible()) {
                    InfiniteCanvas.this.getScrolledPane().setTranslateY(InfiniteCanvas.this.computeTy(newValue.doubleValue()));
                }
            }
        });
        EventHandler<MouseEvent> mouseReleasedHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                InfiniteCanvas.this.updateScrollBars();
            }
        };
        this.horizontalScrollBar.setOnMouseReleased((EventHandler)mouseReleasedHandler);
        this.verticalScrollBar.setOnMouseReleased((EventHandler)mouseReleasedHandler);
        return new Group(new Node[]{this.horizontalScrollBar, this.verticalScrollBar});
    }

    protected List<? extends Node> createScrolledLayers() {
        return Arrays.asList(new Node[]{this.getGridCanvas(), this.getScrolledUnderlayGroup(), this.getContentGroup(), this.getScrolledOverlayGroup()});
    }

    public void fitToSize(double zoomMin, double zoomMax) {
        Bounds contentBounds = this.getContentBounds();
        double contentWidth = contentBounds.getWidth();
        if (Double.isNaN(contentWidth) || Double.isInfinite(contentWidth) || contentWidth <= 0.0) {
            throw new IllegalStateException("Content area is zero.");
        }
        double contentHeight = contentBounds.getHeight();
        if (Double.isNaN(contentHeight) || Double.isInfinite(contentHeight) || contentHeight <= 0.0) {
            throw new IllegalStateException("Content area is zero.");
        }
        if (this.getWidth() <= 0.0 || this.getHeight() <= 0.0) {
            throw new IllegalStateException("Canvas area is zero.");
        }
        double zf = Math.min(this.getWidth() / contentWidth, this.getHeight() / contentHeight);
        if (Double.isInfinite(zf) || Double.isNaN(zf) || zf <= 0.0) {
            throw new IllegalStateException("Invalid zoom factor.");
        }
        if (zf > zoomMax) {
            zf = zoomMax;
        }
        if (zf < zoomMin) {
            zf = zoomMin;
        }
        double cx = contentBounds.getMinX() + contentBounds.getWidth() / 2.0;
        double cy = contentBounds.getMinY() + contentBounds.getHeight() / 2.0;
        double vx = this.getWidth() / 2.0;
        double vy = this.getHeight() / 2.0;
        this.setHorizontalScrollOffset(this.getHorizontalScrollOffset() + vx - cx);
        this.setVerticalScrollOffset(this.getVerticalScrollOffset() + vy - cy);
        Point2D pivot = this.getContentGroup().sceneToLocal(vx, vy);
        AffineTransform scaleTransform = new AffineTransform().translate(pivot.getX(), pivot.getY()).scale(zf, zf).translate(-pivot.getX(), -pivot.getY());
        AffineTransform newTransform = FX2Geometry.toAffineTransform((Transform)this.getContentTransform()).concatenate(scaleTransform);
        this.setContentTransform(Geometry2FX.toFXAffine((AffineTransform)newTransform));
    }

    public Bounds getContentBounds() {
        return (Bounds)this.contentBoundsProperty.get();
    }

    public Group getContentGroup() {
        return this.contentGroup;
    }

    public Affine getContentTransform() {
        return (Affine)this.contentTransformProperty.get();
    }

    protected GridCanvas getGridCanvas() {
        return this.gridCanvas;
    }

    public double getGridCellHeight() {
        return this.gridCellHeightProperty.get();
    }

    public double getGridCellWidth() {
        return this.gridCellWidthProperty.get();
    }

    public ScrollBar getHorizontalScrollBar() {
        return this.horizontalScrollBar;
    }

    public ScrollPane.ScrollBarPolicy getHorizontalScrollBarPolicy() {
        return (ScrollPane.ScrollBarPolicy)this.horizontalScrollBarPolicyProperty.get();
    }

    public double getHorizontalScrollOffset() {
        return this.getScrolledPane().getTranslateX();
    }

    public Group getOverlayGroup() {
        return this.overlayGroup;
    }

    public Bounds getScrollableBounds() {
        return (Bounds)this.scrollableBoundsProperty.get();
    }

    protected Group getScrollBarGroup() {
        return this.scrollBarGroup;
    }

    public Group getScrolledOverlayGroup() {
        return this.scrolledOverlayGroup;
    }

    protected Pane getScrolledPane() {
        return this.scrolledPane;
    }

    public Group getScrolledUnderlayGroup() {
        return this.scrolledUnderlayGroup;
    }

    public Group getUnderlayGroup() {
        return this.underlayGroup;
    }

    public ScrollBar getVerticalScrollBar() {
        return this.verticalScrollBar;
    }

    public ScrollPane.ScrollBarPolicy getVerticalScrollBarPolicy() {
        return (ScrollPane.ScrollBarPolicy)this.verticalScrollBarPolicyProperty.get();
    }

    public double getVerticalScrollOffset() {
        return this.getScrolledPane().getTranslateY();
    }

    public DoubleProperty gridCellHeightProperty() {
        return this.gridCellHeightProperty;
    }

    public DoubleProperty gridCellWidthProperty() {
        return this.gridCellWidthProperty;
    }

    protected void hideGrid() {
        this.gridCanvas.setVisible(false);
        this.gridCanvas.layoutXProperty().unbind();
        this.gridCanvas.layoutYProperty().unbind();
        this.gridCanvas.widthProperty().unbind();
        this.gridCanvas.heightProperty().unbind();
    }

    public ObjectProperty<ScrollPane.ScrollBarPolicy> horizontalScrollBarPolicyProperty() {
        return this.horizontalScrollBarPolicyProperty;
    }

    public DoubleProperty horizontalScrollOffsetProperty() {
        return this.getScrolledPane().translateXProperty();
    }

    public boolean isClipContent() {
        return this.clipContentProperty.get();
    }

    public boolean isShowGrid() {
        return this.showGridProperty.get();
    }

    public boolean isZoomGrid() {
        return this.zoomGridProperty.get();
    }

    protected double lerp(double min, double max, double ratio) {
        double d = (1.0 - ratio) * min + ratio * max;
        return Double.isNaN(d) ? 0.0 : Math.min(max, Math.max(min, d));
    }

    protected double norm(double min, double max, double value) {
        double d = (value - min) / (max - min);
        return Double.isNaN(d) ? 0.0 : Math.min(1.0, Math.max(0.0, d));
    }

    protected void registerFadeInOutTransitions(final Node node) {
        final FadeTransition fadeInTransition = new FadeTransition(Duration.millis((double)200.0), node);
        fadeInTransition.setToValue(1.0);
        final FadeTransition fadeOutTransition = new FadeTransition(Duration.millis((double)200.0), node);
        fadeOutTransition.setToValue(0.5);
        final Runnable fadeIn = new Runnable(){

            @Override
            public void run() {
                fadeOutTransition.stop();
                fadeInTransition.playFromStart();
            }
        };
        final Runnable fadeOut = new Runnable(){

            @Override
            public void run() {
                fadeInTransition.stop();
                fadeOutTransition.playFromStart();
            }
        };
        node.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                fadeIn.run();
            }
        });
        node.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (!node.isPressed()) {
                    fadeOut.run();
                }
            }
        });
        node.pressedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (oldValue.booleanValue() && !newValue.booleanValue()) {
                    fadeOut.run();
                }
            }
        });
    }

    protected void registerUpdateScrollBarsOnBoundsChanges() {
        this.getScrolledPane().boundsInLocalProperty().addListener(this.updateScrollBarsOnBoundsChangeListener);
        this.getContentGroup().boundsInParentProperty().addListener(this.updateScrollBarsOnBoundsChangeListener);
    }

    protected void registerUpdateScrollBarsOnPolicyChanges() {
        this.horizontalScrollBarPolicyProperty.addListener(this.updateScrollBarsOnPolicyChangeListener);
        this.verticalScrollBarPolicyProperty.addListener(this.updateScrollBarsOnPolicyChangeListener);
    }

    protected void registerUpdateScrollBarsOnSizeChanges() {
        this.widthProperty().addListener(this.updateScrollBarsOnSizeChangeListener);
        this.heightProperty().addListener(this.updateScrollBarsOnSizeChangeListener);
    }

    public void reveal(Node child) {
        Bounds bounds = this.sceneToLocal(child.localToScene(child.getBoundsInLocal()));
        if (bounds.getHeight() <= this.getHeight()) {
            if (bounds.getMinY() < 0.0) {
                this.setVerticalScrollOffset(this.getVerticalScrollOffset() - bounds.getMinY());
            } else if (bounds.getMaxY() > this.getHeight()) {
                this.setVerticalScrollOffset(this.getVerticalScrollOffset() + this.getHeight() - bounds.getMaxY());
            }
        }
        if (bounds.getWidth() <= this.getWidth()) {
            if (bounds.getMinX() < 0.0) {
                this.setHorizontalScrollOffset(this.getHorizontalScrollOffset() - bounds.getMinX());
            } else if (bounds.getMaxX() > this.getWidth()) {
                this.setHorizontalScrollOffset(this.getHorizontalScrollOffset() + this.getWidth() - bounds.getMaxX());
            }
        }
    }

    public ReadOnlyObjectProperty<Bounds> scrollableBoundsProperty() {
        return this.scrollableBoundsProperty.getReadOnlyProperty();
    }

    public void setClipContent(boolean clipContent) {
        this.clipContentProperty.set(clipContent);
    }

    public void setContentTransform(Affine tx) {
        Affine viewportTransform = (Affine)this.contentTransformProperty.get();
        if (viewportTransform.getMxx() != tx.getMxx()) {
            viewportTransform.setMxx(tx.getMxx());
        }
        if (viewportTransform.getMxy() != tx.getMxy()) {
            viewportTransform.setMxy(tx.getMxy());
        }
        if (viewportTransform.getMyx() != tx.getMyx()) {
            viewportTransform.setMyx(tx.getMyx());
        }
        if (viewportTransform.getMyy() != tx.getMyy()) {
            viewportTransform.setMyy(tx.getMyy());
        }
        if (viewportTransform.getTx() != tx.getTx()) {
            viewportTransform.setTx(tx.getTx());
        }
        if (viewportTransform.getTy() != tx.getTy()) {
            viewportTransform.setTy(tx.getTy());
        }
        this.updateScrollBars();
    }

    public void setGridCellHeight(double gridCellHeight) {
        this.gridCellHeightProperty.set(gridCellHeight);
    }

    public void setGridCellWidth(double gridCellWidth) {
        this.gridCellWidthProperty.set(gridCellWidth);
    }

    public void setHorizontalScrollBarPolicy(ScrollPane.ScrollBarPolicy horizontalScrollBarPolicy) {
        this.horizontalScrollBarPolicyProperty.set((Object)horizontalScrollBarPolicy);
    }

    public void setHorizontalScrollOffset(double scrollOffsetX) {
        this.getScrolledPane().setTranslateX(scrollOffsetX);
    }

    public void setShowGrid(boolean showGrid) {
        this.showGridProperty.set(showGrid);
    }

    public void setVerticalScrollBarPolicy(ScrollPane.ScrollBarPolicy verticalScrollBarPolicy) {
        this.verticalScrollBarPolicyProperty.set((Object)verticalScrollBarPolicy);
    }

    public void setVerticalScrollOffset(double scrollOffsetY) {
        this.getScrolledPane().setTranslateY(scrollOffsetY);
    }

    public void setZoomGrid(boolean zoomGrid) {
        this.zoomGridProperty.set(zoomGrid);
    }

    protected void showGrid() {
        this.gridCanvas.setVisible(true);
        this.gridCanvas.layoutXProperty().bind((ObservableValue)new DoubleBinding(){

            protected double computeValue() {
                return Math.min(0.0, ((Bounds)InfiniteCanvas.this.scrollableBoundsProperty.get()).getMinX());
            }
        });
        this.gridCanvas.layoutYProperty().bind((ObservableValue)new DoubleBinding(){

            protected double computeValue() {
                return Math.min(0.0, ((Bounds)InfiniteCanvas.this.scrollableBoundsProperty.get()).getMinY());
            }
        });
        this.gridCanvas.widthProperty().bind((ObservableValue)new DoubleBinding(){

            protected double computeValue() {
                if (InfiniteCanvas.this.scrollableBoundsProperty.get() == null) {
                    return 0.0;
                }
                return ((Bounds)InfiniteCanvas.this.scrollableBoundsProperty.get()).getWidth();
            }
        });
        this.gridCanvas.heightProperty().bind((ObservableValue)new DoubleBinding(){

            protected double computeValue() {
                if (InfiniteCanvas.this.scrollableBoundsProperty.get() == null) {
                    return 0.0;
                }
                return ((Bounds)InfiniteCanvas.this.scrollableBoundsProperty.get()).getHeight();
            }
        });
    }

    public BooleanProperty showGridProperty() {
        return this.showGridProperty;
    }

    protected void unclipContent() {
        this.clippingRectangle.widthProperty().unbind();
        this.clippingRectangle.heightProperty().unbind();
        this.setClip(null);
    }

    protected void unzoomGrid() {
        Affine gridTransform = (Affine)this.gridTransformProperty.get();
        gridTransform.mxxProperty().unbind();
        gridTransform.mxyProperty().unbind();
        gridTransform.myxProperty().unbind();
        gridTransform.myyProperty().unbind();
        gridTransform.txProperty().unbind();
        gridTransform.tyProperty().unbind();
    }

    protected void updateScrollBars() {
        boolean vbarIsNeeded;
        boolean hbarIsNeeded;
        if (this.horizontalScrollBar.isPressed() || this.verticalScrollBar.isPressed()) {
            return;
        }
        double[] oldContentBounds = Arrays.copyOf(this.contentBounds, this.contentBounds.length);
        this.contentBounds = this.computeContentBoundsInLocal();
        if (!Arrays.equals(oldContentBounds, this.contentBounds)) {
            this.contentBoundsBinding.invalidate();
        }
        ScrollPane.ScrollBarPolicy hbarPolicy = (ScrollPane.ScrollBarPolicy)this.horizontalScrollBarPolicyProperty.get();
        boolean bl = hbarIsNeeded = this.contentBounds[0] < 0.0 || this.contentBounds[2] > this.getWidth();
        if (hbarPolicy.equals((Object)ScrollPane.ScrollBarPolicy.ALWAYS) || hbarPolicy.equals((Object)ScrollPane.ScrollBarPolicy.AS_NEEDED) && hbarIsNeeded) {
            this.horizontalScrollBar.setVisible(true);
        } else {
            this.horizontalScrollBar.setVisible(false);
        }
        ScrollPane.ScrollBarPolicy vbarPolicy = (ScrollPane.ScrollBarPolicy)this.verticalScrollBarPolicyProperty.get();
        boolean bl2 = vbarIsNeeded = this.contentBounds[1] < 0.0 || this.contentBounds[3] > this.getHeight();
        if (vbarPolicy.equals((Object)ScrollPane.ScrollBarPolicy.ALWAYS) || vbarPolicy.equals((Object)ScrollPane.ScrollBarPolicy.AS_NEEDED) && vbarIsNeeded) {
            this.verticalScrollBar.setVisible(true);
        } else {
            this.verticalScrollBar.setVisible(false);
        }
        double[] oldScrollableBounds = Arrays.copyOf(this.scrollableBounds, this.scrollableBounds.length);
        this.scrollableBounds = this.computeScrollableBoundsInLocal();
        if (!Arrays.equals(oldScrollableBounds, this.scrollableBounds)) {
            this.scrollableBoundsBinding.invalidate();
        }
        this.horizontalScrollBar.setMin(this.scrollableBounds[0]);
        this.horizontalScrollBar.setMax(this.scrollableBounds[2]);
        this.horizontalScrollBar.setVisibleAmount(this.getWidth());
        this.horizontalScrollBar.setBlockIncrement(this.getWidth() / 2.0);
        this.horizontalScrollBar.setUnitIncrement(this.getWidth() / 10.0);
        this.verticalScrollBar.setMin(this.scrollableBounds[1]);
        this.verticalScrollBar.setMax(this.scrollableBounds[3]);
        this.verticalScrollBar.setVisibleAmount(this.getHeight());
        this.verticalScrollBar.setBlockIncrement(this.getHeight() / 2.0);
        this.verticalScrollBar.setUnitIncrement(this.getHeight() / 10.0);
        this.horizontalScrollBar.setValue(this.computeHv(this.getScrolledPane().getTranslateX()));
        this.verticalScrollBar.setValue(this.computeVv(this.getScrolledPane().getTranslateY()));
    }

    public ObjectProperty<ScrollPane.ScrollBarPolicy> verticalScrollBarPolicyProperty() {
        return this.verticalScrollBarPolicyProperty;
    }

    public DoubleProperty verticalScrollOffsetProperty() {
        return this.getScrolledPane().translateYProperty();
    }

    protected void zoomGrid() {
        Affine gridTransform = (Affine)this.gridTransformProperty.get();
        Affine contentTransform = this.getContentTransform();
        gridTransform.mxxProperty().bind((ObservableValue)contentTransform.mxxProperty());
        gridTransform.mxyProperty().bind((ObservableValue)contentTransform.mxyProperty());
        gridTransform.myxProperty().bind((ObservableValue)contentTransform.myxProperty());
        gridTransform.myyProperty().bind((ObservableValue)contentTransform.myyProperty());
        gridTransform.txProperty().bind((ObservableValue)contentTransform.txProperty());
        gridTransform.tyProperty().bind((ObservableValue)contentTransform.tyProperty());
    }

    public BooleanProperty zoomGridProperty() {
        return this.zoomGridProperty;
    }

    public class GridCanvas
    extends Canvas {
        private static final int GRID_THRESHOLD = 5000000;

        public GridCanvas() {
            ChangeListener<Number> repaintListener = new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    GridCanvas.this.repaintGrid();
                }
            };
            Affine gridTransform = (Affine)InfiniteCanvas.this.gridTransformProperty.get();
            gridTransform.txProperty().addListener((ChangeListener)repaintListener);
            gridTransform.tyProperty().addListener((ChangeListener)repaintListener);
            gridTransform.mxxProperty().addListener((ChangeListener)repaintListener);
            gridTransform.myyProperty().addListener((ChangeListener)repaintListener);
            InfiniteCanvas.this.gridCellWidthProperty.addListener((ChangeListener)repaintListener);
            InfiniteCanvas.this.gridCellHeightProperty.addListener((ChangeListener)repaintListener);
            this.layoutXProperty().addListener((ChangeListener)repaintListener);
            this.layoutYProperty().addListener((ChangeListener)repaintListener);
            this.widthProperty().addListener((ChangeListener)repaintListener);
            this.heightProperty().addListener((ChangeListener)repaintListener);
        }

        public boolean isResizable() {
            return true;
        }

        public double prefHeight(double width) {
            return this.getHeight();
        }

        public double prefWidth(double height) {
            return this.getWidth();
        }

        protected void repaintGrid() {
            double width = this.getWidth();
            double height = this.getHeight();
            GraphicsContext gc = this.getGraphicsContext2D();
            gc.clearRect(0.0, 0.0, width, height);
            double xScale = Math.abs(((Affine)InfiniteCanvas.this.gridTransformProperty.get()).getMxx());
            double yScale = Math.abs(((Affine)InfiniteCanvas.this.gridTransformProperty.get()).getMyy());
            if (width / xScale * (height / yScale) > 5000000.0) {
                return;
            }
            double scaledGridCellWidth = InfiniteCanvas.this.gridCellWidthProperty.get() * xScale;
            double scaledGridCellHeight = InfiniteCanvas.this.gridCellHeightProperty.get() * yScale;
            gc.setFill((Paint)Color.GREY);
            double x = -(this.getLayoutX() - ((Affine)InfiniteCanvas.this.gridTransformProperty.get()).getTx()) % scaledGridCellWidth;
            while (x < width) {
                double y = -(this.getLayoutY() - ((Affine)InfiniteCanvas.this.gridTransformProperty.get()).getTy()) % scaledGridCellHeight;
                while (y < height) {
                    gc.fillRect(Math.floor(x) - 0.5 * xScale, Math.floor(y) - 0.5 * yScale, xScale, yScale);
                    y += scaledGridCellHeight;
                }
                x += scaledGridCellWidth;
            }
        }
    }
}

