/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.lang.annotation.Annotation;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationBroadcaster;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.NotificationSender;
import org.apache.camel.api.management.NotificationSenderAware;
import org.apache.camel.support.management.DefaultManagementMBeanAssembler;
import org.apache.camel.support.management.NotificationSenderAdapter;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;

public class SpringManagementMBeanAssembler
extends DefaultManagementMBeanAssembler {
    private static final Logger LOG = LoggerFactory.getLogger(SpringManagementMBeanAssembler.class);
    private final MetadataMBeanInfoAssembler springAssembler = new MetadataMBeanInfoAssembler();

    public SpringManagementMBeanAssembler(CamelContext camelContext) {
        super(camelContext);
        this.springAssembler.setAttributeSource((JmxAttributeSource)new AnnotationJmxAttributeSource());
    }

    public ModelMBean assemble(MBeanServer mBeanServer, Object obj, ObjectName name) throws JMException {
        Object custom;
        ModelMBeanInfo mbi = null;
        if (obj instanceof ManagedInstance && (custom = ((ManagedInstance)obj).getInstance()) != null && ObjectHelper.hasAnnotation((Annotation[])custom.getClass().getAnnotations(), ManagedResource.class)) {
            LOG.trace("Assembling MBeanInfo for: {} from custom @ManagedResource object: {}", (Object)name, custom);
            mbi = this.springAssembler.getMBeanInfo(custom, name.toString());
            obj = custom;
        }
        if (mbi == null) {
            if (ObjectHelper.hasAnnotation((Annotation[])obj.getClass().getAnnotations(), ManagedResource.class)) {
                LOG.trace("Assembling MBeanInfo for: {} from @ManagedResource object: {}", (Object)name, obj);
                mbi = this.springAssembler.getMBeanInfo(obj, name.toString());
            } else {
                return super.assemble(mBeanServer, obj, name);
            }
        }
        LOG.trace("Assembled MBeanInfo {}", mbi);
        RequiredModelMBean mbean = (RequiredModelMBean)mBeanServer.instantiate(RequiredModelMBean.class.getName());
        mbean.setModelMBeanInfo(mbi);
        try {
            mbean.setManagedResource(obj, "ObjectReference");
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new JMException(e.getMessage());
        }
        if (obj instanceof NotificationSenderAware) {
            ((NotificationSenderAware)obj).setNotificationSender((NotificationSender)new NotificationSenderAdapter((ModelMBeanNotificationBroadcaster)mbean));
        }
        return mbean;
    }
}

