/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1alpha1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1alpha1"
	camelv1alpha1 "github.com/apache/camel-k/v2/pkg/client/camel/applyconfiguration/camel/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeKamelets implements KameletInterface
type FakeKamelets struct {
	Fake *FakeCamelV1alpha1
	ns   string
}

var kameletsResource = v1alpha1.SchemeGroupVersion.WithResource("kamelets")

var kameletsKind = v1alpha1.SchemeGroupVersion.WithKind("Kamelet")

// Get takes name of the kamelet, and returns the corresponding kamelet object, and an error if there is any.
func (c *FakeKamelets) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.Kamelet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(kameletsResource, c.ns, name), &v1alpha1.Kamelet{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Kamelet), err
}

// List takes label and field selectors, and returns the list of Kamelets that match those selectors.
func (c *FakeKamelets) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.KameletList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(kameletsResource, kameletsKind, c.ns, opts), &v1alpha1.KameletList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.KameletList{ListMeta: obj.(*v1alpha1.KameletList).ListMeta}
	for _, item := range obj.(*v1alpha1.KameletList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested kamelets.
func (c *FakeKamelets) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(kameletsResource, c.ns, opts))

}

// Create takes the representation of a kamelet and creates it.  Returns the server's representation of the kamelet, and an error, if there is any.
func (c *FakeKamelets) Create(ctx context.Context, kamelet *v1alpha1.Kamelet, opts v1.CreateOptions) (result *v1alpha1.Kamelet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(kameletsResource, c.ns, kamelet), &v1alpha1.Kamelet{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Kamelet), err
}

// Update takes the representation of a kamelet and updates it. Returns the server's representation of the kamelet, and an error, if there is any.
func (c *FakeKamelets) Update(ctx context.Context, kamelet *v1alpha1.Kamelet, opts v1.UpdateOptions) (result *v1alpha1.Kamelet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(kameletsResource, c.ns, kamelet), &v1alpha1.Kamelet{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Kamelet), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeKamelets) UpdateStatus(ctx context.Context, kamelet *v1alpha1.Kamelet, opts v1.UpdateOptions) (*v1alpha1.Kamelet, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(kameletsResource, "status", c.ns, kamelet), &v1alpha1.Kamelet{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Kamelet), err
}

// Delete takes name of the kamelet and deletes it. Returns an error if one occurs.
func (c *FakeKamelets) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(kameletsResource, c.ns, name, opts), &v1alpha1.Kamelet{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeKamelets) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(kameletsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.KameletList{})
	return err
}

// Patch applies the patch and returns the patched kamelet.
func (c *FakeKamelets) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Kamelet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(kameletsResource, c.ns, name, pt, data, subresources...), &v1alpha1.Kamelet{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Kamelet), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied kamelet.
func (c *FakeKamelets) Apply(ctx context.Context, kamelet *camelv1alpha1.KameletApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.Kamelet, err error) {
	if kamelet == nil {
		return nil, fmt.Errorf("kamelet provided to Apply must not be nil")
	}
	data, err := json.Marshal(kamelet)
	if err != nil {
		return nil, err
	}
	name := kamelet.Name
	if name == nil {
		return nil, fmt.Errorf("kamelet.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(kameletsResource, c.ns, *name, types.ApplyPatchType, data), &v1alpha1.Kamelet{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Kamelet), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeKamelets) ApplyStatus(ctx context.Context, kamelet *camelv1alpha1.KameletApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.Kamelet, err error) {
	if kamelet == nil {
		return nil, fmt.Errorf("kamelet provided to Apply must not be nil")
	}
	data, err := json.Marshal(kamelet)
	if err != nil {
		return nil, err
	}
	name := kamelet.Name
	if name == nil {
		return nil, fmt.Errorf("kamelet.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(kameletsResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1alpha1.Kamelet{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Kamelet), err
}
