/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// CamelCatalogSpecApplyConfiguration represents an declarative configuration of the CamelCatalogSpec type for use
// with apply.
type CamelCatalogSpecApplyConfiguration struct {
	Runtime   *RuntimeSpecApplyConfiguration             `json:"runtime,omitempty"`
	Artifacts map[string]CamelArtifactApplyConfiguration `json:"artifacts,omitempty"`
	Loaders   map[string]CamelLoaderApplyConfiguration   `json:"loaders,omitempty"`
}

// CamelCatalogSpecApplyConfiguration constructs an declarative configuration of the CamelCatalogSpec type for use with
// apply.
func CamelCatalogSpec() *CamelCatalogSpecApplyConfiguration {
	return &CamelCatalogSpecApplyConfiguration{}
}

// WithRuntime sets the Runtime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Runtime field is set to the value of the last call.
func (b *CamelCatalogSpecApplyConfiguration) WithRuntime(value *RuntimeSpecApplyConfiguration) *CamelCatalogSpecApplyConfiguration {
	b.Runtime = value
	return b
}

// WithArtifacts puts the entries into the Artifacts field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Artifacts field,
// overwriting an existing map entries in Artifacts field with the same key.
func (b *CamelCatalogSpecApplyConfiguration) WithArtifacts(entries map[string]CamelArtifactApplyConfiguration) *CamelCatalogSpecApplyConfiguration {
	if b.Artifacts == nil && len(entries) > 0 {
		b.Artifacts = make(map[string]CamelArtifactApplyConfiguration, len(entries))
	}
	for k, v := range entries {
		b.Artifacts[k] = v
	}
	return b
}

// WithLoaders puts the entries into the Loaders field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Loaders field,
// overwriting an existing map entries in Loaders field with the same key.
func (b *CamelCatalogSpecApplyConfiguration) WithLoaders(entries map[string]CamelLoaderApplyConfiguration) *CamelCatalogSpecApplyConfiguration {
	if b.Loaders == nil && len(entries) > 0 {
		b.Loaders = make(map[string]CamelLoaderApplyConfiguration, len(entries))
	}
	for k, v := range entries {
		b.Loaders[k] = v
	}
	return b
}
