/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	camelv1 "github.com/apache/camel-k/v2/pkg/client/camel/applyconfiguration/camel/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeIntegrationProfiles implements IntegrationProfileInterface
type FakeIntegrationProfiles struct {
	Fake *FakeCamelV1
	ns   string
}

var integrationprofilesResource = v1.SchemeGroupVersion.WithResource("integrationprofiles")

var integrationprofilesKind = v1.SchemeGroupVersion.WithKind("IntegrationProfile")

// Get takes name of the integrationProfile, and returns the corresponding integrationProfile object, and an error if there is any.
func (c *FakeIntegrationProfiles) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.IntegrationProfile, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(integrationprofilesResource, c.ns, name), &v1.IntegrationProfile{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IntegrationProfile), err
}

// List takes label and field selectors, and returns the list of IntegrationProfiles that match those selectors.
func (c *FakeIntegrationProfiles) List(ctx context.Context, opts metav1.ListOptions) (result *v1.IntegrationProfileList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(integrationprofilesResource, integrationprofilesKind, c.ns, opts), &v1.IntegrationProfileList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.IntegrationProfileList{ListMeta: obj.(*v1.IntegrationProfileList).ListMeta}
	for _, item := range obj.(*v1.IntegrationProfileList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested integrationProfiles.
func (c *FakeIntegrationProfiles) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(integrationprofilesResource, c.ns, opts))

}

// Create takes the representation of a integrationProfile and creates it.  Returns the server's representation of the integrationProfile, and an error, if there is any.
func (c *FakeIntegrationProfiles) Create(ctx context.Context, integrationProfile *v1.IntegrationProfile, opts metav1.CreateOptions) (result *v1.IntegrationProfile, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(integrationprofilesResource, c.ns, integrationProfile), &v1.IntegrationProfile{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IntegrationProfile), err
}

// Update takes the representation of a integrationProfile and updates it. Returns the server's representation of the integrationProfile, and an error, if there is any.
func (c *FakeIntegrationProfiles) Update(ctx context.Context, integrationProfile *v1.IntegrationProfile, opts metav1.UpdateOptions) (result *v1.IntegrationProfile, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(integrationprofilesResource, c.ns, integrationProfile), &v1.IntegrationProfile{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IntegrationProfile), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeIntegrationProfiles) UpdateStatus(ctx context.Context, integrationProfile *v1.IntegrationProfile, opts metav1.UpdateOptions) (*v1.IntegrationProfile, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(integrationprofilesResource, "status", c.ns, integrationProfile), &v1.IntegrationProfile{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IntegrationProfile), err
}

// Delete takes name of the integrationProfile and deletes it. Returns an error if one occurs.
func (c *FakeIntegrationProfiles) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(integrationprofilesResource, c.ns, name, opts), &v1.IntegrationProfile{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeIntegrationProfiles) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(integrationprofilesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1.IntegrationProfileList{})
	return err
}

// Patch applies the patch and returns the patched integrationProfile.
func (c *FakeIntegrationProfiles) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.IntegrationProfile, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(integrationprofilesResource, c.ns, name, pt, data, subresources...), &v1.IntegrationProfile{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IntegrationProfile), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied integrationProfile.
func (c *FakeIntegrationProfiles) Apply(ctx context.Context, integrationProfile *camelv1.IntegrationProfileApplyConfiguration, opts metav1.ApplyOptions) (result *v1.IntegrationProfile, err error) {
	if integrationProfile == nil {
		return nil, fmt.Errorf("integrationProfile provided to Apply must not be nil")
	}
	data, err := json.Marshal(integrationProfile)
	if err != nil {
		return nil, err
	}
	name := integrationProfile.Name
	if name == nil {
		return nil, fmt.Errorf("integrationProfile.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(integrationprofilesResource, c.ns, *name, types.ApplyPatchType, data), &v1.IntegrationProfile{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IntegrationProfile), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeIntegrationProfiles) ApplyStatus(ctx context.Context, integrationProfile *camelv1.IntegrationProfileApplyConfiguration, opts metav1.ApplyOptions) (result *v1.IntegrationProfile, err error) {
	if integrationProfile == nil {
		return nil, fmt.Errorf("integrationProfile provided to Apply must not be nil")
	}
	data, err := json.Marshal(integrationProfile)
	if err != nil {
		return nil, err
	}
	name := integrationProfile.Name
	if name == nil {
		return nil, fmt.Errorf("integrationProfile.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(integrationprofilesResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1.IntegrationProfile{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IntegrationProfile), err
}
