/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.TypeTokens;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

class SanityChecks {
    SanityChecks() {
    }

    static void check() {
        SanityChecks.checkGuava();
    }

    static void checkGuava() {
        ParameterizedType pType;
        Type[] types;
        boolean resolved = false;
        TypeToken<Map<String, String>> mapOfString = TypeTokens.mapOf(String.class, String.class);
        Type type = mapOfString.getType();
        if (type instanceof ParameterizedType && (types = (pType = (ParameterizedType)type).getActualTypeArguments()).length == 2) {
            TypeToken valueType = TypeToken.of((Type)types[1]);
            resolved = valueType.getRawType().equals(String.class);
        }
        if (!resolved) {
            throw new IllegalStateException("Detected Guava issue #1635 which indicates that a version of Guava less than 16.01 is in use.  This introduces codec resolution issues and potentially other incompatibility issues in the driver.  Please upgrade to Guava 16.01 or later.");
        }
    }
}

