/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.exceptions.WriteFailureException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.net.IAsyncCallbackWithFailure;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.utils.concurrent.SimpleCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWriteResponseHandler<T>
implements IAsyncCallbackWithFailure<T> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractWriteResponseHandler.class);
    private final SimpleCondition condition = new SimpleCondition();
    protected final Keyspace keyspace;
    protected final long start;
    protected final Collection<InetAddress> naturalEndpoints;
    public final ConsistencyLevel consistencyLevel;
    protected final Runnable callback;
    protected final Collection<InetAddress> pendingEndpoints;
    protected final WriteType writeType;
    private static final AtomicIntegerFieldUpdater<AbstractWriteResponseHandler> failuresUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractWriteResponseHandler.class, "failures");
    private volatile int failures = 0;

    protected AbstractWriteResponseHandler(Keyspace keyspace, Collection<InetAddress> naturalEndpoints, Collection<InetAddress> pendingEndpoints, ConsistencyLevel consistencyLevel, Runnable callback, WriteType writeType) {
        this.keyspace = keyspace;
        this.pendingEndpoints = pendingEndpoints;
        this.start = System.nanoTime();
        this.consistencyLevel = consistencyLevel;
        this.naturalEndpoints = naturalEndpoints;
        this.callback = callback;
        this.writeType = writeType;
    }

    public void get() throws WriteTimeoutException, WriteFailureException {
        boolean success;
        long requestTimeout = this.writeType == WriteType.COUNTER ? DatabaseDescriptor.getCounterWriteRpcTimeout() : DatabaseDescriptor.getWriteRpcTimeout();
        long timeout = TimeUnit.MILLISECONDS.toNanos(requestTimeout) - (System.nanoTime() - this.start);
        try {
            success = this.condition.await(timeout, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        if (!success) {
            int blockedFor = this.totalBlockFor();
            int acks = this.ackCount();
            if (acks >= blockedFor) {
                acks = blockedFor - 1;
            }
            throw new WriteTimeoutException(this.writeType, this.consistencyLevel, acks, blockedFor);
        }
        if (this.totalBlockFor() + this.failures > this.totalEndpoints()) {
            throw new WriteFailureException(this.consistencyLevel, this.ackCount(), this.failures, this.totalBlockFor(), this.writeType);
        }
    }

    protected int totalBlockFor() {
        return this.consistencyLevel.blockFor(this.keyspace) + this.pendingEndpoints.size();
    }

    protected int totalEndpoints() {
        if (this.consistencyLevel != null && this.consistencyLevel.isDatacenterLocal()) {
            return this.consistencyLevel.countLocalEndpoints(Iterables.concat(this.naturalEndpoints, this.pendingEndpoints));
        }
        return this.naturalEndpoints.size() + this.pendingEndpoints.size();
    }

    protected boolean waitingFor(InetAddress from) {
        return true;
    }

    protected abstract int ackCount();

    @Override
    public abstract void response(MessageIn<T> var1);

    public void assureSufficientLiveNodes() throws UnavailableException {
        this.consistencyLevel.assureSufficientLiveNodes(this.keyspace, Iterables.filter((Iterable)Iterables.concat(this.naturalEndpoints, this.pendingEndpoints), (Predicate)isAlive));
    }

    protected void signal() {
        this.condition.signalAll();
        if (this.callback != null) {
            this.callback.run();
        }
    }

    @Override
    public void onFailure(InetAddress from) {
        int n;
        logger.trace("Got failure from {}", (Object)from);
        int n2 = n = this.waitingFor(from) ? failuresUpdater.incrementAndGet(this) : this.failures;
        if (this.totalBlockFor() + n > this.totalEndpoints()) {
            this.signal();
        }
    }
}

